/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

@ConfiguratorRank(value=0)
public class DefaultJoranConfigurator
extends ContextAwareBase
implements Configurator {
    @Override
    public Configurator.ExecutionStatus configure(LoggerContext object) {
        object = this.performMultiStepConfigurationFileSearch(true);
        if (object != null) {
            try {
                this.configureByResource((URL)object);
            }
            catch (JoranException joranException) {
                object = joranException;
                joranException.printStackTrace();
            }
            return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    private URL performMultiStepConfigurationFileSearch(boolean bl) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject((Object)this);
        URL uRL = this.findConfigFileURLFromSystemProperties(classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource("logback-test.xml", classLoader, bl);
        if (uRL != null) {
            return uRL;
        }
        return this.getResource("logback.xml", classLoader, bl);
    }

    public void configureByResource(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        Object object = uRL.toString();
        if (object.endsWith("xml")) {
            object = new JoranConfigurator();
            object.setContext(this.context);
            object.doConfigure(uRL);
            return;
        }
        throw new LogbackException("Unexpected filename extension of file [" + uRL.toString() + "]. Should be .xml");
    }

    public URL findURLOfDefaultConfigurationFile(boolean bl) {
        return this.performMultiStepConfigurationFileSearch(bl);
    }

    private URL findConfigFileURLFromSystemProperties(ClassLoader classLoader, boolean bl) {
        String string = OptionHelper.getSystemProperty((String)"logback.configurationFile");
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
                if (uRL != null) {
                    URL uRL3 = uRL;
                    return uRL3;
                }
                Serializable serializable = new File(string);
                if (serializable.exists() && serializable.isFile()) {
                    try {
                        uRL = serializable.toURI().toURL();
                        serializable = uRL;
                        return serializable;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                if (bl) {
                    this.statusOnResourceSearch(string, classLoader, uRL);
                }
            }
        }
        return null;
    }

    private URL getResource(String string, ClassLoader classLoader, boolean bl) {
        URL uRL = Loader.getResource((String)string, (ClassLoader)classLoader);
        if (bl) {
            this.statusOnResourceSearch(string, classLoader, uRL);
        }
        return uRL;
    }

    private void statusOnResourceSearch(String string, ClassLoader classLoader, URL uRL) {
        StatusManager statusManager = this.context.getStatusManager();
        if (uRL == null) {
            statusManager.add((Status)new InfoStatus("Could NOT find resource [" + string + "]", (Object)this.context));
            return;
        }
        statusManager.add((Status)new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", (Object)this.context));
        this.multiplicityWarning(string, classLoader);
    }

    private void multiplicityWarning(String string, ClassLoader object) {
        Object object2 = null;
        try {
            object2 = Loader.getResources((String)string, (ClassLoader)object);
        }
        catch (IOException iOException) {
            this.addError("Failed to get url list for resource [" + string + "]", iOException);
        }
        if (object2 != null && object2.size() > 1) {
            this.addWarn("Resource [" + string + "] occurs multiple times on the classpath.");
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (URL)object.next();
                this.addWarn("Resource [" + string + "] occurs at [" + ((URL)object2).toString() + "]");
            }
        }
    }
}

