/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.e.a.g;
import org.e.a.i;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.util.StringUtils;

@Deprecated
public class Chat {
    private final ChatManager chatManager;
    private final String threadID;
    private final g participant;
    private final Set<ChatMessageListener> listeners = new CopyOnWriteArraySet<ChatMessageListener>();

    Chat(ChatManager chatManager, g g2, String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Thread ID must not be null");
        }
        this.chatManager = chatManager;
        this.participant = g2;
        this.threadID = string;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public g getParticipant() {
        return this.participant;
    }

    public void sendMessage(String string) {
        string = StanzaBuilder.buildMessage().setBody(string);
        this.sendMessage((MessageBuilder)string);
    }

    public void sendMessage(MessageBuilder messageBuilder) {
        messageBuilder.to((i)this.participant);
        messageBuilder.ofType(Message.Type.chat);
        messageBuilder.setThread(this.threadID);
        this.chatManager.sendMessage(this, messageBuilder.build());
    }

    public void sendMessage(Message message) {
        message.setTo((i)this.participant);
        message.setType(Message.Type.chat);
        message.setThread(this.threadID);
        this.chatManager.sendMessage(this, message);
    }

    public void addMessageListener(ChatMessageListener chatMessageListener) {
        if (chatMessageListener == null) {
            return;
        }
        this.listeners.add(chatMessageListener);
    }

    public void removeMessageListener(ChatMessageListener chatMessageListener) {
        this.listeners.remove(chatMessageListener);
    }

    public void close() {
        this.chatManager.closeChat(this);
        this.listeners.clear();
    }

    public Set<ChatMessageListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public StanzaCollector createCollector() {
        return this.chatManager.createStanzaCollector(this);
    }

    void deliver(Message message) {
        message.setThread(this.threadID);
        for (ChatMessageListener chatMessageListener : this.listeners) {
            chatMessageListener.processMessage(this, message);
        }
    }

    public String toString() {
        return "Chat [(participant=" + this.participant + "), (thread=" + this.threadID + ")]";
    }

    public int hashCode() {
        int n = 31 + this.threadID.hashCode();
        n = n * 31 + this.participant.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Chat && this.threadID.equals(((Chat)object).getThreadID()) && this.participant.a((CharSequence)((Chat)object).getParticipant());
    }
}

