/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.List;
import org.e.a.a;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.EqualsUtil;

public final class RosterEntry
extends Manager {
    private RosterPacket.Item item;
    private final Roster roster;

    RosterEntry(RosterPacket.Item item, Roster roster, XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.item = item;
        this.roster = roster;
    }

    @Deprecated
    public final String getUser() {
        return this.getJid().toString();
    }

    public final a getJid() {
        return this.item.getJid();
    }

    public final String getName() {
        return this.item.getName();
    }

    public final synchronized void setName(String string) {
        if (string != null && string.equals(this.getName())) {
            return;
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        rosterPacket.addRosterItem(RosterEntry.toRosterItem(this, string));
        this.connection().createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
        this.item.setName(string);
    }

    final void updateItem(RosterPacket.Item item) {
        assert (item != null);
        this.item = item;
    }

    public final boolean isApproved() {
        return this.item.isApproved();
    }

    public final List<RosterGroup> getGroups() {
        ArrayList<RosterGroup> arrayList = new ArrayList<RosterGroup>();
        for (RosterGroup rosterGroup : this.roster.getGroups()) {
            if (!rosterGroup.contains(this)) continue;
            arrayList.add(rosterGroup);
        }
        return arrayList;
    }

    public final RosterPacket.ItemType getType() {
        return this.item.getItemType();
    }

    public final boolean isSubscriptionPending() {
        return this.item.isSubscriptionPending();
    }

    public final boolean canSeeMyPresence() {
        switch (this.getType()) {
            case from: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public final boolean canSeeHisPresence() {
        switch (this.getType()) {
            case both: 
            case to: {
                return true;
            }
        }
        return false;
    }

    public final void cancelSubscription() {
        XMPPConnection xMPPConnection = this.connection();
        Presence presence = ((PresenceBuilder)xMPPConnection.getStanzaFactory().buildPresenceStanza().to((i)this.item.getJid())).ofType(Presence.Type.unsubscribed).build();
        xMPPConnection.sendStanza((Stanza)presence);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getName() != null) {
            stringBuilder.append(this.getName()).append(": ");
        }
        stringBuilder.append((CharSequence)this.getJid());
        Object object = this.getGroups();
        if (!object.isEmpty()) {
            stringBuilder.append(" [");
            object = object.iterator();
            RosterGroup rosterGroup = (RosterGroup)((Object)object.next());
            stringBuilder.append(rosterGroup.getName());
            while (object.hasNext()) {
                stringBuilder.append(", ");
                rosterGroup = (RosterGroup)((Object)object.next());
                stringBuilder.append(rosterGroup.getName());
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return this.getJid().hashCode();
    }

    public final boolean equals(Object object) {
        return EqualsUtil.equals((Object)((Object)this), (Object)object, (builder, rosterEntry) -> builder.append((Object)this.getJid(), (Object)rosterEntry.getJid()));
    }

    public final boolean equalsDeep(Object object) {
        return EqualsUtil.equals((Object)((Object)this), (Object)object, (builder, rosterEntry) -> builder.append((Object)this.item, (Object)rosterEntry.item));
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry) {
        RosterEntry rosterEntry2 = rosterEntry;
        return RosterEntry.toRosterItem(rosterEntry2, rosterEntry2.getName(), false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry, String string) {
        return RosterEntry.toRosterItem(rosterEntry, string, false);
    }

    static RosterPacket.Item toRosterItem(RosterEntry rosterEntry, boolean bl) {
        RosterEntry rosterEntry2 = rosterEntry;
        return RosterEntry.toRosterItem(rosterEntry2, rosterEntry2.getName(), bl);
    }

    private static RosterPacket.Item toRosterItem(RosterEntry object, String object2, boolean bl) {
        object2 = new RosterPacket.Item(((RosterEntry)((Object)object)).getJid(), (String)object2);
        ((RosterPacket.Item)object2).setItemType(((RosterEntry)((Object)object)).getType());
        if (bl) {
            ((RosterPacket.Item)object2).setSubscriptionPending(((RosterEntry)((Object)object)).isSubscriptionPending());
        }
        ((RosterPacket.Item)object2).setApproved(((RosterEntry)((Object)object)).isApproved());
        for (RosterGroup rosterGroup : ((RosterEntry)((Object)object)).getGroups()) {
            ((RosterPacket.Item)object2).addGroupName(rosterGroup.getName());
        }
        return object2;
    }
}

