/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 j2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0006jklmnoB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\tJ\b\u0010E\u001a\u00020FH\u0016J\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0002J\u0010\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u0002H\u0016J\u0010\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u0003H\u0016J\u000e\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020\u0002J\u0006\u0010\u0010\u001a\u00020\u0017J\u0013\u0010N\u001a\u00020\u000b2\b\u0010O\u001a\u0004\u0018\u00010PH\u0096\u0002J\u0017\u0010Q\u001a\u0004\u0018\u00010\u00022\b\u0010K\u001a\u0004\u0018\u00010P\u00a2\u0006\u0002\u0010RJ\u0018\u0010Q\u001a\u00020\u00022\b\u0010K\u001a\u0004\u0018\u00010P2\u0006\u0010S\u001a\u00020\u0002J\u0018\u0010T\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010UJ\"\u0010T\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\u00022\b\u0010V\u001a\u0004\u0018\u00010\u0003H\u0086\u0002\u00a2\u0006\u0002\u0010WJ\b\u0010X\u001a\u00020\u0002H\u0016J\b\u0010Y\u001a\u00020\u000bH\u0016J\u0006\u0010\"\u001a\u00020%J\u0010\u0010Z\u001a\u00020\u00022\u0006\u0010I\u001a\u00020\u0002H\u0002J\u0006\u0010[\u001a\u00020\u000bJ\u0010\u0010\\\u001a\u00020\u00022\u0006\u0010]\u001a\u00020\u0002H\u0004J\u001f\u0010^\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010_J\u000e\u0010`\u001a\u00020F2\u0006\u0010\b\u001a\u00020\u0000J\u001e\u0010`\u001a\u00020F2\u0014\u0010a\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030bH\u0016J\u0018\u0010c\u001a\u00020F2\u0006\u0010I\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u0003H\u0002J\u0017\u0010d\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010UJ\u0010\u0010e\u001a\u00020F2\u0006\u0010f\u001a\u00020\u0002H\u0002J\u000e\u0010g\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0002J\b\u0010h\u001a\u00020iH\u0016J\u0006\u00109\u001a\u00020>R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR,\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00120\u00118VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0004\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u0014\u0010/\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010)R\u000e\u00101\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006p"}, d2={"Ldorkbox/collections/IntFloatMap;", "", "", "", "()V", "initialCapacity", "loadFactor", "(IF)V", "map", "(Ldorkbox/collections/IntFloatMap;)V", "allocateIterators", "", "getAllocateIterators", "()Z", "setAllocateIterators", "(Z)V", "entries", "", "", "getEntries$annotations", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/IntFloatMap$Entries;", "entries2", "hasZeroValue", "getHasZeroValue", "setHasZeroValue", "keyTable", "", "getKeyTable", "()[I", "setKeyTable", "([I)V", "keys", "getKeys", "keys1", "Ldorkbox/collections/IntFloatMap$Keys;", "keys2", "mask", "getMask", "()I", "setMask", "(I)V", "shift", "getShift", "setShift", "size", "getSize", "size_", "threshold", "valueTable", "", "getValueTable", "()[F", "setValueTable", "([F)V", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/IntFloatMap$Values;", "values2", "zeroValue", "getZeroValue", "()F", "setZeroValue", "(F)V", "clear", "", "maximumCapacity", "containsKey", "key", "containsValue", "value", "ensureCapacity", "additionalCapacity", "equals", "other", "", "findKey", "(Ljava/lang/Object;)Ljava/lang/Integer;", "notFound", "get", "(I)Ljava/lang/Float;", "defaultValue", "(ILjava/lang/Float;)Ljava/lang/Float;", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "(IF)Ljava/lang/Float;", "putAll", "from", "", "putResize", "remove", "resize", "newSize", "shrink", "toString", "", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
public final class IntFloatMap
implements Map<Integer, Float>,
KMutableMap {
    public static final Companion Companion = new Companion(null);
    private boolean allocateIterators;
    private int size_;
    private int[] keyTable;
    private float[] valueTable;
    private float zeroValue;
    private boolean hasZeroValue;
    private final float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    private transient Entries entries1;
    private transient Entries entries2;
    private transient Values values1;
    private transient Values values2;
    private transient Keys keys1;
    private transient Keys keys2;
    public static final String version = "2.8";

    public final boolean getAllocateIterators() {
        return this.allocateIterators;
    }

    public final void setAllocateIterators(boolean bl) {
        this.allocateIterators = bl;
    }

    public final int[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.keyTable = nArray;
    }

    public final float[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        this.valueTable = fArray;
    }

    public final float getZeroValue() {
        return this.zeroValue;
    }

    public final void setZeroValue(float f) {
        this.zeroValue = f;
    }

    public final boolean getHasZeroValue() {
        return this.hasZeroValue;
    }

    public final void setHasZeroValue(boolean bl) {
        this.hasZeroValue = bl;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    public IntFloatMap() {
        this(51, 0.8f);
    }

    public IntFloatMap(int n, float f) {
        if (f <= 0.0f || f >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + f);
        }
        this.loadFactor = f;
        n = ObjectSet.Companion.tableSize(n, f);
        this.threshold = (int)((float)n * f);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new int[n];
        this.valueTable = new float[n];
    }

    public /* synthetic */ IntFloatMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public IntFloatMap(IntFloatMap intFloatMap) {
        Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
        this((int)((float)intFloatMap.keyTable.length * intFloatMap.loadFactor), intFloatMap.loadFactor);
        System.arraycopy(intFloatMap.keyTable, 0, this.keyTable, 0, intFloatMap.keyTable.length);
        System.arraycopy(intFloatMap.valueTable, 0, this.valueTable, 0, intFloatMap.valueTable.length);
        this.size_ = intFloatMap.size_;
        this.zeroValue = intFloatMap.zeroValue;
        this.hasZeroValue = intFloatMap.hasZeroValue;
    }

    protected final int place(int n) {
        return (int)((long)n * -7046029254386353131L >>> this.shift);
    }

    private final int locateKey(int n) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        int n3;
        while ((n3 = nArray[n2]) != 0) {
            if (n3 == n) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    @Override
    public final Float put(int n, float f) {
        if (n == 0) {
            float f2 = this.zeroValue;
            this.zeroValue = f;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                n = this.size_;
                this.size_ = n + 1;
            }
            return Float.valueOf(f2);
        }
        int n2 = this.locateKey(n);
        if (n2 >= 0) {
            float f3 = this.valueTable[n2];
            this.valueTable[n2] = f;
            return Float.valueOf(f3);
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = n;
        this.valueTable[n2] = f;
        ++this.size_;
        if (this.size_ >= this.threshold) {
            IntFloatMap intFloatMap = this;
            intFloatMap.resize(intFloatMap.keyTable.length << 1);
        }
        return null;
    }

    public final void putAll(IntFloatMap object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.ensureCapacity(((IntFloatMap)object).size_);
        if (((IntFloatMap)object).hasZeroValue) {
            this.put(0, ((IntFloatMap)object).zeroValue);
        }
        int[] nArray = ((IntFloatMap)object).keyTable;
        object = ((IntFloatMap)object).valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            this.put(n2, (float)object[i]);
        }
    }

    private final void putResize(int n, float f) {
        int[] nArray = this.keyTable;
        int n2 = this.place(n);
        while (true) {
            if (nArray[n2] == 0) {
                nArray[n2] = n;
                this.valueTable[n2] = f;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public final Float get(int n) {
        if (n == 0) {
            if (this.hasZeroValue) {
                return Float.valueOf(this.zeroValue);
            }
            return null;
        }
        if ((n = this.locateKey(n)) >= 0) {
            return Float.valueOf(this.valueTable[n]);
        }
        return null;
    }

    public final Float get(int n, Float f) {
        if (n == 0) {
            if (this.hasZeroValue) {
                return Float.valueOf(this.zeroValue);
            }
            return f;
        }
        if ((n = this.locateKey(n)) >= 0) {
            return Float.valueOf(this.valueTable[n]);
        }
        return f;
    }

    public final Float remove(int n) {
        int n2;
        if (n == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            this.hasZeroValue = false;
            float f = this.zeroValue;
            this.zeroValue = 0.0f;
            int n3 = this.size_;
            this.size_ = n3 + -1;
            return Float.valueOf(f);
        }
        if ((n = this.locateKey(n)) < 0) {
            return null;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        float f = this.valueTable[n];
        int n4 = this.mask;
        int n5 = n + 1 & n4;
        while (true) {
            int n6 = n2 = nArray[n5];
            n6 = n2;
            if (n2 == 0) break;
            n2 = this.place(n6);
            if ((n5 - n2 & n4) > (n - n2 & n4)) {
                nArray[n] = n6;
                fArray[n] = fArray[n5];
                n = n5;
            }
            n5 = n5 + 1 & n4;
        }
        nArray[n] = 0;
        fArray[n] = 0.0f;
        n2 = this.size_;
        this.size_ = n2 + -1;
        return Float.valueOf(f);
    }

    public final boolean notEmpty() {
        return this.size_ > 0;
    }

    @Override
    public final boolean isEmpty() {
        return this.size_ == 0;
    }

    @Override
    public final void putAll(Map<? extends Integer, ? extends Float> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"");
        this.ensureCapacity(iterator.size());
        iterator = iterator.entrySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (Map.Entry)object;
            int n = ((Number)object.getKey()).intValue();
            float f = ((Number)object.getValue()).floatValue();
            this.put(n, f);
        }
    }

    public final void shrink(int n) {
        if (n < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + n);
        }
        if (this.keyTable.length > (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.resize(n);
        }
    }

    public final void clear(int n) {
        if (this.keyTable.length <= (n = ObjectSet.Companion.tableSize(n, this.loadFactor))) {
            this.clear();
            return;
        }
        this.size_ = 0;
        this.hasZeroValue = false;
        this.zeroValue = 0.0f;
        this.resize(n);
    }

    public final Set<Map.Entry<Integer, Float>> getEntries() {
        Entries entries = this.entries();
        Intrinsics.checkNotNull((Object)entries);
        return TypeIntrinsics.asMutableSet((Object)entries);
    }

    public static /* synthetic */ void getEntries$annotations() {
    }

    public final Set<Integer> getKeys() {
        return this.keys();
    }

    public final int getSize() {
        return this.size_;
    }

    public final Collection<Float> getValues() {
        return this.values();
    }

    @Override
    public final void clear() {
        if (this.size_ == 0) {
            return;
        }
        this.size_ = 0;
        Arrays.fill(this.keyTable, 0);
        Arrays.fill(this.valueTable, 0.0f);
        this.zeroValue = 0.0f;
        this.hasZeroValue = false;
    }

    public final boolean containsValue(float f) {
        float[] fArray = this.valueTable;
        if (f == 0.0f) {
            if (this.hasZeroValue && this.zeroValue == 0.0f) {
                return true;
            }
            int[] nArray = this.keyTable;
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n2;
                    if (nArray[n2 = n--] == 0 || !(fArray[n2] == 0.0f)) continue;
                    return true;
                } while (n >= 0);
            }
        } else {
            if (f == this.zeroValue) {
                return true;
            }
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n3;
                    if (!(fArray[n3 = n--] == f)) continue;
                    return true;
                } while (n >= 0);
            }
        }
        return false;
    }

    public final boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        return this.locateKey(n) >= 0;
    }

    public final Integer findKey(Object object) {
        float[] fArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == 0.0f) {
                return 0;
            }
            int[] nArray = this.keyTable;
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n2;
                    if (nArray[n2 = n--] == 0 || !(fArray[n2] == 0.0f)) continue;
                    return nArray[n2];
                } while (n >= 0);
            }
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)Float.valueOf(this.zeroValue))) {
                return 0;
            }
            int n = fArray.length + -1;
            if (n >= 0) {
                do {
                    int n3;
                    if (!Intrinsics.areEqual((Object)Float.valueOf(fArray[n3 = n--]), (Object)object)) continue;
                    return this.keyTable[n3];
                } while (n >= 0);
            }
        }
        return null;
    }

    public final int findKey(Object object, int n) {
        Integer n2 = this.findKey(object);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public final void ensureCapacity(int n) {
        if (this.keyTable.length < (n = ObjectSet.Companion.tableSize(this.size_ + n, this.loadFactor))) {
            this.resize(n);
        }
    }

    private final void resize(int n) {
        int n2 = this.keyTable.length;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        this.keyTable = new int[n];
        this.valueTable = new float[n];
        if (this.size_ > 0) {
            for (n = 0; n < n2; ++n) {
                int n3 = nArray[n];
                if (n3 == 0) continue;
                this.putResize(n3, fArray[n]);
            }
        }
    }

    @Override
    public final int hashCode() {
        int n = this.size_;
        if (this.hasZeroValue && !(this.zeroValue == 0.0f)) {
            n += Float.hashCode(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            n += n3 * 31;
            float f = fArray[i];
            if (f == 0.0f) continue;
            n += Float.hashCode(f);
        }
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntFloatMap)) {
            return false;
        }
        if (((IntFloatMap)object).size_ != this.size_) {
            return false;
        }
        if (((IntFloatMap)object).hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (((IntFloatMap)object).zeroValue == 0.0f ? !(this.zeroValue == 0.0f) : !(((IntFloatMap)object).zeroValue == this.zeroValue))) {
            return false;
        }
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            float f = fArray[i];
            boolean bl = f == 0.0f;
            if (!(bl ? ((IntFloatMap)object).get((Object)n2) != null : !Intrinsics.areEqual((float)f, (Float)((Float)((IntFloatMap)object).get((Object)n2))))) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        int n;
        if (this.size_ == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        float[] fArray = this.valueTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                stringBuilder.append('=');
                stringBuilder.append(fArray[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(fArray[n2]);
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final Entries entries() {
        if (this.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries entries = this.entries1;
        Intrinsics.checkNotNull((Object)entries);
        if (!entries.getValid()) {
            Entries entries2 = this.entries1;
            Intrinsics.checkNotNull((Object)entries2);
            entries2.reset();
            Entries entries3 = this.entries1;
            Intrinsics.checkNotNull((Object)entries3);
            entries3.setValid(true);
            Entries entries4 = this.entries2;
            Intrinsics.checkNotNull((Object)entries4);
            entries4.setValid(false);
            Entries entries5 = this.entries1;
            Intrinsics.checkNotNull((Object)entries5);
            return entries5;
        }
        Entries entries6 = this.entries2;
        Intrinsics.checkNotNull((Object)entries6);
        entries6.reset();
        Entries entries7 = this.entries2;
        Intrinsics.checkNotNull((Object)entries7);
        entries7.setValid(true);
        Entries entries8 = this.entries1;
        Intrinsics.checkNotNull((Object)entries8);
        entries8.setValid(false);
        Entries entries9 = this.entries2;
        Intrinsics.checkNotNull((Object)entries9);
        return entries9;
    }

    public final Values values() {
        if (this.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        Values values = this.values1;
        Intrinsics.checkNotNull((Object)values);
        if (!values.getValid()) {
            Values values2 = this.values1;
            Intrinsics.checkNotNull((Object)values2);
            values2.reset();
            Values values3 = this.values1;
            Intrinsics.checkNotNull((Object)values3);
            values3.setValid(true);
            Values values4 = this.values2;
            Intrinsics.checkNotNull((Object)values4);
            values4.setValid(false);
            Values values5 = this.values1;
            Intrinsics.checkNotNull((Object)values5);
            return values5;
        }
        Values values6 = this.values2;
        Intrinsics.checkNotNull((Object)values6);
        values6.reset();
        Values values7 = this.values2;
        Intrinsics.checkNotNull((Object)values7);
        values7.setValid(true);
        Values values8 = this.values1;
        Intrinsics.checkNotNull((Object)values8);
        values8.setValid(false);
        Values values9 = this.values2;
        Intrinsics.checkNotNull((Object)values9);
        return values9;
    }

    public final Keys keys() {
        if (this.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys keys = this.keys1;
        Intrinsics.checkNotNull((Object)keys);
        if (!keys.getValid()) {
            Keys keys2 = this.keys1;
            Intrinsics.checkNotNull((Object)keys2);
            keys2.reset();
            Keys keys3 = this.keys1;
            Intrinsics.checkNotNull((Object)keys3);
            keys3.setValid(true);
            Keys keys4 = this.keys2;
            Intrinsics.checkNotNull((Object)keys4);
            keys4.setValid(false);
            Keys keys5 = this.keys1;
            Intrinsics.checkNotNull((Object)keys5);
            return keys5;
        }
        Keys keys6 = this.keys2;
        Intrinsics.checkNotNull((Object)keys6);
        keys6.reset();
        Keys keys7 = this.keys2;
        Intrinsics.checkNotNull((Object)keys7);
        keys7.setValid(true);
        Keys keys8 = this.keys1;
        Intrinsics.checkNotNull((Object)keys8);
        keys8.setValid(false);
        Keys keys9 = this.keys2;
        Intrinsics.checkNotNull((Object)keys9);
        return keys9;
    }

    @Override
    public final /* synthetic */ Object put(Object object, Object object2) {
        return this.put(((Number)object).intValue(), ((Number)object2).floatValue());
    }

    @Override
    public final /* synthetic */ Object get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final Float get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.get(((Number)object).intValue());
    }

    @Override
    public final /* synthetic */ Object remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final Float remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        return this.remove(((Number)object).intValue());
    }

    @Override
    public final Set<Map.Entry<Integer, Float>> entrySet() {
        return this.getEntries();
    }

    @Override
    public final Set<Integer> keySet() {
        return this.getKeys();
    }

    @Override
    public final int size() {
        return this.getSize();
    }

    @Override
    public final Collection<Float> values() {
        return this.getValues();
    }

    @Override
    public final boolean containsValue(Object object) {
        if (!(object instanceof Float)) {
            return false;
        }
        return this.containsValue(((Number)object).floatValue());
    }

    @Override
    public final boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.containsKey(((Number)object).intValue());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/IntFloatMap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\t\u0010\u001a\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Ldorkbox/collections/IntFloatMap$Entries;", "", "Ldorkbox/collections/IntFloatMap$Entry;", "Ldorkbox/collections/IntFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "entry", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "remove", "removeAll", "retainAll", "Collections"})
    public static final class Entries
    extends MapIterator<Integer, Entry>
    implements Set<Entry>,
    KMutableSet {
        private final Entry entry;

        public Entries(IntFloatMap intFloatMap) {
            Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
            super(intFloatMap);
            this.entry = new Entry(intFloatMap);
        }

        @Override
        public final Entry next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.getMap().getKeyTable();
            if (this.getNextIndex() == -1) {
                this.entry.setKey(0);
                this.entry.setValue(this.getMap().getZeroValue());
            } else {
                this.entry.setKey(nArray[this.getNextIndex()]);
                this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            }
            Entries entries = this;
            entries.setCurrentIndex(entries.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final boolean add(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            this.getMap().put(entry.getKey(), entry.getValue().floatValue());
            return true;
        }

        @Override
        public final boolean addAll(Collection<? extends Entry> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                this.getMap().put(((Entry)object2).getKey(), ((Entry)object2).getValue().floatValue());
                bl = true;
            }
            return bl;
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                int n = ((Number)((Map.Entry)object2).getKey()).intValue();
                float f = ((Number)((Map.Entry)object2).getValue()).floatValue();
                if (Intrinsics.areEqual((Float)((Float)this.getMap().get((Object)n)), (float)f)) continue;
                return false;
            }
            return true;
        }

        public final boolean contains(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            return Intrinsics.areEqual((Float)((Float)this.getMap().get(entry.getKey())), (float)entry.getValue().floatValue());
        }

        @Override
        public final Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            if (this.getMap().getHasZeroValue()) {
                boolean bl2;
                Object v0;
                block5: {
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        Entry entry = (Entry)t;
                        if (!(entry.getKey() == 0)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                if (bl2 = v0 != null) {
                    bl = this.getMap().remove((Object)0) != null;
                }
            }
            int[] nArray = this.getMap().getKeyTable();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Object v1;
                int n2;
                int n3;
                block6: {
                    n2 = n3 = nArray[i];
                    if (n3 == 0) continue;
                    Object object = collection;
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Entry entry = (Entry)e;
                        if (!(entry.getKey() == n2)) continue;
                        v1 = e;
                        break block6;
                    }
                    v1 = null;
                }
                if ((n3 = v1 != null ? 1 : 0) != 0) continue;
                bl = this.getMap().remove((Object)n2) != null || bl;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                object2 = (Entry)object2;
                int n = ((Number)((Map.Entry)object2).getKey()).intValue();
                bl = this.getMap().remove((Object)n) != null || bl;
            }
            this.reset();
            return bl;
        }

        public final boolean remove(Entry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"");
            boolean bl = this.getMap().remove(this.entry.getKey()) != null;
            this.reset();
            return bl;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0007\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ldorkbox/collections/IntFloatMap$Entry;", "", "", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "key", "getKey", "()Ljava/lang/Integer;", "setKey", "(I)V", "getMap", "()Ldorkbox/collections/IntFloatMap;", "value", "getValue", "()Ljava/lang/Float;", "setValue", "(F)V", "newValue", "(F)Ljava/lang/Float;", "toString", "", "Collections"})
    public static final class Entry
    implements Map.Entry<Integer, Float>,
    KMutableMap.Entry {
        private final IntFloatMap map;
        private int key;
        private float value;

        public Entry(IntFloatMap intFloatMap) {
            Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
            this.map = intFloatMap;
        }

        public final IntFloatMap getMap() {
            return this.map;
        }

        @Override
        public final Integer getKey() {
            return this.key;
        }

        public final void setKey(int n) {
            this.key = n;
        }

        @Override
        public final Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public final void setValue(float f) {
            this.value = f;
        }

        @Override
        public final Float setValue(float f) {
            float f2 = this.getValue().floatValue();
            Float f3 = Float.valueOf(f);
            ((Map)this.map).put(this.getKey(), f3);
            this.setValue(f);
            return Float.valueOf(f2);
        }

        public final String toString() {
            return "" + this.getKey() + '=' + this.getValue().floatValue();
        }

        @Override
        public final /* synthetic */ Object setValue(Object object) {
            return this.setValue(((Number)object).floatValue());
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\t\u0010\u0014\u001a\u00020\u000bH\u0096\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0096\u0002J\u000e\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0016\u0010\u001d\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\u0007\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntFloatMap$Keys;", "", "", "Ldorkbox/collections/IntFloatMap$MapIterator;", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Integer;", "remove", "(Ljava/lang/Integer;)Z", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    public static final class Keys
    extends MapIterator<Integer, Integer>
    implements Set<Integer>,
    KMutableSet {
        public Keys(IntFloatMap intFloatMap) {
            Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
            super(intFloatMap);
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final Integer next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.getNextIndex() == -1 ? 0 : this.getMap().getKeyTable()[this.getNextIndex()];
            Keys keys = this;
            keys.setCurrentIndex(keys.getNextIndex());
            this.findNextIndex();
            return n;
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
        }

        @Override
        public final boolean addAll(Collection<? extends Integer> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                bl = bl || this.getMap().put(n, 0.0f) == null;
            }
            return bl;
        }

        @Override
        public final boolean add(int n) {
            return this.getMap().put(n, 0.0f) == null;
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().size_ == 0;
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                if (this.getMap().containsKey((Object)n)) continue;
                return false;
            }
            return true;
        }

        public final boolean contains(int n) {
            return this.getMap().containsKey((Object)n);
        }

        @Override
        public final Iterator<Integer> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (int n : this.getMap().getKeyTable()) {
                if (collection.contains(n) || this.getMap().remove((Object)n) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                int n = ((Number)e).intValue();
                if (this.getMap().remove((Object)n) != null) continue;
                bl = true;
            }
            this.reset();
            return bl;
        }

        public final boolean remove(Integer n) {
            return this.getMap().remove(n) == null;
        }

        public final int[] toArray() {
            int[] nArray = new int[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        public final int[] toArray(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            int n = 0;
            while (this.getHasNext()) {
                nArray[n++] = this.next();
            }
            return nArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).intValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Integer)) {
                return false;
            }
            return this.contains(((Number)object).intValue());
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000  *\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004:\u0001 B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\rR\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006!"}, d2={"Ldorkbox/collections/IntFloatMap$MapIterator;", "V", "I", "", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/IntFloatMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Companion", "Collections"})
    public static abstract class MapIterator<V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        public static final Companion Companion = new Companion(null);
        private final IntFloatMap map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;
        private static final int INDEX_ILLEGAL = -2;
        public static final int INDEX_ZERO = -1;

        public MapIterator(IntFloatMap intFloatMap) {
            Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
            this.map = intFloatMap;
            this.valid = true;
            this.reset();
        }

        public final IntFloatMap getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public final void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.getHasZeroValue()) {
                this.hasNext = true;
                return;
            }
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                int[] nArray = this.map.getKeyTable();
                int n = nArray.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (nArray[this.nextIndex] == 0);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            int n;
            int n2 = this.currentIndex;
            if (n2 == -1 && this.map.getHasZeroValue()) {
                this.map.setHasZeroValue(false);
                this.map.setZeroValue(0.0f);
                return;
            }
            if (n2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            int[] nArray = this.map.getKeyTable();
            float[] fArray = this.map.getValueTable();
            int n3 = this.map.getMask();
            int n4 = n2 + 1 & n3;
            while (true) {
                int n5;
                n = n5 = nArray[n4];
                n = n5;
                if (n5 == 0) break;
                n5 = this.map.place(n);
                if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                    nArray[n2] = n;
                    fArray[n2] = fArray[n4];
                    n2 = n4;
                }
                n4 = n4 + 1 & n3;
            }
            nArray[n2] = 0;
            fArray[n2] = 0.0f;
            if (n2 != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -2;
            IntFloatMap intFloatMap = this.map;
            n = intFloatMap.size_;
            intFloatMap.size_ = n + -1;
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldorkbox/collections/IntFloatMap$MapIterator$Companion;", "", "()V", "INDEX_ILLEGAL", "", "INDEX_ZERO", "Collections"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\t\u0010\u0015\u001a\u00020\fH\u0096\u0002J\b\u0010\u0016\u001a\u00020\fH\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0016\u0010\u001d\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Ldorkbox/collections/IntFloatMap$Values;", "", "", "Ldorkbox/collections/IntFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/IntFloatMap;", "(Ldorkbox/collections/IntFloatMap;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "", "next", "()Ljava/lang/Float;", "remove", "removeAll", "retainAll", "toArray", "", "Collections"})
    public static final class Values
    extends MapIterator<Integer, Float>
    implements Collection<Float>,
    KMutableCollection {
        public Values(IntFloatMap intFloatMap) {
            Intrinsics.checkNotNullParameter((Object)intFloatMap, (String)"");
            super(intFloatMap);
        }

        @Override
        public final boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public final Float next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            float f = this.getNextIndex() == -1 ? this.getMap().getZeroValue() : this.getMap().getValueTable()[this.getNextIndex()];
            Values values = this;
            values.setCurrentIndex(values.getNextIndex());
            this.findNextIndex();
            return Float.valueOf(f);
        }

        public final int getSize() {
            return this.getMap().size_;
        }

        @Override
        public final void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public final boolean addAll(Collection<? extends Float> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public final boolean add(float f) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public final boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public final boolean containsAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                float f = ((Number)e).floatValue();
                if (this.getMap().containsValue(Float.valueOf(f))) continue;
                return false;
            }
            return true;
        }

        public final boolean contains(float f) {
            return this.getMap().containsValue(Float.valueOf(f));
        }

        @Override
        public final Iterator<Float> iterator() {
            return this;
        }

        @Override
        public final boolean retainAll(Collection<? extends Object> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"");
            boolean bl = false;
            for (int n : this.getMap().getKeyTable()) {
                Float f;
                int n2 = n;
                n2 = n;
                if (n == 0 || CollectionsKt.contains((Iterable)collection, (Object)(f = (Float)this.getMap().get((Object)n2)))) continue;
                this.getMap().remove((Object)n2);
                bl = true;
            }
            this.reset();
            return bl;
        }

        @Override
        public final boolean removeAll(Collection<? extends Object> object) {
            Intrinsics.checkNotNullParameter(object, (String)"");
            boolean bl = false;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                float f = ((Number)object2).floatValue();
                object2 = this.getMap().findKey(Float.valueOf(f));
                if (object2 == null) continue;
                bl = this.getMap().remove(object2) != null || bl;
            }
            this.reset();
            return bl;
        }

        public final boolean remove(float f) {
            boolean bl = false;
            Integer n = this.getMap().findKey(Float.valueOf(f));
            if (n != null) {
                bl = this.getMap().remove(n) != null;
            }
            this.reset();
            return bl;
        }

        public final float[] toArray() {
            float[] fArray = new float[this.getMap().size()];
            int n = 0;
            while (this.hasNext()) {
                fArray[n++] = this.next().floatValue();
            }
            return fArray;
        }

        @Override
        public final int size() {
            return this.getSize();
        }

        @Override
        public final /* synthetic */ boolean add(Object object) {
            return this.add(((Number)object).floatValue());
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Float)) {
                return false;
            }
            return this.contains(((Number)object).floatValue());
        }

        @Override
        public final boolean remove(Object object) {
            if (!(object instanceof Float)) {
                return false;
            }
            return this.remove(((Number)object).floatValue());
        }

        @Override
        public final <T> T[] toArray(T[] TArray) {
            Intrinsics.checkNotNullParameter(TArray, (String)"");
            return CollectionToArray.toArray((Collection)this, (Object[])TArray);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

