/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.compression.XmppCompressionFactory;

public final class ZlibXmppCompressionFactory
extends XmppCompressionFactory {
    public static final ZlibXmppCompressionFactory INSTANCE = new ZlibXmppCompressionFactory();

    private ZlibXmppCompressionFactory() {
        super("zlib", 100);
    }

    @Override
    public final XmppInputOutputFilter fabricate(ConnectionConfiguration connectionConfiguration) {
        return new ZlibXmppInputOutputFilter();
    }

    public static final class Stats {
        public final long compressorInBytes;
        public final long compressorOutBytes;
        public final double compressionRatio;
        public final long decompressorInBytes;
        public final long decompressorOutBytes;
        public final double decompressionRatio;
        public final int maxOutputOutput;
        public final int maxInputOutput;
        public final int maxBytesWrittenAfterFullFlush;
        private transient String toStringCache;

        private Stats(ZlibXmppInputOutputFilter zlibXmppInputOutputFilter) {
            this.compressorOutBytes = zlibXmppInputOutputFilter.compressorOutBytes;
            this.compressorInBytes = zlibXmppInputOutputFilter.compressorInBytes;
            this.compressionRatio = (double)this.compressorOutBytes / (double)this.compressorInBytes;
            this.decompressorOutBytes = zlibXmppInputOutputFilter.decompressorOutBytes;
            this.decompressorInBytes = zlibXmppInputOutputFilter.decompressorInBytes;
            this.decompressionRatio = (double)this.decompressorInBytes / (double)this.decompressorOutBytes;
            this.maxOutputOutput = zlibXmppInputOutputFilter.maxOutputOutput;
            this.maxInputOutput = zlibXmppInputOutputFilter.maxInputOutput;
            this.maxBytesWrittenAfterFullFlush = zlibXmppInputOutputFilter.maxBytesWrittenAfterFullFlush;
        }

        public final String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "compressor-in-bytes: " + this.compressorInBytes + '\n' + "compressor-out-bytes: " + this.compressorOutBytes + '\n' + "compression-ratio: " + this.compressionRatio + '\n' + "decompressor-in-bytes: " + this.decompressorInBytes + '\n' + "decompressor-out-bytes: " + this.decompressorOutBytes + '\n' + "decompression-ratio: " + this.decompressionRatio + '\n' + "max-output-output: " + this.maxOutputOutput + '\n' + "max-input-output: " + this.maxInputOutput + '\n' + "max-bytes-written-after-full-flush: " + this.maxBytesWrittenAfterFullFlush + '\n';
            return this.toStringCache;
        }
    }

    private static final class ZlibXmppInputOutputFilter
    implements XmppInputOutputFilter {
        private static final int MINIMUM_OUTPUT_BUFFER_INITIAL_SIZE = 4;
        private static final int MINIMUM_OUTPUT_BUFFER_INCREASE = 480;
        private final Deflater compressor;
        private final Inflater decompressor = new Inflater();
        private long compressorInBytes;
        private long compressorOutBytes;
        private long decompressorInBytes;
        private long decompressorOutBytes;
        private int maxOutputOutput = -1;
        private int maxInputOutput = -1;
        private int maxBytesWrittenAfterFullFlush = -1;
        private ByteBuffer outputBuffer;

        private ZlibXmppInputOutputFilter() {
            this(-1);
        }

        private ZlibXmppInputOutputFilter(int n) {
            this.compressor = new Deflater(n);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final XmppInputOutputFilter.OutputResult output(ByteBuffer byteBuffer, boolean n, boolean bl, boolean bl2) {
            void var4_10;
            void var3_9;
            int n2;
            byte[] byArray;
            if (bl && XMPPInputOutputStream.getFlushMethod() == XMPPInputOutputStream.FlushMethod.FULL_FLUSH) {
                this.outputBuffer = ByteBuffer.allocate(256);
                n = this.deflate(3);
                this.maxBytesWrittenAfterFullFlush = Math.max(n, this.maxBytesWrittenAfterFullFlush);
                this.compressorOutBytes += (long)n;
            }
            if (byteBuffer == null && this.outputBuffer == null) {
                return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
            }
            n = byteBuffer.remaining();
            if (this.outputBuffer == null) {
                n = n < 4 ? 4 : n;
                this.outputBuffer = ByteBuffer.allocate(n);
            }
            assert (this.compressor.needsInput());
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                int n3 = byteBuffer.arrayOffset();
                n2 = byteBuffer.remaining();
            } else {
                byArray = new byte[byteBuffer.remaining()];
                boolean bl3 = false;
                n2 = byArray.length;
                byteBuffer.get(byArray);
            }
            this.compressorInBytes += (long)n2;
            this.compressor.setInput(byArray, (int)var3_9, n2);
            int n3 = var4_10 != false ? 0 : 2;
            n3 = this.deflate(n3);
            this.maxOutputOutput = Math.max(this.outputBuffer.position(), this.maxOutputOutput);
            this.compressorOutBytes += (long)n3;
            XmppInputOutputFilter.OutputResult outputResult = new XmppInputOutputFilter.OutputResult(this.outputBuffer);
            this.outputBuffer = null;
            return outputResult;
        }

        private int deflate(int n) {
            int n2 = 0;
            while (true) {
                int n3 = this.outputBuffer.position();
                byte[] byArray = this.outputBuffer.array();
                int n4 = this.outputBuffer.limit() - n3;
                int n5 = this.compressor.deflate(byArray, n3, n4, n);
                this.outputBuffer.position(n3 += n5);
                n2 += n5;
                if (this.compressor.needsInput() && this.outputBuffer.hasRemaining()) break;
                n3 = this.outputBuffer.capacity() << 1;
                if (n3 < 480) {
                    n3 = 480;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
                this.outputBuffer.flip();
                byteBuffer.put(this.outputBuffer);
                this.outputBuffer = byteBuffer;
            }
            return n2;
        }

        @Override
        public final ByteBuffer input(ByteBuffer byteBuffer) {
            int n;
            int n2;
            int n3;
            Object object;
            int n4 = byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                object = byteBuffer.array();
                n3 = byteBuffer.arrayOffset();
                n2 = byteBuffer.remaining();
            } else {
                object = new byte[n4];
                byteBuffer.get((byte[])object);
                n3 = 0;
                n2 = ((byte[])object).length;
            }
            this.decompressorInBytes += (long)n2;
            this.decompressor.setInput((byte[])object, n3, n2);
            object = ByteBuffer.allocate(2 * n2);
            while (true) {
                byte[] byArray = ((ByteBuffer)object).array();
                n3 = ((Buffer)object).position();
                int n5 = ((Buffer)object).limit() - n3;
                try {
                    n = this.decompressor.inflate(byArray, n3, n5);
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException(dataFormatException);
                }
                ((ByteBuffer)object).position(n3 + n);
                this.decompressorOutBytes += (long)n;
                if (this.decompressor.needsInput()) break;
                n = ((Buffer)object).capacity() << 1;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
                ((ByteBuffer)object).flip();
                byteBuffer2.put((ByteBuffer)object);
                object = byteBuffer2;
            }
            if (n == 0) {
                return null;
            }
            this.maxInputOutput = Math.max(((Buffer)object).position(), this.maxInputOutput);
            return object;
        }

        @Override
        public final Stats getStats() {
            return new Stats(this);
        }

        @Override
        public final String getFilterName() {
            return "Compression (zlib)";
        }
    }
}

