/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class StreamOpen
implements Nonza {
    public static final String ELEMENT = "stream:stream";
    public static final String CLIENT_NAMESPACE = "jabber:client";
    public static final String SERVER_NAMESPACE = "jabber:server";
    public static final String VERSION = "1.0";
    private final String from;
    private final String to;
    private final String id;
    private final String lang;
    private final String contentNamespace;

    public StreamOpen(CharSequence charSequence) {
        this(charSequence, null, null, null, StreamContentNamespace.client);
    }

    public StreamOpen(CharSequence charSequence, CharSequence charSequence2, String string) {
        this(charSequence, charSequence2, string, "en", StreamContentNamespace.client);
    }

    public StreamOpen(CharSequence charSequence, CharSequence charSequence2, String string, String string2, StreamContentNamespace streamContentNamespace) {
        this.to = StringUtils.maybeToString(charSequence);
        this.from = StringUtils.maybeToString(charSequence2);
        this.id = string;
        this.lang = string2;
        switch (streamContentNamespace) {
            case client: {
                this.contentNamespace = CLIENT_NAMESPACE;
                return;
            }
            case server: {
                this.contentNamespace = SERVER_NAMESPACE;
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getNamespace() {
        return this.contentNamespace;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement(this.getElementName());
        String string = CLIENT_NAMESPACE;
        if (xmlEnvironment != null) {
            string = xmlEnvironment.getEffectiveNamespaceOrUse(CLIENT_NAMESPACE);
        }
        xmlStringBuilder.attribute("xmlns", string);
        xmlStringBuilder.attribute("to", this.to);
        xmlStringBuilder.attribute("xmlns:stream", "http://etherx.jabber.org/streams");
        xmlStringBuilder.attribute("version", VERSION);
        xmlStringBuilder.optAttribute("from", this.from);
        xmlStringBuilder.optAttribute("id", this.id);
        xmlStringBuilder.xmllangAttribute(this.lang);
        xmlStringBuilder.rightAngleBracket();
        return xmlStringBuilder;
    }

    public static enum StreamContentNamespace {
        client,
        server;

    }
}

