/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorMutableIterator;", "T", "", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "index", "", "<init>", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;I)V", "expectedModCount", "trieIterator", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "lastIteratedIndex", "previous", "()Ljava/lang/Object;", "next", "reset", "", "setupTrieIterator", "add", "element", "(Ljava/lang/Object;)V", "remove", "set", "checkForComodification", "checkHasIterated", "runtime"})
public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    private final PersistentVectorBuilder<T> builder;
    private int expectedModCount;
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;
    public static final int $stable = 8;

    public PersistentVectorMutableIterator(PersistentVectorBuilder<T> persistentVectorBuilder, int n2) {
        super(n2, persistentVectorBuilder.size());
        this.builder = persistentVectorBuilder;
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    @Override
    public final T previous() {
        this.checkForComodification();
        this.checkHasPrevious$runtime();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[this.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$runtime();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[this.getIndex() - trieIterator2.getSize()];
        }
        int n2 = this.getIndex();
        this.setIndex(n2 + -1);
        return trieIterator2.previous();
    }

    @Override
    public final T next() {
        this.checkForComodification();
        this.checkHasNext$runtime();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            int n2 = this.getIndex();
            this.setIndex(n2 + 1);
            return (T)objectArray[n2];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator.hasNext()) {
            int n3 = this.getIndex();
            this.setIndex(n3 + 1);
            return (T)((AbstractListIterator)trieIterator2).next();
        }
        Object[] objectArray = this.builder.getTail$runtime();
        int n4 = this.getIndex();
        this.setIndex(n4 + 1);
        return (T)objectArray[n4 - trieIterator2.getSize()];
    }

    private final void reset() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.setSize(persistentVectorMutableIterator.builder.size());
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] objectArray = this.builder.getRoot$runtime();
        if (objectArray == null) {
            this.trieIterator = null;
            return;
        }
        int n2 = UtilsKt.rootSize(this.builder.size());
        int n3 = RangesKt.coerceAtMost((int)this.getIndex(), (int)n2);
        int n4 = this.builder.getRootShift$runtime() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(objectArray, n3, n2, n4);
            return;
        }
        TrieIterator<T> trieIterator = this.trieIterator;
        Intrinsics.checkNotNull(trieIterator);
        trieIterator.reset$runtime(objectArray, n3, n2, n4);
    }

    @Override
    public final void add(T t) {
        this.checkForComodification();
        this.builder.add(this.getIndex(), t);
        int n2 = this.getIndex();
        this.setIndex(n2 + 1);
        this.reset();
    }

    @Override
    public final void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public final void set(T t) {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, t);
        this.expectedModCount = this.builder.getModCount$runtime();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$runtime()) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw new IllegalStateException();
        }
    }
}

