/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class ElementBuffer
extends AbstractBuffer<ElementBuffer> {
    ElementBuffer(int n, ByteBuffer byteBuffer) {
        super(byteBuffer, n, byteBuffer.capacity() / n);
    }

    public static ElementBuffer allocate(int n, int n2) {
        return new ElementBuffer(n, ByteBuffer.allocate(n2 * n));
    }

    public static ElementBuffer allocateDirect(int n, int n2) {
        return new ElementBuffer(n, Buffers.newDirectByteBuffer(n2 * n));
    }

    public static ElementBuffer wrap(int n, ByteBuffer byteBuffer) {
        return new ElementBuffer(n, byteBuffer);
    }

    public static ElementBuffer wrap(int n, ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n2);
        byteBuffer.limit(n2 + n * n3);
        ElementBuffer elementBuffer = new ElementBuffer(n, byteBuffer.slice().order(byteBuffer.order()));
        byteBuffer.position(n4);
        byteBuffer.limit(n5);
        return elementBuffer;
    }

    public static ElementBuffer derefPointer(int n, long l, int n2) {
        if (0L == l) {
            throw new NullPointerException("aptr is null");
        }
        ByteBuffer byteBuffer = Buffers.getDirectByteBuffer(l, n2 * n);
        if (byteBuffer == null) {
            throw new InternalError("Couldn't dereference aptr 0x" + Long.toHexString(l) + ", size " + n2 + " * " + n);
        }
        return new ElementBuffer(n, byteBuffer);
    }

    public static ElementBuffer derefPointer(int n, ByteBuffer byteBuffer, int n2, int n3) {
        return ElementBuffer.derefPointer(n, PointerBuffer.wrap(byteBuffer, n2, 1).get(0), n3);
    }

    @Override
    public final ElementBuffer put(ElementBuffer elementBuffer) {
        int n = elementBuffer.remaining();
        if (this.remaining() < n) {
            throw new IndexOutOfBoundsException("remaining[this " + this.remaining() + " < src " + n + "], this " + this + ", src " + elementBuffer);
        }
        if (this.elementSize() != elementBuffer.elementSize()) {
            throw new IllegalArgumentException("Element-Size mismatch source " + elementBuffer + ", dest " + this);
        }
        int n2 = elementBuffer.position();
        this.put(elementBuffer.getByteBuffer(), n2, this.position, n);
        elementBuffer.position(n2 + n);
        this.position += n;
        return this;
    }

    public final ByteBuffer getByteBuffer() {
        return (ByteBuffer)this.buffer;
    }

    public final ByteBuffer slice(int n, int n2) {
        if (n < 0 || n + n2 > this.limit()) {
            throw new IndexOutOfBoundsException("idx " + n + " + elemCount " + n2 + " not within [0.." + this.limit() + "), " + this);
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        byteBuffer.position(this.elementSize * n).limit(this.elementSize * (n + n2));
        ByteBuffer byteBuffer2 = byteBuffer.slice().order(byteBuffer.order());
        byteBuffer.position(n3).limit(n4);
        return byteBuffer2;
    }

    public final ByteBuffer get(int n, ByteBuffer byteBuffer, int n2, int n3) {
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || this.elementSize * (n2 + n3) > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + byteBuffer.limit() / this.elementSize + ", " + this);
        }
        ByteBuffer byteBuffer2 = this.getByteBuffer();
        int n4 = byteBuffer2.limit();
        byteBuffer2.position(n * this.elementSize).limit((n + n3) * this.elementSize);
        n = byteBuffer.position();
        byteBuffer.position(n2 * this.elementSize);
        byteBuffer.put(byteBuffer2).position(n);
        byteBuffer2.limit(n4).rewind();
        return byteBuffer;
    }

    public final ByteBuffer get(int n, ByteBuffer byteBuffer) {
        return this.get(n, byteBuffer, 0, 1);
    }

    public final ByteBuffer get(ByteBuffer byteBuffer) {
        ElementBuffer elementBuffer = this;
        byteBuffer = elementBuffer.get(elementBuffer.position, byteBuffer, 0, 1);
        ++this.position;
        return byteBuffer;
    }

    public final ElementBuffer get(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (byteBufferArray.length < n + n2) {
            throw new IndexOutOfBoundsException("dest.length " + byteBufferArray.length + " < (offset " + n + " + length " + n2 + ")");
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException("remaining " + this.remaining() + " < length " + n2 + ", this " + this);
        }
        while (n2 > 0) {
            ElementBuffer elementBuffer = this;
            elementBuffer.get(elementBuffer.position++, byteBufferArray[n++]);
            --n2;
        }
        return this;
    }

    public final ElementBuffer get(int n, byte[] byArray, int n2, int n3) {
        if (1 != this.elementSize) {
            throw new UnsupportedOperationException("'byte' type byte-size 1 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + byArray.length + ", " + this);
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n).limit(n + n3);
        byteBuffer.get(byArray, n2, n3);
        byteBuffer.position(n4).limit(n5);
        return this;
    }

    public final ElementBuffer get(int n, short[] sArray, int n2, int n3) {
        if (2 != this.elementSize) {
            throw new UnsupportedOperationException("'short' type byte-size 2 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > sArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + sArray.length + ", " + this);
        }
        ShortBuffer shortBuffer = this.getByteBuffer().asShortBuffer();
        shortBuffer.position(n).limit(n + n3);
        shortBuffer.get(sArray, n2, n3);
        return this;
    }

    public final ElementBuffer get(int n, char[] cArray, int n2, int n3) {
        if (2 != this.elementSize) {
            throw new UnsupportedOperationException("'char' type byte-size 2 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + cArray.length + ", " + this);
        }
        CharBuffer charBuffer = this.getByteBuffer().asCharBuffer();
        charBuffer.position(n).limit(n + n3);
        charBuffer.get(cArray, n2, n3);
        return this;
    }

    public final ElementBuffer get(int n, int[] nArray, int n2, int n3) {
        if (4 != this.elementSize) {
            throw new UnsupportedOperationException("'int' type byte-size 4 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + nArray.length + ", " + this);
        }
        IntBuffer intBuffer = this.getByteBuffer().asIntBuffer();
        intBuffer.position(n).limit(n + n3);
        intBuffer.get(nArray, n2, n3);
        return this;
    }

    public final ElementBuffer get(int n, float[] fArray, int n2, int n3) {
        if (4 != this.elementSize) {
            throw new UnsupportedOperationException("'float' type byte-size 4 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > fArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + fArray.length + ", " + this);
        }
        FloatBuffer floatBuffer = this.getByteBuffer().asFloatBuffer();
        floatBuffer.position(n).limit(n + n3);
        floatBuffer.get(fArray, n2, n3);
        return this;
    }

    public final ElementBuffer get(int n, long[] lArray, int n2, int n3) {
        if (8 != this.elementSize) {
            throw new UnsupportedOperationException("'long' type byte-size 8 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + lArray.length + ", " + this);
        }
        LongBuffer longBuffer = this.getByteBuffer().asLongBuffer();
        longBuffer.position(n).limit(n + n3);
        longBuffer.get(lArray, n2, n3);
        return this;
    }

    public final ElementBuffer get(int n, double[] dArray, int n2, int n3) {
        if (8 != this.elementSize) {
            throw new UnsupportedOperationException("'double' type byte-size 8 != elementSize " + this.elementSize + ", " + this);
        }
        if (n < 0 || n + n3 > this.limit() || n3 < 0 || n2 < 0 || n2 + n3 > dArray.length) {
            throw new IndexOutOfBoundsException("destElemPos " + n2 + ", srcElemPos " + n + ", elemCount " + n3 + ", srcLimit " + this.limit() + ", destLimit " + dArray.length + ", " + this);
        }
        DoubleBuffer doubleBuffer = this.getByteBuffer().asDoubleBuffer();
        doubleBuffer.position(n).limit(n + n3);
        doubleBuffer.get(dArray, n2, n3);
        return this;
    }

    public final ElementBuffer put(ByteBuffer byteBuffer, int n, int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || this.elementSize * (n + n3) > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + byteBuffer.limit() / this.elementSize + ", " + this);
        }
        ByteBuffer byteBuffer2 = this.getByteBuffer();
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n * this.elementSize).limit((n + n3) * this.elementSize);
        byteBuffer2.position(this.elementSize * n2);
        byteBuffer2.put(byteBuffer).rewind();
        byteBuffer.limit(n5).position(n4);
        return this;
    }

    public final ElementBuffer put(int n, ByteBuffer byteBuffer) {
        return this.put(byteBuffer, 0, n, 1);
    }

    @Override
    public final ElementBuffer put(ByteBuffer byteBuffer) {
        ElementBuffer elementBuffer = this;
        elementBuffer.put(elementBuffer.position, byteBuffer);
        ++this.position;
        return this;
    }

    public final ElementBuffer put(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (byteBufferArray.length < n + n2) {
            throw new IndexOutOfBoundsException("src.length " + byteBufferArray.length + " < (offset " + n + " + length " + n2 + ")");
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException("remaining " + this.remaining() + " < length " + n2 + ", this " + this);
        }
        while (n2 > 0) {
            ElementBuffer elementBuffer = this;
            elementBuffer.put(elementBuffer.position++, byteBufferArray[n++]);
            --n2;
        }
        return this;
    }

    public final ElementBuffer put(byte[] byArray, int n, int n2, int n3) {
        if (1 != this.elementSize) {
            throw new UnsupportedOperationException("'byte' type byte-size 1 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + byArray.length + ", " + this);
        }
        ByteBuffer byteBuffer = this.getByteBuffer();
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        byteBuffer.position(n2).limit(n2 + n3);
        byteBuffer.put(byArray, n, n3);
        byteBuffer.position(n4).limit(n5);
        return this;
    }

    public final ElementBuffer put(short[] sArray, int n, int n2, int n3) {
        if (2 != this.elementSize) {
            throw new UnsupportedOperationException("'short' type byte-size 2 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > sArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + sArray.length + ", " + this);
        }
        ShortBuffer shortBuffer = this.getByteBuffer().asShortBuffer();
        shortBuffer.position(n2).limit(n2 + n3);
        shortBuffer.put(sArray, n, n3);
        return this;
    }

    public final ElementBuffer put(char[] cArray, int n, int n2, int n3) {
        if (2 != this.elementSize) {
            throw new UnsupportedOperationException("'char' type byte-size 2 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + cArray.length + ", " + this);
        }
        CharBuffer charBuffer = this.getByteBuffer().asCharBuffer();
        charBuffer.position(n2).limit(n2 + n3);
        charBuffer.put(cArray, n, n3);
        return this;
    }

    public final ElementBuffer put(int[] nArray, int n, int n2, int n3) {
        if (4 != this.elementSize) {
            throw new UnsupportedOperationException("'int' type byte-size 4 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > nArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + nArray.length + ", " + this);
        }
        IntBuffer intBuffer = this.getByteBuffer().asIntBuffer();
        intBuffer.position(n2).limit(n2 + n3);
        intBuffer.put(nArray, n, n3);
        return this;
    }

    public final ElementBuffer put(float[] fArray, int n, int n2, int n3) {
        if (4 != this.elementSize) {
            throw new UnsupportedOperationException("'float' type byte-size 4 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > fArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + fArray.length + ", " + this);
        }
        FloatBuffer floatBuffer = this.getByteBuffer().asFloatBuffer();
        floatBuffer.position(n2).limit(n2 + n3);
        floatBuffer.put(fArray, n, n3);
        return this;
    }

    public final ElementBuffer put(long[] lArray, int n, int n2, int n3) {
        if (8 != this.elementSize) {
            throw new UnsupportedOperationException("'long' type byte-size 8 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > lArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + lArray.length + ", " + this);
        }
        LongBuffer longBuffer = this.getByteBuffer().asLongBuffer();
        longBuffer.position(n2).limit(n2 + n3);
        longBuffer.put(lArray, n, n3);
        return this;
    }

    public final ElementBuffer put(double[] dArray, int n, int n2, int n3) {
        if (8 != this.elementSize) {
            throw new UnsupportedOperationException("'double' type byte-size 8 != elementSize " + this.elementSize + ", " + this);
        }
        if (n2 < 0 || n2 + n3 > this.limit() || n3 < 0 || n < 0 || n + n3 > dArray.length) {
            throw new IndexOutOfBoundsException("srcElemPos " + n + ", destElemPos " + n2 + ", elemCount " + n3 + ", destLimit " + this.limit() + ", srcLimit " + dArray.length + ", " + this);
        }
        DoubleBuffer doubleBuffer = this.getByteBuffer().asDoubleBuffer();
        doubleBuffer.position(n2).limit(n2 + n3);
        doubleBuffer.put(dArray, n, n3);
        return this;
    }

    @Override
    public String toString() {
        return "ElementBuffer" + this.toSubString();
    }
}

