/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util;

import com.jogamp.common.util.Bitfield;

public class Int32ArrayBitfield
implements Bitfield {
    private static final int UNIT_SHIFT = 5;
    private final int[] storage;
    private final int bitSize;

    public Int32ArrayBitfield(int n) {
        n = Math.max(1, n + 31 >>> 5);
        this.storage = new int[n];
        this.bitSize = n << 5;
    }

    @Override
    public int size() {
        return this.bitSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clearField(boolean bl) {
        if (bl) {
            int n = -1;
        } else {
            boolean bl2 = false;
        }
        for (int i = this.storage.length - 1; i >= 0; --i) {
            void var1_4;
            this.storage[i] = var1_4;
        }
    }

    private static final void check(int n, int n2) {
        if (n2 < 0 || n2 >= n) {
            throw new IndexOutOfBoundsException("Bitnum should be within [0.." + (n - 1) + "], but is " + n2);
        }
    }

    @Override
    public final int get32(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32ArrayBitfield.check(this.bitSize - n2 + 1, n);
        int n3 = n >>> 5;
        int n4 = 32 - (n - (n3 << 5));
        if (32 == n4) {
            n4 = Bitfield.Util.getBitMask(n2);
            return n4 & this.storage[n3];
        }
        n4 = Math.min(n2, n4);
        int n5 = (1 << n4) - 1;
        n = n5 & this.storage[n3] >>> n;
        if ((n2 -= n4) > 0) {
            n2 = (1 << n2) - 1;
            return n | (n2 & this.storage[n3 + 1]) << n4;
        }
        return n;
    }

    @Override
    public final void put32(int n, int n2, int n3) {
        if (n2 < 0 || n2 > 32) {
            throw new IndexOutOfBoundsException("length should be within [0..32], but is " + n2);
        }
        Int32ArrayBitfield.check(this.bitSize - n2 + 1, n);
        int n4 = n >>> 5;
        int n5 = 32 - (n - (n4 << 5));
        if (32 == n5) {
            n5 = Bitfield.Util.getBitMask(n2);
            this.storage[n4] = ~n5 & this.storage[n4] | n5 & n3;
            return;
        }
        n5 = Math.min(n2, n5);
        int n6 = (1 << n5) - 1;
        this.storage[n4] = ~(n6 << n) & this.storage[n4] | (n6 & n3) << n;
        n = n2 - n5;
        if (n > 0) {
            n = (1 << n) - 1;
            this.storage[n4 + 1] = ~n & this.storage[n4 + 1] | n & n3 >>> n5;
        }
    }

    @Override
    public final int copy32(int n, int n2, int n3) {
        n = this.get32(n, n3);
        this.put32(n2, n3, n);
        return n;
    }

    @Override
    public final boolean get(int n) {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        return 0 != (this.storage[n2] & 1 << (n -= n2 << 5));
    }

    @Override
    public final boolean put(int n, boolean bl) {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        n -= n2 << 5;
        n = 1 << n;
        boolean bl2 = 0 != (this.storage[n2] & n);
        if (bl2 != bl) {
            if (bl) {
                int n3 = n2;
                this.storage[n3] = this.storage[n3] | n;
            } else {
                int n4 = n2;
                this.storage[n4] = this.storage[n4] & ~n;
            }
        }
        return bl2;
    }

    @Override
    public final void set(int n) {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        n -= n2 << 5;
        n = 1 << n;
        int n3 = n2;
        this.storage[n3] = this.storage[n3] | n;
    }

    @Override
    public final void clear(int n) {
        Int32ArrayBitfield.check(this.bitSize, n);
        int n2 = n >>> 5;
        n -= n2 << 5;
        n = 1 << n;
        int n3 = n2;
        this.storage[n3] = this.storage[n3] & ~n;
    }

    @Override
    public final boolean copy(int n, int n2) {
        Int32ArrayBitfield.check(this.bitSize, n);
        Int32ArrayBitfield.check(this.bitSize, n2);
        int n3 = n >>> 5;
        int n4 = n - (n3 << 5);
        n = 0 != (this.storage[n3] & 1 << n4) ? 1 : 0;
        n3 = n2 >>> 5;
        n4 = n2 - (n3 << 5);
        n2 = 1 << n4;
        if (n != 0) {
            int n5 = n3;
            this.storage[n5] = this.storage[n5] | n2;
        } else {
            int n6 = n3;
            this.storage[n6] = this.storage[n6] & ~n2;
        }
        return n != 0;
    }

    @Override
    public int bitCount() {
        int n = 0;
        for (int i = this.storage.length - 1; i >= 0; --i) {
            n += Bitfield.Util.bitCount(this.storage[i]);
        }
        return n;
    }
}

