/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2DataFrame
extends AbstractHttp2StreamFrame
implements Http2DataFrame {
    private final ByteBuf content;
    private final boolean endStream;
    private final int padding;
    private final int initialFlowControlledBytes;

    public DefaultHttp2DataFrame(ByteBuf byteBuf) {
        this(byteBuf, false);
    }

    public DefaultHttp2DataFrame(boolean bl) {
        this(Unpooled.EMPTY_BUFFER, bl);
    }

    public DefaultHttp2DataFrame(ByteBuf byteBuf, boolean bl) {
        this(byteBuf, bl, 0);
    }

    public DefaultHttp2DataFrame(ByteBuf byteBuf, boolean bl, int n) {
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"content");
        this.endStream = bl;
        Http2CodecUtil.verifyPadding(n);
        this.padding = n;
        if ((long)this.content().readableBytes() + (long)n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("content + padding must be <= Integer.MAX_VALUE");
        }
        this.initialFlowControlledBytes = this.content().readableBytes() + n;
    }

    @Override
    public final DefaultHttp2DataFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public final String name() {
        return "DATA";
    }

    @Override
    public final boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public final int padding() {
        return this.padding;
    }

    @Override
    public final ByteBuf content() {
        return ByteBufUtil.ensureAccessible((ByteBuf)this.content);
    }

    @Override
    public final int initialFlowControlledBytes() {
        return this.initialFlowControlledBytes;
    }

    @Override
    public final DefaultHttp2DataFrame copy() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().copy());
    }

    @Override
    public final DefaultHttp2DataFrame duplicate() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().duplicate());
    }

    @Override
    public final DefaultHttp2DataFrame retainedDuplicate() {
        DefaultHttp2DataFrame defaultHttp2DataFrame = this;
        return defaultHttp2DataFrame.replace(defaultHttp2DataFrame.content().retainedDuplicate());
    }

    @Override
    public final DefaultHttp2DataFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2DataFrame(byteBuf, this.endStream, this.padding);
    }

    public final int refCnt() {
        return this.content.refCnt();
    }

    public final boolean release() {
        return this.content.release();
    }

    public final boolean release(int n) {
        return this.content.release(n);
    }

    @Override
    public final DefaultHttp2DataFrame retain() {
        this.content.retain();
        return this;
    }

    @Override
    public final DefaultHttp2DataFrame retain(int n) {
        this.content.retain(n);
        return this;
    }

    public final String toString() {
        return StringUtil.simpleClassName((Object)this) + "(stream=" + this.stream() + ", content=" + this.content + ", endStream=" + this.endStream + ", padding=" + this.padding + ')';
    }

    @Override
    public final DefaultHttp2DataFrame touch() {
        this.content.touch();
        return this;
    }

    @Override
    public final DefaultHttp2DataFrame touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2DataFrame)) {
            return false;
        }
        return super.equals(object = (DefaultHttp2DataFrame)object) && this.content.equals((Object)((DefaultHttp2DataFrame)object).content()) && this.endStream == ((DefaultHttp2DataFrame)object).endStream && this.padding == ((DefaultHttp2DataFrame)object).padding;
    }

    @Override
    public final int hashCode() {
        int n = super.hashCode();
        n = n * 31 + this.content.hashCode();
        n = n * 31 + (this.endStream ? 0 : 1);
        n = n * 31 + this.padding;
        return n;
    }
}

