/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http2.HpackDynamicTable;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanDecoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;

final class HpackDecoder {
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - long overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - int overflow", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decodeULE128ToInt(..)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decode(..)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "indexHeader(..)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "readName(..)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "setDynamicTableSize(..)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = Http2Exception.newStatic(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", Http2Exception.ShutdownHint.HARD_SHUTDOWN, HpackDecoder.class, "decode(..)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_INDEXED_HEADER = 1;
    private static final byte READ_INDEXED_HEADER_NAME = 2;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 4;
    private static final byte READ_LITERAL_HEADER_NAME = 5;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 7;
    private static final byte READ_LITERAL_HEADER_VALUE = 8;
    private final HpackHuffmanDecoder huffmanDecoder = new HpackHuffmanDecoder();
    private final HpackDynamicTable hpackDynamicTable;
    private long maxHeaderListSize;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    HpackDecoder(long l) {
        this(l, 4096);
    }

    HpackDecoder(long l, int n) {
        this.maxHeaderListSize = ObjectUtil.checkPositive((long)l, (String)"maxHeaderListSize");
        HpackDecoder hpackDecoder = this;
        hpackDecoder.maxDynamicTableSize = hpackDecoder.encoderMaxDynamicTableSize = (long)n;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable = new HpackDynamicTable(n);
    }

    final void decode(int n, ByteBuf byteBuf, Http2Headers http2Headers, boolean bl) {
        Http2HeadersSink http2HeadersSink = new Http2HeadersSink(n, http2Headers, this.maxHeaderListSize, bl);
        this.decodeDynamicTableSizeUpdates(byteBuf);
        this.decode(byteBuf, http2HeadersSink);
        http2HeadersSink.finish();
    }

    private void decodeDynamicTableSizeUpdates(ByteBuf byteBuf) {
        while (byteBuf.isReadable()) {
            ByteBuf byteBuf2 = byteBuf;
            int n = byteBuf2.getByte(byteBuf2.readerIndex());
            if ((n & 0x20) != 32 || (n & 0xC0) != 0) break;
            byteBuf.readByte();
            if ((n &= 0x1F) == 31) {
                this.setDynamicTableSize(HpackDecoder.decodeULE128(byteBuf, (long)n));
                continue;
            }
            this.setDynamicTableSize(n);
        }
    }

    private void decode(ByteBuf byteBuf, Http2HeadersSink http2HeadersSink) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        AsciiString asciiString = null;
        HpackUtil.IndexType indexType = HpackUtil.IndexType.NONE;
        block27: while (byteBuf.isReadable()) {
            switch (n4) {
                case 0: {
                    HpackHeaderField hpackHeaderField;
                    n = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (n & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (n < 0) {
                        switch (n &= 0x7F) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                n4 = 1;
                                continue block27;
                            }
                        }
                        hpackHeaderField = this.getIndexedHeader(n);
                        http2HeadersSink.appendToHeaderList((AsciiString)hpackHeaderField.name, (AsciiString)hpackHeaderField.value);
                        continue block27;
                    }
                    if ((n & 0x40) == 64) {
                        indexType = HpackUtil.IndexType.INCREMENTAL;
                        switch (n &= 0x3F) {
                            case 0: {
                                n4 = 3;
                                continue block27;
                            }
                            case 63: {
                                n4 = 2;
                                continue block27;
                            }
                        }
                        asciiString = this.readName(n);
                        n2 = asciiString.length();
                        n4 = 6;
                        continue block27;
                    }
                    if ((n & 0x20) == 32) {
                        throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Dynamic table size update must happen at the beginning of the header block", new Object[0]);
                    }
                    indexType = (n & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    switch (n &= 0xF) {
                        case 0: {
                            n4 = 3;
                            continue block27;
                        }
                        case 15: {
                            n4 = 2;
                            continue block27;
                        }
                    }
                    asciiString = this.readName(n);
                    n2 = asciiString.length();
                    n4 = 6;
                    continue block27;
                }
                case 1: {
                    HpackHeaderField hpackHeaderField = this.getIndexedHeader(HpackDecoder.decodeULE128(byteBuf, n));
                    http2HeadersSink.appendToHeaderList((AsciiString)hpackHeaderField.name, (AsciiString)hpackHeaderField.value);
                    n4 = 0;
                    continue block27;
                }
                case 2: {
                    asciiString = this.readName(HpackDecoder.decodeULE128(byteBuf, n));
                    n2 = asciiString.length();
                    n4 = 6;
                    continue block27;
                }
                case 3: {
                    n = byteBuf.readByte();
                    boolean bl2 = bl = (n & 0x80) == 128;
                    if ((n &= 0x7F) == 127) {
                        n4 = 4;
                        continue block27;
                    }
                    n2 = n;
                    n4 = 5;
                    continue block27;
                }
                case 4: {
                    n2 = HpackDecoder.decodeULE128(byteBuf, n);
                    n4 = 5;
                    continue block27;
                }
                case 5: {
                    if (byteBuf.readableBytes() < n2) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    asciiString = this.readStringLiteral(byteBuf, n2, bl);
                    n4 = 6;
                    continue block27;
                }
                case 6: {
                    n = byteBuf.readByte();
                    bl = (n & 0x80) == 128;
                    switch (n &= 0x7F) {
                        case 127: {
                            n4 = 7;
                            continue block27;
                        }
                        case 0: {
                            this.insertHeader(http2HeadersSink, asciiString, AsciiString.EMPTY_STRING, indexType);
                            n4 = 0;
                            continue block27;
                        }
                    }
                    n3 = n;
                    n4 = 8;
                    continue block27;
                }
                case 7: {
                    n3 = HpackDecoder.decodeULE128(byteBuf, n);
                    n4 = 8;
                    continue block27;
                }
                case 8: {
                    if (byteBuf.readableBytes() < n3) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    AsciiString asciiString2 = this.readStringLiteral(byteBuf, n3, bl);
                    this.insertHeader(http2HeadersSink, asciiString, asciiString2, indexType);
                    n4 = 0;
                    continue block27;
                }
            }
            throw new Error("should not reach here state: " + n4);
        }
        if (n4 != 0) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Incomplete header block fragment.", new Object[0]);
        }
    }

    final void setMaxHeaderTableSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxDynamicTableSize = l;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.hpackDynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    final void setMaxHeaderListSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxHeaderListSize = l;
    }

    final long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    final long getMaxHeaderTableSize() {
        return this.hpackDynamicTable.capacity();
    }

    final int length() {
        return this.hpackDynamicTable.length();
    }

    final long size() {
        return this.hpackDynamicTable.size();
    }

    final HpackHeaderField getHeaderField(int n) {
        return this.hpackDynamicTable.getEntry(n + 1);
    }

    private void setDynamicTableSize(long l) {
        if (l > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = l;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable.setCapacity(l);
    }

    private static HeaderType validateHeader(int n, AsciiString object, CharSequence charSequence, HeaderType headerType) {
        if (Http2Headers.PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)object)) {
            if (headerType == HeaderType.REGULAR_HEADER) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Pseudo-header field '%s' found after regular header.", object);
            }
            HeaderType headerType2 = object = (object = Http2Headers.PseudoHeaderName.getPseudoHeader(object)).isRequestOnly() ? HeaderType.REQUEST_PSEUDO_HEADER : HeaderType.RESPONSE_PSEUDO_HEADER;
            if (headerType != null && object != headerType) {
                throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Mix of request and response pseudo-headers.", new Object[0]);
            }
            return object;
        }
        if (HttpHeaderValidationUtil.isConnectionHeader((CharSequence)object, (boolean)true)) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Illegal connection-specific header '%s' encountered.", object);
        }
        if (HttpHeaderValidationUtil.isTeNotTrailers((CharSequence)object, (CharSequence)charSequence)) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, "Illegal value specified for the 'TE' header (only 'trailers' is allowed).", new Object[0]);
        }
        return HeaderType.REGULAR_HEADER;
    }

    private AsciiString readName(int n) {
        if (n <= HpackStaticTable.length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n);
            return (AsciiString)hpackHeaderField.name;
        }
        if (n - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            HpackHeaderField hpackHeaderField = this.hpackDynamicTable.getEntry(n - HpackStaticTable.length);
            return (AsciiString)hpackHeaderField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private HpackHeaderField getIndexedHeader(int n) {
        if (n <= HpackStaticTable.length) {
            return HpackStaticTable.getEntry(n);
        }
        if (n - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            return this.hpackDynamicTable.getEntry(n - HpackStaticTable.length);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private void insertHeader(Http2HeadersSink http2HeadersSink, AsciiString asciiString, AsciiString asciiString2, HpackUtil.IndexType indexType) {
        http2HeadersSink.appendToHeaderList(asciiString, asciiString2);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                return;
            }
            case INCREMENTAL: {
                this.hpackDynamicTable.add(new HpackHeaderField((CharSequence)asciiString, (CharSequence)asciiString2));
                return;
            }
        }
        throw new Error("should not reach here");
    }

    private AsciiString readStringLiteral(ByteBuf byteBuf, int n, boolean bl) {
        if (bl) {
            return this.huffmanDecoder.decode(byteBuf, n);
        }
        byte[] byArray = new byte[n];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf byteBuf) {
        return new IllegalArgumentException("decode only works with an entire header block! " + byteBuf);
    }

    static int decodeULE128(ByteBuf byteBuf, int n) {
        int n2 = byteBuf.readerIndex();
        long l = HpackDecoder.decodeULE128(byteBuf, (long)n);
        if (l > Integer.MAX_VALUE) {
            byteBuf.readerIndex(n2);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)l;
    }

    static long decodeULE128(ByteBuf byteBuf, long l) {
        assert (l <= 127L && l >= 0L);
        boolean bl = l == 0L;
        int n = byteBuf.writerIndex();
        int n2 = byteBuf.readerIndex();
        int n3 = 0;
        while (n2 < n) {
            byte by = byteBuf.getByte(n2);
            if (n3 == 56 && ((by & 0x80) != 0 || by == 127 && !bl)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((by & 0x80) == 0) {
                byteBuf.readerIndex(n2 + 1);
                return l + (((long)by & 0x7FL) << n3);
            }
            l += ((long)by & 0x7FL) << n3;
            ++n2;
            n3 += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    private static final class Http2HeadersSink {
        private final Http2Headers headers;
        private final long maxHeaderListSize;
        private final int streamId;
        private final boolean validateHeaders;
        private long headersLength;
        private boolean exceededMaxLength;
        private HeaderType previousType;
        private Http2Exception validationException;

        Http2HeadersSink(int n, Http2Headers http2Headers, long l, boolean bl) {
            this.headers = http2Headers;
            this.maxHeaderListSize = l;
            this.streamId = n;
            this.validateHeaders = bl;
        }

        final void finish() {
            if (this.exceededMaxLength) {
                Http2CodecUtil.headerListSizeExceeded(this.streamId, this.maxHeaderListSize, true);
                return;
            }
            if (this.validationException != null) {
                throw this.validationException;
            }
        }

        final void appendToHeaderList(AsciiString asciiString, AsciiString asciiString2) {
            this.headersLength += HpackHeaderField.sizeOf((CharSequence)asciiString, (CharSequence)asciiString2);
            this.exceededMaxLength |= this.headersLength > this.maxHeaderListSize;
            if (this.exceededMaxLength || this.validationException != null) {
                return;
            }
            try {
                this.headers.add(asciiString, asciiString2);
                if (this.validateHeaders) {
                    this.previousType = HpackDecoder.validateHeader(this.streamId, asciiString, (CharSequence)asciiString2, this.previousType);
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.validationException = Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, illegalArgumentException, "Validation failed for header '%s': %s", asciiString, illegalArgumentException.getMessage());
                return;
            }
            catch (Http2Exception http2Exception) {
                Http2Exception http2Exception2 = http2Exception;
                this.validationException = Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, http2Exception2, http2Exception2.getMessage(), new Object[0]);
                return;
            }
        }
    }

    private static enum HeaderType {
        REGULAR_HEADER,
        REQUEST_PSEUDO_HEADER,
        RESPONSE_PSEUDO_HEADER;

    }
}

