/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

public final class HttpConversionUtil {
    private static final CharSequenceMap<AsciiString> HTTP_TO_HTTP2_HEADER_BLACKLIST = new CharSequenceMap();
    public static final HttpMethod OUT_OF_MESSAGE_SEQUENCE_METHOD;
    public static final String OUT_OF_MESSAGE_SEQUENCE_PATH = "";
    public static final HttpResponseStatus OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE;
    private static final AsciiString EMPTY_REQUEST_PATH;

    private HttpConversionUtil() {
    }

    public static HttpResponseStatus parseStatus(CharSequence charSequence) {
        HttpResponseStatus httpResponseStatus;
        try {
            httpResponseStatus = HttpResponseStatus.parseLine((CharSequence)charSequence);
            if (httpResponseStatus == HttpResponseStatus.SWITCHING_PROTOCOLS) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 status code '%d'", httpResponseStatus.code());
            }
        }
        catch (Http2Exception http2Exception) {
            Http2Exception http2Exception2 = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, throwable, "Unrecognized HTTP status code '%s' encountered in translation to HTTP/1.x", charSequence);
        }
        return httpResponseStatus;
    }

    public static FullHttpResponse toFullHttpResponse(int n, Http2Headers http2Headers, ByteBufAllocator byteBufAllocator, boolean bl) {
        return HttpConversionUtil.toFullHttpResponse(n, http2Headers, byteBufAllocator.buffer(), bl);
    }

    public static FullHttpResponse toFullHttpResponse(int n, Http2Headers http2Headers, ByteBuf byteBuf, boolean bl) {
        HttpResponseStatus httpResponseStatus = HttpConversionUtil.parseStatus(http2Headers.status());
        byteBuf = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, byteBuf, bl);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, (FullHttpMessage)byteBuf, false);
        }
        catch (Http2Exception http2Exception) {
            byteBuf.release();
            throw http2Exception;
        }
        catch (Throwable throwable) {
            byteBuf.release();
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, throwable, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return byteBuf;
    }

    public static FullHttpRequest toFullHttpRequest(int n, Http2Headers http2Headers, ByteBufAllocator byteBufAllocator, boolean bl) {
        return HttpConversionUtil.toFullHttpRequest(n, http2Headers, byteBufAllocator.buffer(), bl);
    }

    private static String extractPath(CharSequence charSequence, Http2Headers http2Headers) {
        if (HttpMethod.CONNECT.asciiName().contentEqualsIgnoreCase(charSequence)) {
            return ((CharSequence)ObjectUtil.checkNotNull((Object)http2Headers.authority(), (String)"authority header cannot be null in the conversion to HTTP/1.x")).toString();
        }
        return ((CharSequence)ObjectUtil.checkNotNull((Object)http2Headers.path(), (String)"path header cannot be null in conversion to HTTP/1.x")).toString();
    }

    public static FullHttpRequest toFullHttpRequest(int n, Http2Headers http2Headers, ByteBuf byteBuf, boolean bl) {
        CharSequence charSequence = (CharSequence)ObjectUtil.checkNotNull((Object)http2Headers.method(), (String)"method header cannot be null in conversion to HTTP/1.x");
        String string = HttpConversionUtil.extractPath(charSequence, http2Headers);
        byteBuf = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)charSequence.toString()), string.toString(), byteBuf, bl);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, (FullHttpMessage)byteBuf, false);
        }
        catch (Http2Exception http2Exception) {
            byteBuf.release();
            throw http2Exception;
        }
        catch (Throwable throwable) {
            byteBuf.release();
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, throwable, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return byteBuf;
    }

    public static HttpRequest toHttpRequest(int n, Http2Headers object, boolean bl) {
        CharSequence charSequence = (CharSequence)ObjectUtil.checkNotNull((Object)object.method(), (String)"method header cannot be null in conversion to HTTP/1.x");
        String string = HttpConversionUtil.extractPath(charSequence, (Http2Headers)object);
        DefaultHttpRequest defaultHttpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)charSequence.toString()), string.toString(), bl);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(n, (Http2Headers)object, defaultHttpRequest.headers(), defaultHttpRequest.protocolVersion(), false, true);
        }
        catch (Http2Exception http2Exception) {
            object = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, throwable, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return defaultHttpRequest;
    }

    public static HttpResponse toHttpResponse(int n, Http2Headers object, boolean bl) {
        HttpResponseStatus httpResponseStatus = HttpConversionUtil.parseStatus(object.status());
        DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, bl);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(n, (Http2Headers)object, defaultHttpResponse.headers(), defaultHttpResponse.protocolVersion(), false, false);
        }
        catch (Http2Exception http2Exception) {
            object = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, throwable, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        return defaultHttpResponse;
    }

    public static void addHttp2ToHttpHeaders(int n, Http2Headers http2Headers, FullHttpMessage fullHttpMessage, boolean bl) {
        HttpConversionUtil.addHttp2ToHttpHeaders(n, http2Headers, bl ? fullHttpMessage.trailingHeaders() : fullHttpMessage.headers(), fullHttpMessage.protocolVersion(), bl, fullHttpMessage instanceof HttpRequest);
    }

    public static void addHttp2ToHttpHeaders(int n, Http2Headers object, HttpHeaders httpHeaders, HttpVersion httpVersion, boolean bl, boolean bl2) {
        Http2ToHttpHeaderTranslator http2ToHttpHeaderTranslator = new Http2ToHttpHeaderTranslator(n, httpHeaders, bl2);
        try {
            http2ToHttpHeaderTranslator.translateHeaders((Iterable<Map.Entry<CharSequence, CharSequence>>)object);
        }
        catch (Http2Exception http2Exception) {
            object = http2Exception;
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.streamError(n, Http2Error.PROTOCOL_ERROR, throwable, "HTTP/2 to HTTP/1.x headers conversion error", new Object[0]);
        }
        httpHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        httpHeaders.remove((CharSequence)HttpHeaderNames.TRAILER);
        if (!bl) {
            httpHeaders.setInt((CharSequence)ExtensionHeaderNames.STREAM_ID.text(), n);
            HttpUtil.setKeepAlive((HttpHeaders)httpHeaders, (HttpVersion)httpVersion, (boolean)true);
        }
    }

    public static Http2Headers toHttp2Headers(HttpMessage httpMessage, boolean bl) {
        HttpHeaders httpHeaders = httpMessage.headers();
        DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(bl, httpHeaders.size());
        if (httpMessage instanceof HttpRequest) {
            httpMessage = (HttpRequest)httpMessage;
            String string = httpHeaders.getAsString((CharSequence)HttpHeaderNames.HOST);
            if (HttpUtil.isOriginForm((String)httpMessage.uri()) || HttpUtil.isAsteriskForm((String)httpMessage.uri())) {
                defaultHttp2Headers.path((CharSequence)new AsciiString((CharSequence)httpMessage.uri()));
                HttpConversionUtil.setHttp2Scheme(httpHeaders, defaultHttp2Headers);
            } else {
                URI uRI = URI.create(httpMessage.uri());
                defaultHttp2Headers.path((CharSequence)HttpConversionUtil.toHttp2Path(uRI));
                string = StringUtil.isNullOrEmpty((String)string) ? uRI.getAuthority() : string;
                HttpConversionUtil.setHttp2Scheme(httpHeaders, uRI, defaultHttp2Headers);
            }
            HttpConversionUtil.setHttp2Authority(string, defaultHttp2Headers);
            defaultHttp2Headers.method((CharSequence)httpMessage.method().asciiName());
        } else if (httpMessage instanceof HttpResponse) {
            httpMessage = (HttpResponse)httpMessage;
            defaultHttp2Headers.status((CharSequence)httpMessage.status().codeAsText());
        }
        HttpConversionUtil.toHttp2Headers(httpHeaders, defaultHttp2Headers);
        return defaultHttp2Headers;
    }

    public static Http2Headers toHttp2Headers(HttpHeaders httpHeaders, boolean bl) {
        if (httpHeaders.isEmpty()) {
            return EmptyHttp2Headers.INSTANCE;
        }
        DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(bl, httpHeaders.size());
        HttpConversionUtil.toHttp2Headers(httpHeaders, defaultHttp2Headers);
        return defaultHttp2Headers;
    }

    private static CharSequenceMap<AsciiString> toLowercaseMap(Iterator<? extends CharSequence> iterator, int n) {
        UnsupportedValueConverter unsupportedValueConverter = UnsupportedValueConverter.instance();
        CharSequenceMap<AsciiString> charSequenceMap = new CharSequenceMap<AsciiString>(true, (ValueConverter<AsciiString>)unsupportedValueConverter, n);
        while (iterator.hasNext()) {
            unsupportedValueConverter = AsciiString.of((CharSequence)iterator.next()).toLowerCase();
            try {
                int n2 = unsupportedValueConverter.forEachByte(ByteProcessor.FIND_COMMA);
                if (n2 != -1) {
                    int n3 = 0;
                    do {
                        charSequenceMap.add(unsupportedValueConverter.subSequence(n3, n2, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((n3 = n2 + 1) < unsupportedValueConverter.length() && (n2 = unsupportedValueConverter.forEachByte(n3, unsupportedValueConverter.length() - n3, ByteProcessor.FIND_COMMA)) != -1);
                    charSequenceMap.add(unsupportedValueConverter.subSequence(n3, unsupportedValueConverter.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                charSequenceMap.add(unsupportedValueConverter.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return charSequenceMap;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> iterator, Http2Headers http2Headers) {
        if (AsciiString.indexOf((CharSequence)iterator.getValue(), (char)',', (int)0) == -1) {
            if (AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)iterator.getValue()), (CharSequence)HttpHeaderValues.TRAILERS)) {
                http2Headers.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        } else {
            iterator = StringUtil.unescapeCsvFields((CharSequence)iterator.getValue());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!AsciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.trim((CharSequence)charSequence), (CharSequence)HttpHeaderValues.TRAILERS)) continue;
                http2Headers.add(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS);
                return;
            }
        }
    }

    public static void toHttp2Headers(HttpHeaders object, Http2Headers http2Headers) {
        Iterator iterator = object.iteratorCharSequence();
        object = HttpConversionUtil.toLowercaseMap(object.valueCharSequenceIterator((CharSequence)HttpHeaderNames.CONNECTION), 8);
        while (iterator.hasNext()) {
            Object object2 = (Map.Entry)iterator.next();
            AsciiString asciiString = AsciiString.of((CharSequence)((CharSequence)object2.getKey())).toLowerCase();
            if (HTTP_TO_HTTP2_HEADER_BLACKLIST.contains(asciiString) || object.contains((Object)asciiString)) continue;
            if (asciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.TE)) {
                HttpConversionUtil.toHttp2HeadersFilterTE((Map.Entry<CharSequence, CharSequence>)object2, http2Headers);
                continue;
            }
            if (asciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE)) {
                object2 = (CharSequence)object2.getValue();
                boolean bl = false;
                for (int i = 0; i < object2.length(); ++i) {
                    char c = object2.charAt(i);
                    if (c == ';') {
                        if (i + 1 >= object2.length() || object2.charAt(i + 1) != ' ') {
                            bl = true;
                            break;
                        }
                        ++i;
                        continue;
                    }
                    if (c <= '\u00ff') continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    http2Headers.add(HttpHeaderNames.COOKIE, object2);
                    continue;
                }
                HttpConversionUtil.splitValidCookieHeader(http2Headers, (CharSequence)object2);
                continue;
            }
            http2Headers.add(asciiString, object2.getValue());
        }
    }

    private static void splitValidCookieHeader(Http2Headers http2Headers, CharSequence charSequence) {
        try {
            int n;
            charSequence = AsciiString.of((CharSequence)charSequence);
            int n2 = charSequence.forEachByte(ByteProcessor.FIND_SEMI_COLON);
            if (n2 != -1) {
                n = 0;
                do {
                    http2Headers.add(HttpHeaderNames.COOKIE, charSequence.subSequence(n, n2, false));
                    assert (n2 + 1 < charSequence.length());
                    assert (charSequence.charAt(n2 + 1) == ' ');
                } while ((n = n2 + 2) < charSequence.length() && (n2 = charSequence.forEachByte(n, charSequence.length() - n, ByteProcessor.FIND_SEMI_COLON)) != -1);
                assert (n < charSequence.length());
            } else {
                http2Headers.add(HttpHeaderNames.COOKIE, charSequence);
                return;
            }
            http2Headers.add(HttpHeaderNames.COOKIE, charSequence.subSequence(n, charSequence.length(), false));
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static AsciiString toHttp2Path(URI object) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.length((String)((URI)object).getRawPath()) + StringUtil.length((String)((URI)object).getRawQuery()) + StringUtil.length((String)((URI)object).getRawFragment()) + 2);
        if (!StringUtil.isNullOrEmpty((String)((URI)object).getRawPath())) {
            stringBuilder.append(((URI)object).getRawPath());
        }
        if (!StringUtil.isNullOrEmpty((String)((URI)object).getRawQuery())) {
            stringBuilder.append('?');
            stringBuilder.append(((URI)object).getRawQuery());
        }
        if (!StringUtil.isNullOrEmpty((String)((URI)object).getRawFragment())) {
            stringBuilder.append('#');
            stringBuilder.append(((URI)object).getRawFragment());
        }
        if (((String)(object = stringBuilder.toString())).isEmpty()) {
            return EMPTY_REQUEST_PATH;
        }
        return new AsciiString((CharSequence)object);
    }

    static void setHttp2Authority(String string, Http2Headers http2Headers) {
        if (string != null) {
            if (string.isEmpty()) {
                http2Headers.authority((CharSequence)AsciiString.EMPTY_STRING);
                return;
            }
            int n = string.indexOf(64) + 1;
            int n2 = string.length() - n;
            if (n2 == 0) {
                throw new IllegalArgumentException("authority: " + string);
            }
            http2Headers.authority((CharSequence)new AsciiString((CharSequence)string, n, n2));
        }
    }

    private static void setHttp2Scheme(HttpHeaders httpHeaders, Http2Headers http2Headers) {
        HttpConversionUtil.setHttp2Scheme(httpHeaders, URI.create(OUT_OF_MESSAGE_SEQUENCE_PATH), http2Headers);
    }

    private static void setHttp2Scheme(HttpHeaders object, URI uRI, Http2Headers http2Headers) {
        String string = uRI.getScheme();
        if (!StringUtil.isNullOrEmpty((String)string)) {
            http2Headers.scheme((CharSequence)new AsciiString((CharSequence)string));
            return;
        }
        if ((object = object.get((CharSequence)ExtensionHeaderNames.SCHEME.text())) != null) {
            http2Headers.scheme((CharSequence)AsciiString.of((CharSequence)object));
            return;
        }
        if (uRI.getPort() == HttpScheme.HTTPS.port()) {
            http2Headers.scheme((CharSequence)HttpScheme.HTTPS.name());
            return;
        }
        if (uRI.getPort() == HttpScheme.HTTP.port()) {
            http2Headers.scheme((CharSequence)HttpScheme.HTTP.name());
            return;
        }
        throw new IllegalArgumentException(":scheme must be specified. see https://tools.ietf.org/html/rfc7540#section-8.1.2.3");
    }

    static {
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        AsciiString asciiString = HttpHeaderNames.KEEP_ALIVE;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(asciiString, AsciiString.EMPTY_STRING);
        asciiString = HttpHeaderNames.PROXY_CONNECTION;
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(asciiString, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_BLACKLIST.add(ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        OUT_OF_MESSAGE_SEQUENCE_METHOD = HttpMethod.OPTIONS;
        OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = HttpResponseStatus.OK;
        EMPTY_REQUEST_PATH = AsciiString.cached((String)"/");
    }

    private static final class Http2ToHttpHeaderTranslator {
        private static final CharSequenceMap<AsciiString> REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
        private static final CharSequenceMap<AsciiString> RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
        private final int streamId;
        private final HttpHeaders output;
        private final CharSequenceMap<AsciiString> translations;

        Http2ToHttpHeaderTranslator(int n, HttpHeaders httpHeaders, boolean bl) {
            this.streamId = n;
            this.output = httpHeaders;
            this.translations = bl ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
        }

        final void translateHeaders(Iterable<Map.Entry<CharSequence, CharSequence>> object) {
            StringBuilder stringBuilder = null;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Map.Entry)object.next();
                CharSequence charSequence = (CharSequence)object2.getKey();
                object2 = (CharSequence)object2.getValue();
                AsciiString asciiString = (AsciiString)this.translations.get(charSequence);
                if (asciiString != null) {
                    this.output.add((CharSequence)asciiString, (Object)AsciiString.of((CharSequence)object2));
                    continue;
                }
                if (Http2Headers.PseudoHeaderName.isPseudoHeader(charSequence)) continue;
                if (charSequence.length() == 0 || charSequence.charAt(0) == ':') {
                    throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", charSequence);
                }
                if (HttpHeaderNames.COOKIE.equals((Object)charSequence)) {
                    if (stringBuilder == null) {
                        stringBuilder = InternalThreadLocalMap.get().stringBuilder();
                    } else if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append((CharSequence)object2);
                    continue;
                }
                this.output.add(charSequence, object2);
            }
            if (stringBuilder != null) {
                this.output.add((CharSequence)HttpHeaderNames.COOKIE, (Object)stringBuilder.toString());
            }
        }

        static {
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.SCHEME.value(), ExtensionHeaderNames.SCHEME.text());
            REQUEST_HEADER_TRANSLATIONS.add((Headers)RESPONSE_HEADER_TRANSLATIONS);
            RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.PATH.value(), ExtensionHeaderNames.PATH.text());
        }
    }

    public static enum ExtensionHeaderNames {
        STREAM_ID("x-http2-stream-id"),
        SCHEME("x-http2-scheme"),
        PATH("x-http2-path"),
        STREAM_PROMISE_ID("x-http2-stream-promise-id"),
        STREAM_DEPENDENCY_ID("x-http2-stream-dependency-id"),
        STREAM_WEIGHT("x-http2-stream-weight");

        private final AsciiString text;

        private ExtensionHeaderNames(String string2) {
            this.text = AsciiString.cached((String)string2);
        }

        public final AsciiString text() {
            return this.text;
        }
    }
}

