/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemValue;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;

public final class PemX509Certificate
extends X509Certificate
implements PemEncoded {
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] END_CERT = "\n-----END CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
    private final ByteBuf content;

    static PemEncoded toPEM(ByteBufAllocator byteBufAllocator, boolean bl, X509Certificate ... x509CertificateArray) {
        X509Certificate x509Certificate;
        ObjectUtil.checkNonEmpty((Object[])x509CertificateArray, (String)"chain");
        if (x509CertificateArray.length == 1 && (x509Certificate = x509CertificateArray[0]) instanceof PemEncoded) {
            return ((PemEncoded)((Object)x509Certificate)).retain();
        }
        boolean bl2 = false;
        ByteBuf byteBuf = null;
        try {
            Object object = x509CertificateArray;
            int n = x509CertificateArray.length;
            for (int i = 0; i < n; ++i) {
                X509Certificate x509Certificate2 = object[i];
                if (x509Certificate2 == null) {
                    throw new IllegalArgumentException("Null element in chain: " + Arrays.toString(x509CertificateArray));
                }
                byteBuf = x509Certificate2 instanceof PemEncoded ? PemX509Certificate.append(byteBufAllocator, bl, (PemEncoded)((Object)x509Certificate2), x509CertificateArray.length, byteBuf) : PemX509Certificate.append(byteBufAllocator, bl, x509Certificate2, x509CertificateArray.length, byteBuf);
            }
            object = new PemValue(byteBuf, false);
            bl2 = true;
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (!bl2 && byteBuf != null) {
                byteBuf.release();
            }
            throw throwable;
        }
    }

    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl, PemEncoded pemEncoded, int n, ByteBuf byteBuf) {
        pemEncoded = pemEncoded.content();
        if (byteBuf == null) {
            byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl, pemEncoded.readableBytes() * n);
        }
        byteBuf.writeBytes(pemEncoded.slice());
        return byteBuf;
    }

    private static ByteBuf append(ByteBufAllocator byteBufAllocator, boolean bl, X509Certificate x509Certificate, int n, ByteBuf byteBuf) {
        x509Certificate = Unpooled.wrappedBuffer((byte[])x509Certificate.getEncoded());
        try {
            ByteBuf byteBuf2 = SslUtils.toBase64(byteBufAllocator, (ByteBuf)x509Certificate);
            try {
                if (byteBuf == null) {
                    byteBuf = PemX509Certificate.newBuffer(byteBufAllocator, bl, (BEGIN_CERT.length + byteBuf2.readableBytes() + END_CERT.length) * n);
                }
                byteBuf.writeBytes(BEGIN_CERT);
                byteBuf.writeBytes(byteBuf2);
                byteBuf.writeBytes(END_CERT);
            }
            finally {
                byteBuf2.release();
            }
        }
        finally {
            x509Certificate.release();
        }
        return byteBuf;
    }

    private static ByteBuf newBuffer(ByteBufAllocator byteBufAllocator, boolean bl, int n) {
        if (bl) {
            return byteBufAllocator.directBuffer(n);
        }
        return byteBufAllocator.buffer(n);
    }

    public static PemX509Certificate valueOf(byte[] byArray) {
        return PemX509Certificate.valueOf(Unpooled.wrappedBuffer((byte[])byArray));
    }

    public static PemX509Certificate valueOf(ByteBuf byteBuf) {
        return new PemX509Certificate(byteBuf);
    }

    private PemX509Certificate(ByteBuf byteBuf) {
        this.content = (ByteBuf)ObjectUtil.checkNotNull((Object)byteBuf, (String)"content");
    }

    @Override
    public final boolean isSensitive() {
        return false;
    }

    public final int refCnt() {
        return this.content.refCnt();
    }

    public final ByteBuf content() {
        int n = this.refCnt();
        if (n <= 0) {
            throw new IllegalReferenceCountException(n);
        }
        return this.content;
    }

    @Override
    public final PemX509Certificate copy() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.copy());
    }

    @Override
    public final PemX509Certificate duplicate() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.duplicate());
    }

    @Override
    public final PemX509Certificate retainedDuplicate() {
        PemX509Certificate pemX509Certificate = this;
        return pemX509Certificate.replace(pemX509Certificate.content.retainedDuplicate());
    }

    @Override
    public final PemX509Certificate replace(ByteBuf byteBuf) {
        return new PemX509Certificate(byteBuf);
    }

    @Override
    public final PemX509Certificate retain() {
        this.content.retain();
        return this;
    }

    @Override
    public final PemX509Certificate retain(int n) {
        this.content.retain(n);
        return this;
    }

    @Override
    public final PemX509Certificate touch() {
        this.content.touch();
        return this;
    }

    @Override
    public final PemX509Certificate touch(Object object) {
        this.content.touch(object);
        return this;
    }

    public final boolean release() {
        return this.content.release();
    }

    public final boolean release(int n) {
        return this.content.release(n);
    }

    @Override
    public final byte[] getEncoded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Set<String> getNonCriticalExtensionOIDs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getExtensionValue(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkValidity(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final BigInteger getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getIssuerDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Principal getSubjectDN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotBefore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Date getNotAfter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getTBSCertificate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getSigAlgOID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final byte[] getSigAlgParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean[] getKeyUsage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getBasicConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey publicKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void verify(PublicKey publicKey, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PemX509Certificate)) {
            return false;
        }
        object = (PemX509Certificate)object;
        return this.content.equals((Object)((PemX509Certificate)object).content);
    }

    @Override
    public final int hashCode() {
        return this.content.hashCode();
    }

    @Override
    public final String toString() {
        return this.content.toString(CharsetUtil.UTF_8);
    }
}

