/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsyncMapping;
import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    protected final AsyncMapping<String, SslContext> mapping;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, int n, long l) {
        this(new AsyncMappingAdapter(mapping), n, l);
    }

    public SniHandler(DomainNameMapping<? extends SslContext> domainNameMapping) {
        this((Mapping<? super String, ? extends SslContext>)domainNameMapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping) {
        this(asyncMapping, 0, 0L);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping, int n, long l) {
        super(n, l);
        this.mapping = (AsyncMapping)ObjectUtil.checkNotNull(asyncMapping, (String)"mapping");
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, long l) {
        this(new AsyncMappingAdapter(mapping), l);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping, long l) {
        this(asyncMapping, 0, l);
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    @Override
    protected Future<SslContext> lookup(ChannelHandlerContext channelHandlerContext, String string) {
        return this.mapping.map((Object)string, channelHandlerContext.executor().newPromise());
    }

    @Override
    protected final void onLookupComplete(ChannelHandlerContext channelHandlerContext, String string, Future<SslContext> object) {
        if (!object.isSuccess()) {
            if ((object = object.cause()) instanceof Error) {
                throw (Error)object;
            }
            throw new DecoderException("failed to get the SslContext for " + string, object);
        }
        object = (SslContext)object.getNow();
        this.selection = new Selection((SslContext)object, string);
        try {
            this.replaceHandler(channelHandlerContext, string, (SslContext)object);
            return;
        }
        catch (Throwable throwable) {
            this.selection = EMPTY_SELECTION;
            PlatformDependent.throwException((Throwable)throwable);
            return;
        }
    }

    protected void replaceHandler(ChannelHandlerContext channelHandlerContext, String object, SslContext sslContext) {
        object = null;
        try {
            object = this.newSslHandler(sslContext, channelHandlerContext.alloc());
            channelHandlerContext.pipeline().replace((ChannelHandler)this, SslHandler.class.getName(), (ChannelHandler)object);
            object = null;
            return;
        }
        catch (Throwable throwable) {
            if (object != null) {
                ReferenceCountUtil.safeRelease((Object)((SslHandler)((Object)object)).engine());
            }
            throw throwable;
        }
    }

    protected SslHandler newSslHandler(SslContext object, ByteBufAllocator byteBufAllocator) {
        object = object.newHandler(byteBufAllocator);
        ((SslHandler)((Object)object)).setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        return object;
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext sslContext, String string) {
            this.context = sslContext;
            this.hostname = string;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = (Mapping)ObjectUtil.checkNotNull(mapping, (String)"mapping");
        }

        public final Future<SslContext> map(String object, Promise<SslContext> promise) {
            try {
                object = (SslContext)this.mapping.map(object);
            }
            catch (Throwable throwable) {
                return promise.setFailure(throwable);
            }
            return promise.setSuccess(object);
        }
    }
}

