/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;

public abstract class SslClientHelloHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    public static final int MAX_CLIENT_HELLO_LENGTH = 0xFFFFFF;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslClientHelloHandler.class);
    private final int maxClientHelloLength;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private ByteBuf handshakeBuffer;

    public SslClientHelloHandler() {
        this(0xFFFFFF);
    }

    protected SslClientHelloHandler(int n) {
        this.maxClientHelloLength = ObjectUtil.checkInRange((int)n, (int)0, (int)0xFFFFFF, (String)"maxClientHelloLength");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> object) {
        if (!this.suppressRead && !this.handshakeFailed) {
            try {
                int n = byteBuf.readerIndex();
                int n2 = byteBuf.readableBytes();
                int n3 = -1;
                block8: while (true) {
                    if (n2 < 5) {
                        return;
                    }
                    int n4 = byteBuf.getUnsignedByte(n);
                    switch (n4) {
                        case 20: 
                        case 21: {
                            n = SslUtils.getEncryptedPacketLength(byteBuf, n, true);
                            if (n == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)byteBuf));
                                ByteBuf byteBuf2 = byteBuf;
                                byteBuf2.skipBytes(byteBuf2.readableBytes());
                                channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(notSslRecordException));
                                SslUtils.handleHandshakeFailure(channelHandlerContext, notSslRecordException, true);
                                throw notSslRecordException;
                            }
                            if (n == -1) {
                                return;
                            }
                            this.select(channelHandlerContext, null);
                            return;
                        }
                        case 22: {
                            n4 = byteBuf.getUnsignedByte(n + 1);
                            if (n4 != 3) break block8;
                            n4 = byteBuf.getUnsignedShort(n + 3) + 5;
                            if (n2 < n4) {
                                return;
                            }
                            if (n4 == 5) {
                                this.select(channelHandlerContext, null);
                                return;
                            }
                            int n5 = n + n4;
                            if (n3 == -1) {
                                if (n + 4 > n5) {
                                    return;
                                }
                                short s = byteBuf.getUnsignedByte(n + 5);
                                n3 = s;
                                if (s != 1) {
                                    this.select(channelHandlerContext, null);
                                    return;
                                }
                                n3 = byteBuf.getUnsignedMedium(n + 5 + 1);
                                if (n3 > this.maxClientHelloLength && this.maxClientHelloLength != 0) {
                                    TooLongFrameException tooLongFrameException = new TooLongFrameException("ClientHello length exceeds " + this.maxClientHelloLength + ": " + n3);
                                    ByteBuf byteBuf3 = byteBuf;
                                    byteBuf3.skipBytes(byteBuf3.readableBytes());
                                    channelHandlerContext.fireUserEventTriggered((Object)new SniCompletionEvent(tooLongFrameException));
                                    SslUtils.handleHandshakeFailure(channelHandlerContext, tooLongFrameException, true);
                                    throw tooLongFrameException;
                                }
                                n += 4;
                                if (n3 + 4 + 5 <= (n4 -= 4)) {
                                    this.select(channelHandlerContext, byteBuf.retainedSlice(n += 5, n3));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = channelHandlerContext.alloc().buffer(n3);
                                } else {
                                    this.handshakeBuffer.clear();
                                }
                            }
                            this.handshakeBuffer.writeBytes(byteBuf, n + 5, n4 - 5);
                            n += n4;
                            n2 -= n4;
                            if (n3 > this.handshakeBuffer.readableBytes()) continue block8;
                            ByteBuf byteBuf4 = this.handshakeBuffer.setIndex(0, n3);
                            this.handshakeBuffer = null;
                            this.select(channelHandlerContext, byteBuf4);
                            return;
                        }
                    }
                    break;
                }
                this.select(channelHandlerContext, null);
                return;
            }
            catch (NotSslRecordException notSslRecordException) {
                object = notSslRecordException;
                throw notSslRecordException;
            }
            catch (TooLongFrameException tooLongFrameException) {
                object = tooLongFrameException;
                throw tooLongFrameException;
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump((ByteBuf)byteBuf), (Throwable)exception);
                }
                this.select(channelHandlerContext, null);
            }
        }
    }

    private void releaseHandshakeBuffer() {
        SslClientHelloHandler.releaseIfNotNull(this.handshakeBuffer);
        this.handshakeBuffer = null;
    }

    private static void releaseIfNotNull(ByteBuf byteBuf) {
        if (byteBuf != null) {
            byteBuf.release();
        }
    }

    private void select(final ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            Future<T> future = this.lookup(channelHandlerContext, byteBuf);
            if (future.isDone()) {
                this.onLookupComplete(channelHandlerContext, future);
            } else {
                this.suppressRead = true;
                final ByteBuf byteBuf2 = byteBuf;
                future.addListener((GenericFutureListener)new FutureListener<T>(){

                    public void operationComplete(Future<T> future) {
                        SslClientHelloHandler.releaseIfNotNull(byteBuf2);
                        try {
                            SslClientHelloHandler.this.suppressRead = false;
                            try {
                                SslClientHelloHandler.this.onLookupComplete(channelHandlerContext, future);
                            }
                            catch (DecoderException decoderException) {
                                channelHandlerContext.fireExceptionCaught((Throwable)decoderException);
                            }
                            catch (Exception exception) {
                                channelHandlerContext.fireExceptionCaught((Throwable)new DecoderException((Throwable)exception));
                            }
                            catch (Throwable throwable) {
                                channelHandlerContext.fireExceptionCaught(throwable);
                            }
                        }
                        catch (Throwable throwable) {
                            if (SslClientHelloHandler.this.readPending) {
                                SslClientHelloHandler.this.readPending = false;
                                channelHandlerContext.read();
                            }
                            throw throwable;
                        }
                        if (SslClientHelloHandler.this.readPending) {
                            SslClientHelloHandler.this.readPending = false;
                            channelHandlerContext.read();
                            return;
                        }
                    }
                });
                byteBuf = null;
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            PlatformDependent.throwException((Throwable)throwable);
            return;
        }
        finally {
            SslClientHelloHandler.releaseIfNotNull(byteBuf);
        }
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.releaseHandshakeBuffer();
        super.handlerRemoved0(channelHandlerContext);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, ByteBuf var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, Future<T> var2);

    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.suppressRead) {
            this.readPending = true;
            return;
        }
        channelHandlerContext.read();
    }

    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        channelHandlerContext.write(object, channelPromise);
    }

    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }
}

