/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.IntegerUnixChannelOption;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.RawUnixChannelOption;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class EpollChannelConfig
extends DefaultChannelConfig {
    private volatile long maxBytesPerGatheringWrite = Limits.SSIZE_MAX;

    protected EpollChannelConfig(Channel channel) {
        super(EpollChannelConfig.checkAbstractEpollChannel(channel));
    }

    protected EpollChannelConfig(Channel channel, RecvByteBufAllocator recvByteBufAllocator) {
        super(EpollChannelConfig.checkAbstractEpollChannel(channel), recvByteBufAllocator);
    }

    protected LinuxSocket socket() {
        return ((AbstractEpollChannel)this.channel).socket;
    }

    private static Channel checkAbstractEpollChannel(Channel channel) {
        if (!(channel instanceof AbstractEpollChannel)) {
            throw new IllegalArgumentException("channel is not AbstractEpollChannel: " + channel.getClass());
        }
        return channel;
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        EpollChannelConfig epollChannelConfig = this;
        return epollChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{EpollChannelOption.EPOLL_MODE});
    }

    public <T> T getOption(ChannelOption<T> integerUnixChannelOption) {
        if (integerUnixChannelOption == EpollChannelOption.EPOLL_MODE) {
            return (T)((Object)this.getEpollMode());
        }
        try {
            if (integerUnixChannelOption instanceof IntegerUnixChannelOption) {
                integerUnixChannelOption = integerUnixChannelOption;
                return (T)Integer.valueOf(((AbstractEpollChannel)this.channel).socket.getIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname()));
            }
            if (integerUnixChannelOption instanceof RawUnixChannelOption) {
                integerUnixChannelOption = (RawUnixChannelOption)integerUnixChannelOption;
                ByteBuffer byteBuffer = ByteBuffer.allocate(integerUnixChannelOption.length());
                ((AbstractEpollChannel)this.channel).socket.getRawOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), byteBuffer);
                return (T)byteBuffer.flip();
            }
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
        return (T)super.getOption((ChannelOption)integerUnixChannelOption);
    }

    public <T> boolean setOption(ChannelOption<T> integerUnixChannelOption, T t) {
        this.validate((ChannelOption)integerUnixChannelOption, t);
        if (integerUnixChannelOption != EpollChannelOption.EPOLL_MODE) {
            try {
                if (integerUnixChannelOption instanceof IntegerUnixChannelOption) {
                    integerUnixChannelOption = integerUnixChannelOption;
                    ((AbstractEpollChannel)this.channel).socket.setIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), (Integer)t);
                    return true;
                }
                if (integerUnixChannelOption instanceof RawUnixChannelOption) {
                    integerUnixChannelOption = (RawUnixChannelOption)integerUnixChannelOption;
                    ((AbstractEpollChannel)this.channel).socket.setRawOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), (ByteBuffer)t);
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new ChannelException((Throwable)iOException);
            }
            return super.setOption((ChannelOption)integerUnixChannelOption, t);
        }
        this.setEpollMode((EpollMode)((Object)t));
        return true;
    }

    public EpollChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Deprecated
    public EpollChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    public EpollChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    public EpollChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    public EpollChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        if (!(recvByteBufAllocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
            throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
        }
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    public EpollChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Deprecated
    public EpollChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Deprecated
    public EpollChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    public EpollChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public EpollChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    public EpollMode getEpollMode() {
        if (((AbstractEpollChannel)this.channel).isFlagSet(Native.EPOLLET)) {
            return EpollMode.EDGE_TRIGGERED;
        }
        return EpollMode.LEVEL_TRIGGERED;
    }

    public EpollChannelConfig setEpollMode(EpollMode epollMode) {
        ObjectUtil.checkNotNull((Object)((Object)epollMode), (String)"mode");
        try {
            switch (epollMode) {
                case EDGE_TRIGGERED: {
                    this.checkChannelNotRegistered();
                    ((AbstractEpollChannel)this.channel).setFlag(Native.EPOLLET);
                    break;
                }
                case LEVEL_TRIGGERED: {
                    this.checkChannelNotRegistered();
                    ((AbstractEpollChannel)this.channel).clearFlag(Native.EPOLLET);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
        return this;
    }

    private void checkChannelNotRegistered() {
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("EpollMode can only be changed before channel is registered");
        }
    }

    protected final void autoReadCleared() {
        ((AbstractEpollChannel)this.channel).clearEpollIn();
    }

    protected final void setMaxBytesPerGatheringWrite(long l) {
        this.maxBytesPerGatheringWrite = l;
    }

    protected final long getMaxBytesPerGatheringWrite() {
        return this.maxBytesPerGatheringWrite;
    }
}

