/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelHandlerFactoryMethod;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.ModelFilter;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.PhaseIndicator;
import ch.qos.logback.core.model.processor.ProcessingPhase;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;

public class DefaultProcessor
extends ContextAwareBase {
    protected final ModelInterpretationContext mic;
    final HashMap<Class<? extends Model>, ModelHandlerFactoryMethod> modelClassToHandlerMap = new HashMap();
    final HashMap<Class<? extends Model>, Supplier<ModelHandlerBase>> modelClassToDependencyAnalyserMap = new HashMap();
    ChainedModelFilter phaseOneFilter = new ChainedModelFilter();
    ChainedModelFilter phaseTwoFilter = new ChainedModelFilter();
    static final int DENIED = -1;

    public DefaultProcessor(Context context, ModelInterpretationContext modelInterpretationContext) {
        this.setContext(context);
        this.mic = modelInterpretationContext;
    }

    public void addHandler(Class<? extends Model> clazz, ModelHandlerFactoryMethod object) {
        this.modelClassToHandlerMap.put(clazz, (ModelHandlerFactoryMethod)object);
        object = this.determineProcessingPhase(clazz);
        switch (1.$SwitchMap$ch$qos$logback$core$model$processor$ProcessingPhase[((Enum)object).ordinal()]) {
            case 1: {
                this.getPhaseOneFilter().allow(clazz);
                return;
            }
            case 2: {
                this.getPhaseTwoFilter().allow(clazz);
                return;
            }
        }
        throw new IllegalArgumentException("unexpected value " + String.valueOf(object) + " for model class " + clazz.getName());
    }

    private ProcessingPhase determineProcessingPhase(Class<? extends Model> object) {
        if ((object = ((Class)object).getAnnotation(PhaseIndicator.class)) == null) {
            return ProcessingPhase.FIRST;
        }
        object = object.phase();
        return object;
    }

    public void addAnalyser(Class<? extends Model> clazz, Supplier<ModelHandlerBase> supplier) {
        this.modelClassToDependencyAnalyserMap.put(clazz, supplier);
    }

    private void traversalLoop(TraverseMethod traverseMethod, Model model, ModelFilter modelFilter, String string) {
        int n;
        for (int i = 0; i < 3 && (n = traverseMethod.traverse(model, modelFilter)) != 0; ++i) {
        }
    }

    public void process(Model model) {
        if (model == null) {
            this.addError("Expecting non null model to process");
            return;
        }
        this.initialObjectPush();
        this.mainTraverse(model, this.getPhaseOneFilter());
        this.analyseDependencies(model);
        DefaultProcessor defaultProcessor = this;
        defaultProcessor.traversalLoop(defaultProcessor::secondPhaseTraverse, model, this.getPhaseTwoFilter(), "phase 2");
        this.addInfo("End of configuration.");
        this.finalObjectPop();
    }

    private void finalObjectPop() {
        this.mic.popObject();
    }

    private void initialObjectPush() {
        this.mic.pushObject(this.context);
    }

    public ChainedModelFilter getPhaseOneFilter() {
        return this.phaseOneFilter;
    }

    public ChainedModelFilter getPhaseTwoFilter() {
        return this.phaseTwoFilter;
    }

    protected void analyseDependencies(Model model) {
        Supplier<ModelHandlerBase> supplier = this.modelClassToDependencyAnalyserMap.get(model.getClass());
        ModelHandlerBase modelHandlerBase = null;
        if (supplier != null) {
            modelHandlerBase = supplier.get();
        }
        if (modelHandlerBase != null && !model.isSkipped()) {
            this.callAnalyserHandleOnModel(model, modelHandlerBase);
        }
        for (Model model2 : model.getSubModels()) {
            this.analyseDependencies(model2);
        }
        if (modelHandlerBase != null && !model.isSkipped()) {
            this.callAnalyserPostHandleOnModel(model, modelHandlerBase);
        }
    }

    private void callAnalyserPostHandleOnModel(Model model, ModelHandlerBase modelHandlerBase) {
        try {
            modelHandlerBase.postHandle(this.mic, model);
            return;
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to invoke postHandle on model " + model.getTag(), modelHandlerException);
            return;
        }
    }

    private void callAnalyserHandleOnModel(Model model, ModelHandlerBase modelHandlerBase) {
        try {
            modelHandlerBase.handle(this.mic, model);
            return;
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
            return;
        }
    }

    private ModelHandlerBase createHandler(Model model) {
        Object object = this.modelClassToHandlerMap.get(model.getClass());
        if (object == null) {
            this.addError("Can't handle model of type " + String.valueOf(model.getClass()) + "  with tag: " + model.getTag() + " at line " + model.getLineNumber());
            return null;
        }
        if ((object = object.make(this.context, this.mic)) == null) {
            return null;
        }
        if (!((ModelHandlerBase)object).isSupportedModelType(model)) {
            this.addWarn("Handler [" + String.valueOf(object.getClass()) + "] does not support " + model.idString());
            return null;
        }
        return object;
    }

    protected int mainTraverse(Model model, ModelFilter modelFilter) {
        FilterReply filterReply = modelFilter.decide(model);
        if (filterReply == FilterReply.DENY) {
            return -1;
        }
        int n = 0;
        try {
            ModelHandlerBase modelHandlerBase = null;
            boolean bl = model.isUnhandled();
            if (bl && (modelHandlerBase = this.createHandler(model)) != null) {
                modelHandlerBase.handle(this.mic, model);
                model.markAsHandled();
                ++n;
            }
            if (!model.isSkipped()) {
                for (Model model2 : model.getSubModels()) {
                    n += this.mainTraverse(model2, modelFilter);
                }
            }
            if (bl && modelHandlerBase != null) {
                modelHandlerBase.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
        }
        return n;
    }

    protected int secondPhaseTraverse(Model model, ModelFilter modelFilter) {
        FilterReply filterReply = modelFilter.decide(model);
        if (filterReply == FilterReply.DENY) {
            return 0;
        }
        int n = 0;
        try {
            boolean bl = this.allDependenciesStarted(model);
            ModelHandlerBase modelHandlerBase = null;
            if (model.isUnhandled() && bl && (modelHandlerBase = this.createHandler(model)) != null) {
                modelHandlerBase.handle(this.mic, model);
                model.markAsHandled();
                ++n;
            }
            if (!bl && !this.dependencyIsADirectSubmodel(model)) {
                return n;
            }
            if (!model.isSkipped()) {
                for (Model model2 : model.getSubModels()) {
                    n += this.secondPhaseTraverse(model2, modelFilter);
                }
            }
            if (modelHandlerBase != null) {
                modelHandlerBase.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException modelHandlerException) {
            this.addError("Failed to traverse model " + model.getTag(), modelHandlerException);
        }
        return n;
    }

    private boolean dependencyIsADirectSubmodel(Model object) {
        List<String> list = this.mic.getDependeeNamesForModel((Model)((Object)object));
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Model model : ((Model)((Object)object)).getSubModels()) {
            NamedComponentModel namedComponentModel;
            String string;
            if (!(model instanceof NamedComponentModel) || !list.contains(string = (namedComponentModel = (NamedComponentModel)model).getName())) continue;
            return true;
        }
        return false;
    }

    private boolean allDependenciesStarted(Model iterator) {
        if ((iterator = this.mic.getDependeeNamesForModel((Model)((Object)iterator))) == null || iterator.isEmpty()) {
            return true;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            boolean bl = this.mic.isNamedDependeeStarted(string);
            if (bl) continue;
            return false;
        }
        return true;
    }

    ModelHandlerBase instantiateHandler(Class<? extends ModelHandlerBase> clazz) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = this.getWithContextConstructor(clazz);
            if (constructor != null) {
                return constructor.newInstance(this.context);
            }
            constructor = this.getWithContextAndBDCConstructor(clazz);
            if (constructor != null) {
                return constructor.newInstance(this.context, this.mic.getBeanDescriptionCache());
            }
            this.addError("Failed to find suitable constructor for class [" + String.valueOf(clazz) + "]");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            this.addError("Failed to instantiate " + String.valueOf(clazz));
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextConstructor(Class<? extends ModelHandlerBase> genericDeclaration) {
        try {
            genericDeclaration = genericDeclaration.getConstructor(Context.class);
            return genericDeclaration;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextAndBDCConstructor(Class<? extends ModelHandlerBase> genericDeclaration) {
        try {
            genericDeclaration = genericDeclaration.getConstructor(Context.class, BeanDescriptionCache.class);
            return genericDeclaration;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    static interface TraverseMethod {
        public int traverse(Model var1, ModelFilter var2);
    }
}

