/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Token;
import java.util.List;

public class Parser {
    public static final String EXPECTING_DATA_AFTER_LEFT_ACCOLADE = "Expecting at least a literal between left accolade and ':-'";
    final List<Token> tokenList;
    int pointer = 0;

    public Parser(List<Token> list) {
        this.tokenList = list;
    }

    public Node parse() {
        if (this.tokenList == null || this.tokenList.isEmpty()) {
            return null;
        }
        return this.E();
    }

    private Node E() {
        Node node = this.T();
        if (node == null) {
            return null;
        }
        Node node2 = this.Eopt();
        if (node2 != null) {
            node.append(node2);
        }
        return node;
    }

    private Node Eopt() {
        Token token = this.peekAtCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    private Node T() {
        Object object = this.peekAtCurentToken();
        if (object == null) {
            return null;
        }
        switch (((Token)object).type) {
            case LITERAL: {
                this.advanceTokenPointer();
                return this.makeNewLiteralNode(((Token)object).payload);
            }
            case CURLY_LEFT: {
                this.advanceTokenPointer();
                object = this.C();
                Object object2 = this.peekAtCurentToken();
                this.expectCurlyRight((Token)object2);
                this.advanceTokenPointer();
                object2 = this.makeNewLiteralNode(CoreConstants.LEFT_ACCOLADE);
                ((Node)object2).append((Node)object);
                ((Node)object2).append(this.makeNewLiteralNode(CoreConstants.RIGHT_ACCOLADE));
                return object2;
            }
            case START: {
                this.advanceTokenPointer();
                object = this.V();
                Token token = this.peekAtCurentToken();
                this.expectCurlyRight(token);
                this.advanceTokenPointer();
                return object;
            }
        }
        return null;
    }

    private Node makeNewLiteralNode(String string) {
        return new Node(Node.Type.LITERAL, string);
    }

    private Node V() {
        Node node = this.E();
        node = new Node(Node.Type.VARIABLE, node);
        Object object = this.peekAtCurentToken();
        if (this.isDefaultToken((Token)object)) {
            this.advanceTokenPointer();
            object = this.Eopt();
            node.defaultPart = object != null ? object : this.makeNewLiteralNode("");
        }
        return node;
    }

    private Node C() {
        Node node = this.E();
        Object object = this.peekAtCurentToken();
        if (this.isDefaultToken((Token)object)) {
            this.advanceTokenPointer();
            object = this.makeNewLiteralNode(":-");
            if (node == null) {
                throw new ScanException(EXPECTING_DATA_AFTER_LEFT_ACCOLADE);
            }
            node.append((Node)object);
            object = this.E();
            node.append((Node)object);
        }
        return node;
    }

    private boolean isDefaultToken(Token token) {
        return token != null && token.type == Token.Type.DEFAULT;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token token, String string) {
        if (token == null) {
            throw new IllegalArgumentException("All tokens consumed but was expecting \"" + string + "\"");
        }
    }

    void expectCurlyRight(Token token) {
        this.expectNotNull(token, "}");
        if (token.type != Token.Type.CURLY_RIGHT) {
            throw new ScanException("Expecting }");
        }
    }

    Token peekAtCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }
}

