/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.gnomeShell;

import dorkbox.executor.Executor;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.KotlinUtils;
import dorkbox.util.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;

public class ExtensionSupport {
    static final List<String> enabledExtensions = ExtensionSupport.getEnabledExtensions();
    private final String name;
    private final String UID;
    private final String zipFile;

    public ExtensionSupport(String string, String string2, String string3) {
        this.UID = string2;
        this.name = string;
        this.zipFile = string3;
    }

    public void uninstall() {
        ExtensionSupport.unInstall(this.UID, null);
    }

    public boolean isInstalled() {
        return enabledExtensions.contains(this.UID);
    }

    public void install() {
        boolean bl;
        String string;
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing the " + this.name + " gnome-shell extension.");
        }
        if ((string = ExtensionSupport.getGnomeVersion()) == null) {
            return;
        }
        boolean bl2 = enabledExtensions.contains(this.UID);
        Object object = System.getProperty("user.home");
        object = new File((String)object + "/.local/share/gnome-shell/extensions/" + this.UID);
        File file = new File((File)object, "metadata.json");
        string = ExtensionSupport.createMetadata(this.UID, SystemTray.getVersion(), "SystemTray", string);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Checking the " + this.name + " gnome-shell extension");
        }
        if (bl2 && !ExtensionSupport.needsUpgrade(string, file)) {
            return;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installing " + this.name + " gnome-shell extension");
        }
        if (bl = ExtensionSupport.writeFile(string, file)) {
            bl = ExtensionSupport.installZip(this.zipFile, (File)object);
            if (!bl) {
                SystemTray.logger.error("Unable to install " + this.zipFile + " gnome-shell extension!");
            } else if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Enabling " + this.zipFile + " gnome-shell extension");
            }
            if (!enabledExtensions.contains(this.UID)) {
                enabledExtensions.add(this.UID);
            }
            ExtensionSupport.setEnabledExtensions(enabledExtensions);
        }
    }

    public static List<String> getEnabledExtensions() {
        String[] stringArray;
        try {
            stringArray = KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "get", "org.gnome.shell", "enabled-extensions");
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to get gnome shell extensions!", (Throwable)exception);
            stringArray = "";
        }
        StringBuilder stringBuilder = new StringBuilder((String)stringArray);
        int n = stringArray.indexOf("]");
        if (n > 0) {
            stringBuilder.delete(n, stringBuilder.length());
        }
        if ((n = stringArray.indexOf("[")) >= 0) {
            stringBuilder.delete(0, n + 1);
        }
        stringArray = stringBuilder.toString();
        stringArray = stringArray.split(", ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n2 = string2.indexOf("'");
            int n3 = string2.lastIndexOf("'");
            if (n2 != 0 || n3 != string2.length() - 1) continue;
            stringArray[i] = string2.substring(1, string2.length() - 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.removeIf(string -> string.trim().isEmpty());
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Installed extensions are: {}", arrayList);
        }
        return arrayList;
    }

    public static void setEnabledExtensions(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n = list.size();
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string.isEmpty()) continue;
            stringBuilder.append("'").append(string).append("'");
            if (i >= n2) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Setting installed extensions to: {}", (Object)stringBuilder.toString());
        }
        try {
            KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "set", "org.gnome.shell", "enabled-extensions", stringBuilder.toString());
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to set gnome shell extensions!", (Throwable)exception);
            return;
        }
    }

    public static void unInstall(String object, String string) {
        String string2;
        boolean bl = enabledExtensions.contains(object);
        if (bl) {
            enabledExtensions.remove(object);
            ExtensionSupport.setEnabledExtensions(enabledExtensions);
        }
        if (((File)(object = new File((string2 = System.getProperty("user.home")) + "/.local/share/gnome-shell/extensions/" + (String)object))).canRead()) {
            KotlinUtils.INSTANCE.delete((File)object);
        }
        if (bl) {
            ExtensionSupport.restartShell(string);
        }
    }

    public static void restartShell(String string) {
        if (string == null) {
            return;
        }
        SystemTray.logger.info("Restarting gnome-shell via '{}' so tray notification changes can be applied.", (Object)string);
        try {
            new Executor().command(new String[]{string}).startAsShellBlocking();
            return;
        }
        catch (Exception exception) {
            SystemTray.logger.error("Unable to restart gnome shell!", (Throwable)exception);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean writeFile(String var0, File var1_5) {
        var2_7 = var1_5.getParentFile();
        if (!var2_7.isDirectory() && !(var3_8 = var2_7.mkdirs())) {
            var0 = "Unable to create extension location: " + var2_7;
            SystemTray.logger.error(var0);
            return false;
        }
        var3_9 = null;
        try {
            var3_9 = new BufferedWriter(new FileWriter(var1_5, false));
            var3_9.write(var0);
            var3_9.flush();
            var3_9.close();
            ** try [egrp 1[TRYBLOCK] [0 : 81->88)] { 
        }
        catch (IOException var0_2) {
            SystemTray.logger.error("Error installing extension metadata file", (Throwable)var0_2);
            return true;
        }
        finally {
            if (var3_9 != null) {
                try {
                    var3_9.close();
                }
                catch (IOException var0_3) {
                    SystemTray.logger.error("Error closing: {}", (Object)var3_9, (Object)var0_3);
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            var3_9.close();
        }
lbl15:
        // 1 sources

        catch (IOException var0_1) {
            SystemTray.logger.error("Error closing: {}", (Object)var3_9, (Object)var0_1);
        }
        {
        }
        return true;
    }

    protected static boolean installFile(String object, File object2, String string) {
        object2 = new File((File)object2, (String)object);
        try {
            Object object3 = ExtensionSupport.class.getResourceAsStream((String)object);
            if (object3 == null) {
                SystemTray.logger.error("The {} file resource cannot be found. Something is severely wrong.", object);
                return false;
            }
            object = new FileWriter((File)object2);
            object2 = new InputStreamReader((InputStream)object3);
            try {
                String string2;
                object3 = OS.INSTANCE.getLINE_SEPARATOR();
                BufferedReader bufferedReader = new BufferedReader((Reader)object2);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("let APP_NAME = \"")) {
                        string2 = "let APP_NAME = \"" + string + "\";";
                    }
                    ((Writer)object).write(string2);
                    ((Writer)object).write((String)object3);
                }
            }
            finally {
                IO.closeQuietly((Closeable)object2);
                IO.closeQuietly((Closeable)object);
            }
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            SystemTray.logger.error("Cannot find gnome-shell extension", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            SystemTray.logger.error("Unable to get gnome-shell extension", (Throwable)iOException);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean installZip(String var0, File var1_13) {
        block35: {
            var2_16 = null;
            var3_17 = null;
            try {
                var0 = ExtensionSupport.class.getResourceAsStream((String)var0);
                if (var0 == null) {
                    SystemTray.logger.error("The appindicator extension resource cannot be found. This is unexpected!");
                    return false;
                }
                var2_16 = new ZipInputStream((InputStream)var0);
                while ((var0 = var2_16.getNextEntry()) != null) {
                    if (var0.isDirectory()) continue;
                    var0 = var0.getName();
                    try {
                        var0 = new File(var1_13, (String)var0);
                        var4_18 = var0.getParentFile();
                        if (!var4_18.exists() && !(var5_19 = var4_18.mkdirs())) {
                            SystemTray.logger.error("Error creating target directory '{}' for Zip support.", (Object)var4_18);
                        }
                        var3_17 = new FileOutputStream((File)var0);
                        IO.copyStream((InputStream)var2_16, (OutputStream)var3_17);
                        IO.closeQuietly((Closeable)var3_17);
                        var3_17 = null;
                    }
                    catch (IOException v0) {
                        SystemTray.logger.error("Error extracting zip contents to {}", (Object)var1_13);
                    }
                    finally {
                        if (var3_17 == null) continue;
                        IO.closeQuietly((Closeable)var3_17);
                        var3_17 = null;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [3 : 168->175)] { 
            }
            catch (FileNotFoundException var0_4) {
                SystemTray.logger.error("Cannot find gnome-shell extension", (Throwable)var0_4);
                break block35;
            }
            catch (IOException var0_8) {
                SystemTray.logger.error("Unable to get gnome-shell extension", (Throwable)var0_8);
                break block35;
            }
            finally {
                if (var2_16 != null) {
                    try {
                        var2_16.close();
                    }
                    catch (IOException var0_5) {
                        SystemTray.logger.error("Error closing: {}", (Object)var2_16, (Object)var0_5);
                    }
                }
                if (var3_17 != null) {
                    try {
                        var3_17.close();
                    }
                    catch (IOException var0_7) {
                        SystemTray.logger.error("Error closing: {}", (Object)var3_17, (Object)var0_7);
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                var2_16.close();
            }
lbl37:
            // 1 sources

            catch (IOException var0_2) {
                SystemTray.logger.error("Error closing: {}", (Object)var2_16, (Object)var0_2);
            }
            if (var3_17 != null) {
                try {
                    var3_17.close();
                }
                catch (IOException var0_3) {
                    SystemTray.logger.error("Error closing: {}", (Object)var3_17, (Object)var0_3);
                }
            }
            return true;
        }
        return false;
    }

    protected static String createMetadata(String string, String string2, String string3, String string4) {
        return "{\n  \"description\": \"Moves the java SystemTray icon from inside the notification drawer to alongside the clock.\",\n  \"name\": \"Dorkbox SystemTray\",\n  \"app-name-id\": \"" + string3 + "\",\n  \"shell-version\": [\n    \"" + string4 + "\"\n  ],\n  \"url\": \"https://git.dorkbox.com/dorkbox/SystemTray\",\n  \"uuid\": \"" + string + "\",\n  \"version\": " + string2 + "\n}\n";
    }

    protected static String getGnomeVersion() {
        int n;
        String string = OS.DesktopEnv.INSTANCE.getGnomeVersion();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(46);
        if (n2 < (n = string.indexOf(46, n2 + 1))) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static boolean needsUpgrade(String string, File object) {
        object = KotlinUtils.INSTANCE.readText((File)object);
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Extension already installed, checking for upgrade");
        }
        if (string.equals(object)) {
            if (!SystemTray.DEBUG) {
                return false;
            }
            SystemTray.logger.debug("Always upgrading extension in DEBUG mode");
        } else if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Need to upgrade extension");
        }
        return true;
    }
}

