/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItemCheckbox;
import dorkbox.systemTray.ui.gtk.GtkMenuItemSeparator;
import dorkbox.systemTray.ui.gtk.GtkMenuItemStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class GtkMenu
extends GtkBaseMenuItem
implements MenuPeer {
    private final List<GtkBaseMenuItem> menuEntries = new ArrayList<GtkBaseMenuItem>();
    private final GtkMenu parent;
    volatile Pointer _nativeMenu;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private final AtomicBoolean obliterateInProgress = new AtomicBoolean(false);

    GtkMenu() {
        super(null);
        this.parent = null;
    }

    private GtkMenu(GtkMenu gtkMenu) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = gtkMenu;
    }

    GtkMenu getParent() {
        return this.parent;
    }

    protected void onMenuAdded(Pointer pointer) {
    }

    private void deleteMenu(boolean bl) {
        while (true) {
            if (gtkMenu.obliterateInProgress.get()) {
                return;
            }
            if (gtkMenu._nativeMenu != null) {
                int n = gtkMenu.menuEntries.size();
                for (int i = 0; i < n; ++i) {
                    GtkBaseMenuItem gtkBaseMenuItem = gtkMenu.menuEntries.get(i);
                    gtkBaseMenuItem.onDeleteMenu(gtkMenu._nativeMenu);
                }
                Gtk.Gtk2.gtk_widget_destroy(gtkMenu._nativeMenu);
            }
            if (gtkMenu.parent == null || !bl) break;
            bl = true;
            GtkMenu gtkMenu = gtkMenu.parent;
        }
    }

    private void createMenu(boolean bl) {
        GtkBaseMenuItem gtkBaseMenuItem;
        int n;
        if (this.obliterateInProgress.get()) {
            return;
        }
        this._nativeMenu = Gtk.Gtk2.gtk_menu_new();
        if (this.parent != null) {
            Gtk.Gtk2.gtk_menu_item_set_submenu(this._native, this._nativeMenu);
        }
        if (this.parent != null && bl) {
            this.parent.createMenu(true);
        }
        boolean bl2 = false;
        int n2 = this.menuEntries.size();
        for (n = 0; n < n2; ++n) {
            gtkBaseMenuItem = this.menuEntries.get(n);
            bl2 |= gtkBaseMenuItem.hasImage();
        }
        n2 = this.menuEntries.size();
        for (n = 0; n < n2; ++n) {
            gtkBaseMenuItem = this.menuEntries.get(n);
            gtkBaseMenuItem.onCreateMenu(this._nativeMenu, bl2);
            if (!(gtkBaseMenuItem instanceof GtkMenu) || ((GtkMenu)(gtkBaseMenuItem = (GtkMenu)gtkBaseMenuItem)).getParent() == this) continue;
            super.createMenu(bl);
        }
        GtkMenu gtkMenu = this;
        gtkMenu.onMenuAdded(gtkMenu._nativeMenu);
    }

    private void obliterateMenu() {
        if (this._nativeMenu != null && !this.obliterateInProgress.get()) {
            this.obliterateInProgress.set(true);
            ArrayList<GtkBaseMenuItem> arrayList = new ArrayList<GtkBaseMenuItem>(this.menuEntries);
            this.menuEntries.clear();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                GtkBaseMenuItem gtkBaseMenuItem = arrayList.get(i);
                gtkBaseMenuItem.remove();
            }
            arrayList.clear();
            Gtk.Gtk2.gtk_widget_destroy(this._nativeMenu);
            this._nativeMenu = null;
            this.obliterateInProgress.set(false);
        }
    }

    @Override
    public void add(Menu menu, Entry entry, int n) {
        GtkEventDispatch.dispatchAndWait(() -> {
            this.deleteMenu(false);
            GtkBaseMenuItem gtkBaseMenuItem = null;
            if (entry instanceof Menu) {
                gtkBaseMenuItem = new GtkMenu(this);
                this.menuEntries.add(n, gtkBaseMenuItem);
            } else if (entry instanceof Separator) {
                gtkBaseMenuItem = new GtkMenuItemSeparator(this);
                this.menuEntries.add(n, gtkBaseMenuItem);
            } else if (entry instanceof Checkbox) {
                gtkBaseMenuItem = new GtkMenuItemCheckbox(this);
                this.menuEntries.add(n, gtkBaseMenuItem);
            } else if (entry instanceof Status) {
                gtkBaseMenuItem = new GtkMenuItemStatus(this);
                this.menuEntries.add(n, gtkBaseMenuItem);
            } else if (entry instanceof MenuItem) {
                gtkBaseMenuItem = new GtkMenuItem(this);
                this.menuEntries.add(n, gtkBaseMenuItem);
            }
            if (entry instanceof Menu) {
                Menu menu2 = menu;
                ((Menu)entry).bind((MenuPeer)((Object)gtkBaseMenuItem), menu2, menu2.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                Menu menu3 = menu;
                ((Separator)entry).bind((GtkMenuItemSeparator)gtkBaseMenuItem, menu3, menu3.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                Menu menu4 = menu;
                ((Checkbox)entry).bind((GtkMenuItemCheckbox)gtkBaseMenuItem, menu4, menu4.getImageResizeUtil());
            } else if (entry instanceof Status) {
                Menu menu5 = menu;
                ((Status)entry).bind((GtkMenuItemStatus)gtkBaseMenuItem, menu5, menu5.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                Menu menu6 = menu;
                ((MenuItem)entry).bind((GtkMenuItem)gtkBaseMenuItem, menu6, menu6.getImageResizeUtil());
            }
            this.createMenu(false);
            if (this.parent == null) {
                Gtk.Gtk2.gtk_widget_show_all(this._nativeMenu);
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(() -> {
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            if (menuItem.getImage() != null) {
                this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.image);
                Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
            }
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_sensitive(this._native, menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem object) {
        int n;
        String string;
        object = this.mnemonicKey != '\u0000' ? ((string = ((MenuItem)object).getText()) != null ? ((n = string.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? string.substring(0, n) + "_" + string.substring(n) : ((MenuItem)object).getText()) : null) : ((MenuItem)object).getText();
        GtkEventDispatch.dispatch(() -> this.lambda$setText$3((String)object));
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char c = menuItem.getShortcut();
        this.mnemonicKey = c != '\u0000' ? Character.toLowerCase(c) : (char)'\u0000';
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_tooltip_text(this._native, menuItem.getTooltip()));
    }

    public void remove(GtkBaseMenuItem gtkBaseMenuItem) {
        this.menuEntries.remove(gtkBaseMenuItem);
        this.deleteMenu(true);
        this.createMenu(true);
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(() -> {
            GtkMenu gtkMenu = this.getParent();
            if (gtkMenu != null) {
                gtkMenu.menuEntries.remove(this);
            }
            this.obliterateMenu();
            if (gtkMenu != null) {
                Gtk.Gtk2.gtk_menu_item_set_submenu(this._native, null);
                gtkMenu.deleteMenu(true);
                gtkMenu.createMenu(true);
            }
        });
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    private /* synthetic */ void lambda$setText$3(String string) {
        Gtk.Gtk2.gtk_menu_item_set_label(this._native, string);
        Gtk.Gtk2.gtk_widget_show_all(this._native);
    }
}

