/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.Gtk2;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.jna.linux.structs.GtkRequisition;
import dorkbox.jna.linux.structs.PangoRectangle;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.KotlinUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.LoggerFactory;

public class GtkTheme {
    public static volatile int TRAY_IMAGE_SIZE_FALLBACK = OS.INSTANCE.getInt(GtkTheme.class.getSimpleName() + ".TRAY_IMAGE_SIZE_FALLBACK", 24);
    public static volatile int TRAY_MENU_IMAGE_SIZE_FALLBACK = OS.INSTANCE.getInt(GtkTheme.class.getSimpleName() + ".TRAY_MENU_IMAGE_SIZE_FALLBACK", 16);

    public static Rectangle getPixelTextHeight(String object) {
        Pointer pointer = null;
        Pointer pointer2 = null;
        try {
            pointer = Gtk2.Gtk2.gtk_menu_new();
            pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_with_mnemonic((String)object);
            Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
            Gtk2.Gtk2.gtk_widget_realize(pointer);
            Gtk2.Gtk2.gtk_widget_realize(pointer2);
            Gtk2.Gtk2.gtk_widget_show_all(pointer);
            object = Gtk2.Gtk2.gtk_bin_get_child(pointer2);
            object = Gtk2.Gtk2.gtk_label_get_layout((Pointer)object);
            PangoRectangle pangoRectangle = new PangoRectangle();
            Gtk2.Gtk2.pango_layout_get_pixel_extents((Pointer)object, pangoRectangle.getPointer(), null);
            pangoRectangle.read();
            object = new Rectangle(pangoRectangle.width, pangoRectangle.height);
        }
        catch (Throwable throwable) {
            Gtk2.Gtk2.gtk_widget_destroy(pointer2);
            Gtk2.Gtk2.gtk_widget_destroy(pointer);
            throw throwable;
        }
        Gtk2.Gtk2.gtk_widget_destroy(pointer2);
        Gtk2.Gtk2.gtk_widget_destroy(pointer);
        return object;
    }

    public static int getMenuEntryImageSize() {
        AtomicReference atomicReference = new AtomicReference();
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = Gtk2.Gtk2.gtk_offscreen_window_new();
            Pointer pointer2 = null;
            try {
                pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_from_stock("gtk-paste", null);
                Gtk2.Gtk2.gtk_image_menu_item_set_always_show_image(pointer2, true);
                Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
                Gtk2.Gtk2.gtk_widget_realize(pointer);
                Gtk2.Gtk2.gtk_widget_realize(pointer2);
                Gtk2.Gtk2.gtk_widget_show_all(pointer2);
                PointerByReference pointerByReference = new PointerByReference();
                GObject.g_object_get((Pointer)pointer2, (String)"image", (Pointer)pointerByReference.getPointer(), null);
                pointerByReference = pointerByReference.getValue();
                GtkRequisition gtkRequisition = new GtkRequisition();
                Gtk2.Gtk2.gtk_widget_size_request((Pointer)pointerByReference, gtkRequisition.getPointer());
                gtkRequisition.read();
                atomicReference.set(gtkRequisition.height);
                if (pointer2 == null) return;
            }
            catch (Throwable throwable) {
                if (pointer2 == null) throw throwable;
                Gtk2.Gtk2.gtk_widget_destroy(pointer2);
                Gtk2.Gtk2.gtk_widget_destroy(pointer);
                throw throwable;
            }
            Gtk2.Gtk2.gtk_widget_destroy(pointer2);
            Gtk2.Gtk2.gtk_widget_destroy(pointer);
        });
        int n = (Integer)atomicReference.get();
        if (n > 0) {
            return n;
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray menu image size. Using fallback: " + TRAY_MENU_IMAGE_SIZE_FALLBACK);
        return TRAY_MENU_IMAGE_SIZE_FALLBACK;
    }

    public static int getScreenDPI() {
        int n;
        Object object;
        AtomicInteger atomicInteger = new AtomicInteger();
        atomicInteger.set(0);
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = Gtk2.Gtk2.gdk_screen_get_default();
            if (pointer != null) {
                atomicInteger.set((int)Gtk2.Gtk2.gdk_screen_get_resolution(pointer));
            }
        });
        if (atomicInteger.get() <= 0 && (object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI")) instanceof Integer && (n = ((Integer)object).intValue()) > 1024) {
            atomicInteger.set(n /= 1024);
        }
        if (atomicInteger.get() < 50) {
            atomicInteger.set(96);
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("screen DPI: " + atomicInteger.get());
        }
        return atomicInteger.get();
    }

    public static double getScreenScale() {
        AtomicReference<Double> atomicReference;
        block22: {
            Object object;
            atomicReference = new AtomicReference<Double>();
            atomicReference.set(0.0);
            if (Gtk2.isGtk3) {
                GtkEventDispatch.dispatchAndWait(() -> {
                    Pointer pointer = Gtk2.Gtk2.gdk_get_default_root_window();
                    if (pointer != null) {
                        double d = Gtk.Gtk3.gdk_window_get_scale_factor(pointer);
                        atomicReference.set(d);
                    }
                });
            }
            if ((Double)atomicReference.get() == 0.0 && (object = System.getenv("QT_AUTO_SCREEN_SCALE_FACTOR")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object));
                }
                catch (Exception exception) {}
            }
            if ((Double)atomicReference.get() == 0.0 && (object = System.getenv("QT_SCALE_FACTOR")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object));
                }
                catch (Exception exception) {}
            }
            if ((Double)atomicReference.get() == 0.0 && (object = System.getenv("GDK_SCALE")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object));
                }
                catch (Exception exception) {}
            }
            if ((Double)atomicReference.get() == 0.0 && (object = System.getenv("ELM_SCALE")) != null) {
                try {
                    atomicReference.set(Double.parseDouble((String)object));
                }
                catch (Exception exception) {}
            }
            if ((Double)atomicReference.get() == 0.0) {
                try {
                    object = KotlinUtils.INSTANCE.execute("/usr/bin/gsettings", "get", "org.gnome.desktop.interface", "scaling-factor");
                    if (!((String)object).isEmpty() && !((String)object).endsWith("not found") && ((String)object).contains("uint32")) {
                        double d;
                        Object object2 = object;
                        object = ((String)object2).substring(((String)object2).indexOf("uint") + 7);
                        double d2 = Double.parseDouble((String)object);
                        if (d >= 1.0) {
                            atomicReference.set(d2);
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
            if (OS.DesktopEnv.INSTANCE.isKDE()) {
                try {
                    object = new File("/usr/bin/startkde-custom");
                    if (!((File)object).canRead()) break block22;
                    object = KotlinUtils.INSTANCE.readLines((File)object);
                    Iterator<String> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        double d;
                        String string = iterator.next();
                        int n = string.indexOf((String)(object = "export GDK_SCALE="));
                        if (n < 0) continue;
                        object = string.substring(n + ((String)object).length());
                        double d3 = Double.parseDouble((String)object);
                        if (!(d >= 1.0)) continue;
                        atomicReference.set(d3);
                        break;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return (Double)atomicReference.get();
    }

    public static int getIndicatorSize(double d) {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (OS.DesktopEnv.INSTANCE.isKDE()) {
            object3 = new File("/usr/share/plasma/plasmoids/org.kde.plasma.private.systemtray/contents/config/main.xml");
            if (((File)object3).canRead()) {
                object3 = KotlinUtils.INSTANCE.readLines((File)object3);
                n = 0;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    int n2;
                    String string = (String)iterator.next();
                    if (string.contains("<entry name=\"iconSize\" type=\"Int\">")) {
                        n = 1;
                    }
                    object2 = "<default>";
                    if (n == 0 || (n2 = string.indexOf((String)object2)) < 0) continue;
                    object = string.substring(n2 + ((String)object2).length(), string.indexOf("</default>", n2));
                    int n3 = 0;
                    if ((object = KotlinUtils.INSTANCE.toInteger((String)object)) == null) continue;
                    switch ((Integer)object) {
                        case 0: {
                            n3 = 16;
                            break;
                        }
                        case 1: {
                            n3 = 22;
                            break;
                        }
                        case 2: {
                            n3 = 32;
                            break;
                        }
                        case 3: {
                            n3 = 48;
                            break;
                        }
                        case 4: {
                            n3 = 64;
                            break;
                        }
                        case 5: {
                            n3 = 128;
                        }
                    }
                    if (n3 <= 0) continue;
                    return (int)(d * (double)n3);
                }
            }
            if ((object3 = OS.DesktopEnv.INSTANCE.getPlasmaVersionFull()) != null) {
                String[] stringArray = ((String)object3).split("\\.");
                int n4 = Integer.parseInt(stringArray[0]);
                int n5 = Integer.parseInt(stringArray[1]);
                if (n4 < 5 || n4 == 5 && n5 < 5) {
                    return 22;
                }
                return 128;
            }
        }
        object3 = OS.DesktopEnv.INSTANCE.getEnv();
        if (OS.Linux.INSTANCE.isUbuntu() && OS.DesktopEnv.INSTANCE.isUnity((OS.DesktopEnv.Env)object3)) {
            return 22;
        }
        if (object3 == OS.DesktopEnv.Env.XFCE) {
            object3 = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", null);
            String[] stringArray = ((String)object3).split(OS.INSTANCE.getLINE_SEPARATOR());
            object3 = stringArray;
            int n6 = stringArray.length;
            for (int i = 0; i < n6; ++i) {
                String string;
                object2 = object3[i];
                if (!((String)object2).startsWith("/plugins/") || !((String)object2).endsWith("/size-max") || !(string = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", (String)(object = ((String)object2).substring(0, ((String)object2).indexOf("/size-max")))).trim()).equals("systray")) continue;
                object = OS.DesktopEnv.INSTANCE.queryXfce("xfce4-panel", (String)object2).trim();
                try {
                    return Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    LoggerFactory.getLogger(GtkTheme.class).error("Unable to get XFCE notification panel size for channel '{}', property '{}'", new Object[]{"xfce4-panel", object2, exception});
                }
            }
        }
        object3 = new AtomicInteger();
        GtkEventDispatch.dispatchAndWait(() -> GtkTheme.lambda$getIndicatorSize$3((AtomicInteger)object3));
        n = ((AtomicInteger)object3).get();
        if (n != 0) {
            return n;
        }
        LoggerFactory.getLogger(GtkTheme.class).warn("Unable to get tray image size. Using fallback: " + TRAY_IMAGE_SIZE_FALLBACK);
        return TRAY_IMAGE_SIZE_FALLBACK;
    }

    public static Color getTextColor() {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        GtkEventDispatch.dispatchAndWait(() -> {
            Pointer pointer = null;
            Pointer pointer2 = null;
            try {
                pointer = Gtk2.Gtk2.gtk_menu_new();
                pointer2 = Gtk2.Gtk2.gtk_image_menu_item_new_with_mnemonic("a");
                Gtk2.Gtk2.gtk_container_add(pointer, pointer2);
                Gtk2.Gtk2.gtk_widget_realize(pointer);
                Gtk2.Gtk2.gtk_widget_realize(pointer2);
                Gtk2.Gtk2.gtk_widget_show_all(pointer);
                Object object = Gtk2.Gtk2.gtk_rc_get_style(pointer2);
                object.read();
                object = object.fg[0].getColor();
                atomicReference.set(object);
            }
            catch (Throwable throwable) {
                Gtk2.Gtk2.gtk_widget_destroy(pointer2);
                Gtk2.Gtk2.gtk_widget_destroy(pointer);
                throw throwable;
            }
            Gtk2.Gtk2.gtk_widget_destroy(pointer2);
            Gtk2.Gtk2.gtk_widget_destroy(pointer);
        });
        return atomicReference.get();
    }

    private static /* synthetic */ void lambda$getIndicatorSize$3(AtomicInteger atomicInteger) {
        Object object = Gtk2.Gtk2.gdk_screen_get_default();
        String[] stringArray = null;
        if (object != null) {
            stringArray = Gtk2.Gtk2.gtk_settings_get_for_screen((Pointer)object);
        }
        if (stringArray != null) {
            object = new PointerByReference();
            GObject.g_object_get((Pointer)stringArray, (String)"gtk-icon-sizes", (Pointer)object.getPointer(), null);
            object = object.getValue();
            if (object != null) {
                object = object.getString(0L);
                String[] stringArray2 = new String[]{"panel-menu-bar=", "panel=", "gtk-large-toolbar=", "gtk-small-toolbar="};
                stringArray = stringArray2;
                stringArray = stringArray2;
                int cfr_ignored_0 = stringArray2.length;
                for (int i = 0; i < 4; ++i) {
                    Object object2 = stringArray[i];
                    int n = ((String)object).indexOf((String)object2);
                    if (n < 0) continue;
                    object2 = ((String)object).substring(n + ((String)object2).length(), ((String)object).indexOf(",", n));
                    if ((object2 = KotlinUtils.INSTANCE.toInteger((String)object2)) == null) continue;
                    atomicInteger.set((Integer)object2);
                    return;
                }
            }
        }
    }
}

