/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.DecodeSequenceMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonIteratorArrayWrapped;
import kotlinx.serialization.json.internal.JsonIteratorWsSeparated;
import kotlinx.serialization.json.internal.ReaderJsonLexer;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"JsonIterator", "", "T", "mode", "Lkotlinx/serialization/json/DecodeSequenceMode;", "json", "Lkotlinx/serialization/json/Json;", "lexer", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "determineFormat", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "suggested", "tryConsumeStartArray", "", "kotlinx-serialization-json"})
public final class JsonIteratorKt {
    public static final <T> Iterator<T> JsonIterator(DecodeSequenceMode decodeSequenceMode, Json json, ReaderJsonLexer readerJsonLexer, DeserializationStrategy<? extends T> deserializationStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)decodeSequenceMode), (String)"");
        Intrinsics.checkNotNullParameter((Object)json, (String)"");
        Intrinsics.checkNotNullParameter((Object)readerJsonLexer, (String)"");
        Intrinsics.checkNotNullParameter(deserializationStrategy, (String)"");
        switch (WhenMappings.$EnumSwitchMapping$0[JsonIteratorKt.determineFormat(readerJsonLexer, decodeSequenceMode).ordinal()]) {
            case 1: {
                return new JsonIteratorWsSeparated<T>(json, readerJsonLexer, deserializationStrategy);
            }
            case 2: {
                return new JsonIteratorArrayWrapped<T>(json, readerJsonLexer, deserializationStrategy);
            }
            case 3: {
                throw new IllegalStateException("AbstractJsonLexer.determineFormat must be called beforehand.".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final DecodeSequenceMode determineFormat(AbstractJsonLexer object, DecodeSequenceMode object2) {
        switch (WhenMappings.$EnumSwitchMapping$0[object2.ordinal()]) {
            case 1: {
                return DecodeSequenceMode.WHITESPACE_SEPARATED;
            }
            case 2: {
                if (JsonIteratorKt.tryConsumeStartArray((AbstractJsonLexer)object)) {
                    return DecodeSequenceMode.ARRAY_WRAPPED;
                }
                object2 = AbstractJsonLexerKt.tokenDescription((byte)8);
                int n = ((AbstractJsonLexer)object).currentPosition - 1;
                Object object3 = ((AbstractJsonLexer)object).currentPosition == AbstractJsonLexer.access$getSource((AbstractJsonLexer)object).length() || n < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource((AbstractJsonLexer)object).charAt(n));
                AbstractJsonLexer abstractJsonLexer = object;
                object = object3;
                object3 = abstractJsonLexer;
                AbstractJsonLexer.fail$default((AbstractJsonLexer)object3, "Expected " + (String)object2 + ", but had '" + (String)object + "' instead", n, null, 4, null);
                throw new KotlinNothingValueException();
            }
            case 3: {
                if (JsonIteratorKt.tryConsumeStartArray((AbstractJsonLexer)object)) {
                    return DecodeSequenceMode.ARRAY_WRAPPED;
                }
                return DecodeSequenceMode.WHITESPACE_SEPARATED;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean tryConsumeStartArray(AbstractJsonLexer abstractJsonLexer) {
        if (abstractJsonLexer.peekNextToken() == 8) {
            abstractJsonLexer.consumeNextToken((byte)8);
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DecodeSequenceMode.values().length];
            try {
                nArray[DecodeSequenceMode.WHITESPACE_SEPARATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DecodeSequenceMode.ARRAY_WRAPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[DecodeSequenceMode.AUTO_DETECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

