/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.DateUtilsKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b*\b\u0012\u0004\u0012\u00020\u00160\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001f\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lio/ktor/http/content/LastModifiedVersion;", "Lio/ktor/http/content/Version;", "Lio/ktor/util/date/GMTDate;", "lastModified", "<init>", "(Lio/ktor/util/date/GMTDate;)V", "Lio/ktor/http/Headers;", "requestHeaders", "Lio/ktor/http/content/VersionCheckResult;", "check", "(Lio/ktor/http/Headers;)Lio/ktor/http/content/VersionCheckResult;", "", "dates", "", "ifModifiedSince", "(Ljava/util/List;)Z", "ifUnmodifiedSince", "Lio/ktor/http/HeadersBuilder;", "builder", "", "appendHeadersTo", "(Lio/ktor/http/HeadersBuilder;)V", "", "parseDates", "(Ljava/util/List;)Ljava/util/List;", "component1", "()Lio/ktor/util/date/GMTDate;", "copy", "(Lio/ktor/util/date/GMTDate;)Lio/ktor/http/content/LastModifiedVersion;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lio/ktor/util/date/GMTDate;", "getLastModified", "truncatedModificationDate", "ktor-http"})
public final class LastModifiedVersion
implements Version {
    private final GMTDate lastModified;
    private final GMTDate truncatedModificationDate;

    public LastModifiedVersion(GMTDate gMTDate) {
        Intrinsics.checkNotNullParameter((Object)gMTDate, (String)"");
        this.lastModified = gMTDate;
        this.truncatedModificationDate = DateKt.truncateToSeconds((GMTDate)this.lastModified);
    }

    public final GMTDate getLastModified() {
        return this.lastModified;
    }

    @Override
    public final VersionCheckResult check(Headers list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        List list2 = list.getAll(HttpHeaders.INSTANCE.getIfModifiedSince());
        List<GMTDate> list3 = list2 != null ? this.parseDates(list2) : null;
        if (list3 != null && !this.ifModifiedSince(list3)) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        List list4 = list.getAll(HttpHeaders.INSTANCE.getIfUnmodifiedSince());
        list = list4 != null ? this.parseDates(list4) : null;
        if (list != null && !this.ifUnmodifiedSince(list)) {
            return VersionCheckResult.PRECONDITION_FAILED;
        }
        return VersionCheckResult.OK;
    }

    public final boolean ifModifiedSince(List<GMTDate> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        object = (Iterable)object;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (!(this.truncatedModificationDate.compareTo(object2 = (GMTDate)object2) > 0)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean ifUnmodifiedSince(List<GMTDate> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        object = (Iterable)object;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                if (this.truncatedModificationDate.compareTo(object2 = (GMTDate)object2) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void appendHeadersTo(HeadersBuilder headersBuilder) {
        Intrinsics.checkNotNullParameter((Object)((Object)headersBuilder), (String)"");
        headersBuilder.set(HttpHeaders.INSTANCE.getLastModified(), DateUtilsKt.toHttpDate(this.lastModified));
    }

    private final List<GMTDate> parseDates(List<String> object) {
        Object object2;
        object = (Iterable)object;
        Collection collection = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            object2 = (String)e;
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)object2)))) continue;
            collection.add(e);
        }
        object = (List)collection;
        collection = new ArrayList();
        object2 = object.iterator();
        while (object2.hasNext()) {
            Object e = object2.next();
            object = e;
            object = e;
            object = (String)e;
            try {
                object = DateUtilsKt.fromHttpToGmtDate((String)object);
            }
            catch (Throwable throwable) {
                object = null;
            }
            Object object3 = object;
            if (object3 == null) continue;
            object = object3;
            collection.add(object);
        }
        object = (List)collection;
        collection = object;
        if (!((Collection)object).isEmpty()) {
            return object;
        }
        return null;
    }

    public final GMTDate component1() {
        return this.lastModified;
    }

    public final LastModifiedVersion copy(GMTDate gMTDate) {
        Intrinsics.checkNotNullParameter((Object)gMTDate, (String)"");
        return new LastModifiedVersion(gMTDate);
    }

    public static /* synthetic */ LastModifiedVersion copy$default(LastModifiedVersion lastModifiedVersion, GMTDate gMTDate, int n, Object object) {
        if ((n & 1) != 0) {
            gMTDate = lastModifiedVersion.lastModified;
        }
        return lastModifiedVersion.copy(gMTDate);
    }

    public final String toString() {
        return "LastModifiedVersion(lastModified=" + this.lastModified + ')';
    }

    public final int hashCode() {
        return this.lastModified.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LastModifiedVersion)) {
            return false;
        }
        object = (LastModifiedVersion)object;
        return Intrinsics.areEqual((Object)this.lastModified, (Object)((LastModifiedVersion)object).lastModified);
    }
}

