/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.WeakClassLoaderBox;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeModuleData;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u0006H\u0000\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"moduleByClassLoader", "Ljava/util/concurrent/ConcurrentMap;", "Lkotlin/reflect/jvm/internal/WeakClassLoaderBox;", "Ljava/lang/ref/WeakReference;", "Lkotlin/reflect/jvm/internal/impl/descriptors/runtime/components/RuntimeModuleData;", "getOrCreateModule", "Ljava/lang/Class;", "clearModuleByClassLoaderCache", "", "kotlin-reflection"})
public final class ModuleByClassLoaderKt {
    private static final ConcurrentMap<WeakClassLoaderBox, WeakReference<RuntimeModuleData>> moduleByClassLoader = new ConcurrentHashMap();

    public static final RuntimeModuleData getOrCreateModule(Class<?> object) {
        Intrinsics.checkNotNullParameter(object, (String)"");
        object = ReflectClassUtilKt.getSafeClassLoader(object);
        WeakClassLoaderBox weakClassLoaderBox = new WeakClassLoaderBox((ClassLoader)object);
        WeakReference<Object> weakReference = (WeakReference<Object>)moduleByClassLoader.get(weakClassLoaderBox);
        if (weakReference != null) {
            RuntimeModuleData runtimeModuleData = (RuntimeModuleData)weakReference.get();
            if (runtimeModuleData != null) {
                RuntimeModuleData runtimeModuleData2 = runtimeModuleData;
                return runtimeModuleData;
            }
            moduleByClassLoader.remove(weakClassLoaderBox, weakReference);
        }
        object = RuntimeModuleData.Companion.create((ClassLoader)object);
        try {
            while (true) {
                if (moduleByClassLoader.putIfAbsent(weakClassLoaderBox, new WeakReference<Object>(object)) == null) {
                    return object;
                }
                RuntimeModuleData runtimeModuleData = (RuntimeModuleData)weakReference.get();
                if (runtimeModuleData != null) {
                    object = runtimeModuleData;
                    return object;
                }
                moduleByClassLoader.remove(weakClassLoaderBox, weakReference);
            }
        }
        finally {
            weakClassLoaderBox.setTemporaryStrongRef(null);
        }
    }

    public static final void clearModuleByClassLoaderCache() {
        moduleByClassLoader.clear();
    }
}

