/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.Collections;
import java.util.List;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.ClassBasedDeclarationContainer;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Lambda;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.ReflectionFactory;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KMutableProperty2;
import kotlin.reflect.KProperty0;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KProperty2;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.ReflectLambdaKt;
import kotlin.reflect.jvm.internal.CachesKt;
import kotlin.reflect.jvm.internal.EmptyContainerForLocal;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.reflect.jvm.internal.KDeclarationContainerImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KMutableProperty0Impl;
import kotlin.reflect.jvm.internal.KMutableProperty1Impl;
import kotlin.reflect.jvm.internal.KMutableProperty2Impl;
import kotlin.reflect.jvm.internal.KProperty0Impl;
import kotlin.reflect.jvm.internal.KProperty1Impl;
import kotlin.reflect.jvm.internal.KProperty2Impl;
import kotlin.reflect.jvm.internal.ModuleByClassLoaderKt;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.TypeOfImplKt;
import kotlin.reflect.jvm.internal.UtilKt;

public class ReflectionFactoryImpl
extends ReflectionFactory {
    public KClass createKotlinClass(Class clazz) {
        return new KClassImpl(clazz);
    }

    public KClass createKotlinClass(Class clazz, String string) {
        return new KClassImpl(clazz);
    }

    public KDeclarationContainer getOrCreateKotlinPackage(Class clazz, String string) {
        return CachesKt.getOrCreateKotlinPackage(clazz);
    }

    public KClass getOrCreateKotlinClass(Class clazz) {
        return CachesKt.getOrCreateKotlinClass(clazz);
    }

    public KClass getOrCreateKotlinClass(Class clazz, String string) {
        return CachesKt.getOrCreateKotlinClass(clazz);
    }

    public String renderLambdaToString(Lambda lambda) {
        return this.renderLambdaToString((FunctionBase)lambda);
    }

    public String renderLambdaToString(FunctionBase functionBase) {
        KFunctionImpl kFunctionImpl = ReflectLambdaKt.reflect(functionBase);
        if (kFunctionImpl != null && (kFunctionImpl = UtilKt.asKFunctionImpl(kFunctionImpl)) != null) {
            return ReflectionObjectRenderer.INSTANCE.renderLambda(kFunctionImpl.getDescriptor());
        }
        return super.renderLambdaToString(functionBase);
    }

    public KFunction function(FunctionReference functionReference) {
        return new KFunctionImpl(ReflectionFactoryImpl.getOwner((CallableReference)functionReference), functionReference.getName(), functionReference.getSignature(), functionReference.getBoundReceiver());
    }

    public KProperty0 property0(PropertyReference0 propertyReference0) {
        return new KProperty0Impl(ReflectionFactoryImpl.getOwner((CallableReference)propertyReference0), propertyReference0.getName(), propertyReference0.getSignature(), propertyReference0.getBoundReceiver());
    }

    public KMutableProperty0 mutableProperty0(MutablePropertyReference0 mutablePropertyReference0) {
        return new KMutableProperty0Impl(ReflectionFactoryImpl.getOwner((CallableReference)mutablePropertyReference0), mutablePropertyReference0.getName(), mutablePropertyReference0.getSignature(), mutablePropertyReference0.getBoundReceiver());
    }

    public KProperty1 property1(PropertyReference1 propertyReference1) {
        return new KProperty1Impl(ReflectionFactoryImpl.getOwner((CallableReference)propertyReference1), propertyReference1.getName(), propertyReference1.getSignature(), propertyReference1.getBoundReceiver());
    }

    public KMutableProperty1 mutableProperty1(MutablePropertyReference1 mutablePropertyReference1) {
        return new KMutableProperty1Impl(ReflectionFactoryImpl.getOwner((CallableReference)mutablePropertyReference1), mutablePropertyReference1.getName(), mutablePropertyReference1.getSignature(), mutablePropertyReference1.getBoundReceiver());
    }

    public KProperty2 property2(PropertyReference2 propertyReference2) {
        return new KProperty2Impl(ReflectionFactoryImpl.getOwner((CallableReference)propertyReference2), propertyReference2.getName(), propertyReference2.getSignature());
    }

    public KMutableProperty2 mutableProperty2(MutablePropertyReference2 mutablePropertyReference2) {
        return new KMutableProperty2Impl(ReflectionFactoryImpl.getOwner((CallableReference)mutablePropertyReference2), mutablePropertyReference2.getName(), mutablePropertyReference2.getSignature());
    }

    private static KDeclarationContainerImpl getOwner(CallableReference callableReference) {
        if ((callableReference = callableReference.getOwner()) instanceof KDeclarationContainerImpl) {
            return (KDeclarationContainerImpl)callableReference;
        }
        return EmptyContainerForLocal.INSTANCE;
    }

    public KType typeOf(KClassifier kClassifier, List<KTypeProjection> list, boolean bl) {
        if (kClassifier instanceof ClassBasedDeclarationContainer) {
            return CachesKt.getOrCreateKType(((ClassBasedDeclarationContainer)kClassifier).getJClass(), list, bl);
        }
        return KClassifiers.createType(kClassifier, list, bl, Collections.emptyList());
    }

    public KTypeParameter typeParameter(Object object, String string, KVariance object2, boolean bl) {
        if (object instanceof KClass) {
            object2 = ((KClass)object).getTypeParameters();
        } else if (object instanceof KCallable) {
            object2 = ((KCallable)object).getTypeParameters();
        } else {
            throw new IllegalArgumentException("Type parameter container must be a class or a callable: " + object);
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            KTypeParameter kTypeParameter = (KTypeParameter)object2.next();
            if (!kTypeParameter.getName().equals(string)) continue;
            return kTypeParameter;
        }
        throw new IllegalArgumentException("Type parameter " + string + " is not found in container: " + object);
    }

    public void setUpperBounds(KTypeParameter kTypeParameter, List<KType> list) {
    }

    public KType platformType(KType kType, KType kType2) {
        return TypeOfImplKt.createPlatformKType(kType, kType2);
    }

    public KType mutableCollectionType(KType kType) {
        return TypeOfImplKt.createMutableCollectionKType(kType);
    }

    public KType nothingType(KType kType) {
        return TypeOfImplKt.createNothingType(kType);
    }

    public static void clearCaches() {
        CachesKt.clearCaches();
        ModuleByClassLoaderKt.clearModuleByClassLoaderCache();
    }
}

