/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Method;
import kotlin.jvm.internal.Intrinsics;

final class Java16SealedRecordLoader {
    public static final Java16SealedRecordLoader INSTANCE = new Java16SealedRecordLoader();
    private static Cache _cache;

    private Java16SealedRecordLoader() {
    }

    private final Cache buildCache() {
        Object object = Class.class;
        try {
            object = new Cache(((Class)object).getMethod("isSealed", new Class[0]), ((Class)object).getMethod("getPermittedSubclasses", new Class[0]), ((Class)object).getMethod("isRecord", new Class[0]), ((Class)object).getMethod("getRecordComponents", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new Cache(null, null, null, null);
        }
        return object;
    }

    private final Cache initCache() {
        Cache cache = _cache;
        if (cache == null) {
            _cache = cache = this.buildCache();
        }
        return cache;
    }

    public final Boolean loadIsSealed(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Object object = this.initCache();
        Method method = ((Cache)object).isSealed();
        if (method == null) {
            return null;
        }
        object = method;
        Object object2 = method.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object2);
        return (Boolean)object2;
    }

    public final Class<?>[] loadGetPermittedSubclasses(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Object object = this.initCache();
        Method method = ((Cache)object).getGetPermittedSubclasses();
        if (method == null) {
            return null;
        }
        object = method;
        Object object2 = method.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object2);
        return (Class[])object2;
    }

    public final Boolean loadIsRecord(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Object object = this.initCache();
        Method method = ((Cache)object).isRecord();
        if (method == null) {
            return null;
        }
        object = method;
        Object object2 = method.invoke(clazz, new Object[0]);
        Intrinsics.checkNotNull((Object)object2);
        return (Boolean)object2;
    }

    public final Object[] loadGetRecordComponents(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Object object = this.initCache();
        Method method = ((Cache)object).getGetRecordComponents();
        if (method == null) {
            return null;
        }
        object = method;
        return (Object[])method.invoke(clazz, new Object[0]);
    }

    public static final class Cache {
        private final Method isSealed;
        private final Method getPermittedSubclasses;
        private final Method isRecord;
        private final Method getRecordComponents;

        public Cache(Method method, Method method2, Method method3, Method method4) {
            this.isSealed = method;
            this.getPermittedSubclasses = method2;
            this.isRecord = method3;
            this.getRecordComponents = method4;
        }

        public final Method isSealed() {
            return this.isSealed;
        }

        public final Method getGetPermittedSubclasses() {
            return this.getPermittedSubclasses;
        }

        public final Method isRecord() {
            return this.isRecord;
        }

        public final Method getGetRecordComponents() {
            return this.getRecordComponents;
        }
    }
}

