/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.InputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.BoundedByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedInputStream {
    private final byte[] buffer;
    private final boolean bufferIsImmutable;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private boolean enableAliasing = false;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private RefillCallback refillCallback = null;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return new CodedInputStream(inputStream);
    }

    static CodedInputStream newInstance(LiteralByteString literalByteString) {
        CodedInputStream codedInputStream = new CodedInputStream(literalByteString);
        try {
            codedInputStream.pushLimit(((ByteString)literalByteString).size());
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return codedInputStream;
    }

    public final int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    public final void checkLastTagWas(int n) {
        if (this.lastTag != n) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public final boolean skipField(int n, CodedOutputStream codedOutputStream) {
        switch (WireFormat.getTagWireType(n)) {
            case 0: {
                long l = this.readInt64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeUInt64NoTag(l);
                return true;
            }
            case 1: {
                long l = this.readRawLittleEndian64();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed64NoTag(l);
                return true;
            }
            case 2: {
                ByteString byteString = this.readBytes();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeBytesNoTag(byteString);
                return true;
            }
            case 3: {
                codedOutputStream.writeRawVarint32(n);
                this.skipMessage(codedOutputStream);
                int n2 = WireFormat.makeTag(WireFormat.getTagFieldNumber(n), 4);
                this.checkLastTagWas(n2);
                codedOutputStream.writeRawVarint32(n2);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                int n3 = this.readRawLittleEndian32();
                codedOutputStream.writeRawVarint32(n);
                codedOutputStream.writeFixed32NoTag(n3);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public final void skipMessage(CodedOutputStream codedOutputStream) {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n, codedOutputStream)) {
        }
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public final long readUInt64() {
        return this.readRawVarint64();
    }

    public final long readInt64() {
        return this.readRawVarint64();
    }

    public final int readInt32() {
        return this.readRawVarint32();
    }

    public final long readFixed64() {
        return this.readRawLittleEndian64();
    }

    public final int readFixed32() {
        return this.readRawLittleEndian32();
    }

    public final boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    public final String readString() {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.bufferPos && n > 0) {
            String string = new String(this.buffer, this.bufferPos, n, "UTF-8");
            this.bufferPos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        return new String(this.readRawBytesSlowPath(n), "UTF-8");
    }

    public final String readStringRequireUtf8() {
        byte[] byArray;
        int n;
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - (n = this.bufferPos) && n2 > 0) {
            byArray = this.buffer;
            this.bufferPos = n + n2;
        } else {
            if (n2 == 0) {
                return "";
            }
            byArray = this.readRawBytesSlowPath(n2);
            n = 0;
        }
        int n3 = n;
        if (!Utf8.isValidUtf8(byArray, n3, n3 + n2)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        return new String(byArray, n, n2, "UTF-8");
    }

    public final void readGroup(int n, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n, 4));
        --this.recursionDepth;
    }

    public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        n = this.pushLimit(n);
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n);
    }

    public final <T extends MessageLite> T readMessage(Parser<T> object, ExtensionRegistryLite extensionRegistryLite) {
        int n = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        n = this.pushLimit(n);
        ++this.recursionDepth;
        object = (MessageLite)object.parsePartialFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n);
        return (T)object;
    }

    public final ByteString readBytes() {
        int n = this.readRawVarint32();
        if (n <= this.bufferSize - this.bufferPos && n > 0) {
            ByteString byteString = this.bufferIsImmutable && this.enableAliasing ? new BoundedByteString(this.buffer, this.bufferPos, n) : ByteString.copyFrom(this.buffer, this.bufferPos, n);
            this.bufferPos += n;
            return byteString;
        }
        if (n == 0) {
            return ByteString.EMPTY;
        }
        return new LiteralByteString(this.readRawBytesSlowPath(n));
    }

    public final int readUInt32() {
        return this.readRawVarint32();
    }

    public final int readEnum() {
        return this.readRawVarint32();
    }

    public final int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    public final long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    public final int readSInt32() {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public final long readSInt64() {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public final int readRawVarint32() {
        block4: {
            int n;
            int n2;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n2 = this.bufferPos;
                            if (this.bufferSize == n2) break block4;
                            byArray = this.buffer;
                            if ((n = this.buffer[n2++]) >= 0) {
                                this.bufferPos = n2;
                                return n;
                            }
                            if (this.bufferSize - n2 < 9) break block4;
                            if ((long)(n ^= byArray[n2++] << 7) >= 0L) break block5;
                            n = (int)((long)n ^ 0xFFFFFFFFFFFFFF80L);
                            break block6;
                        }
                        if ((long)(n ^= byArray[n2++] << 14) < 0L) break block7;
                        n = (int)((long)n ^ 0x3F80L);
                        break block6;
                    }
                    if ((long)(n ^= byArray[n2++] << 21) >= 0L) break block8;
                    n = (int)((long)n ^ 0xFFFFFFFFFFE03F80L);
                    break block6;
                }
                byte by = byArray[n2++];
                n ^= by << 28;
                n = (int)((long)n ^ 0xFE03F80L);
                if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
            }
            this.bufferPos = n2;
            return n;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    public static int readRawVarint32(int n, InputStream inputStream) {
        int n2;
        int n3;
        if ((n & 0x80) == 0) {
            return n;
        }
        n &= 0x7F;
        for (n3 = 7; n3 < 32; n3 += 7) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n |= (n2 & 0x7F) << n3;
            if ((n2 & 0x80) != 0) continue;
            return n;
        }
        while (n3 < 64) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 & 0x80) == 0) {
                return n;
            }
            n3 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public final long readRawVarint64() {
        block4: {
            long l;
            int n;
            block6: {
                byte[] byArray;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            byte by;
                                            n = this.bufferPos;
                                            if (this.bufferSize == n) break block4;
                                            byArray = this.buffer;
                                            if ((by = this.buffer[n++]) >= 0) {
                                                this.bufferPos = n;
                                                return by;
                                            }
                                            if (this.bufferSize - n < 9) break block4;
                                            if ((l = (long)(by ^ byArray[n++] << 7)) >= 0L) break block5;
                                            l ^= 0xFFFFFFFFFFFFFF80L;
                                            break block6;
                                        }
                                        if ((l ^= (long)(byArray[n++] << 14)) < 0L) break block7;
                                        l ^= 0x3F80L;
                                        break block6;
                                    }
                                    if ((l ^= (long)(byArray[n++] << 21)) >= 0L) break block8;
                                    l ^= 0xFFFFFFFFFFE03F80L;
                                    break block6;
                                }
                                if ((l ^= (long)byArray[n++] << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                l ^= (long)byArray[n++] << 56;
                if ((l ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
            }
            this.bufferPos = n;
            return l;
        }
        return this.readRawVarint64SlowPath();
    }

    final long readRawVarint64SlowPath() {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public final int readRawLittleEndian32() {
        int n = this.bufferPos;
        if (this.bufferSize - n < 4) {
            this.refillBuffer(4);
            n = this.bufferPos;
        }
        byte[] byArray = this.buffer;
        this.bufferPos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public final long readRawLittleEndian64() {
        int n = this.bufferPos;
        if (this.bufferSize - n < 8) {
            this.refillBuffer(8);
            n = this.bufferPos;
        }
        byte[] byArray = this.buffer;
        this.bufferPos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    private CodedInputStream(InputStream inputStream) {
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        this.input = inputStream;
        this.bufferIsImmutable = false;
    }

    private CodedInputStream(LiteralByteString literalByteString) {
        this.buffer = literalByteString.bytes;
        this.bufferPos = literalByteString.getOffsetIntoBytes();
        this.bufferSize = this.bufferPos + ((ByteString)literalByteString).size();
        this.totalBytesRetired = -this.bufferPos;
        this.input = null;
        this.bufferIsImmutable = true;
    }

    public final int pushLimit(int n) {
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n2 = this.currentLimit;
        if ((n += this.totalBytesRetired + this.bufferPos) > n2) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
        return n2;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int n = this.totalBytesRetired + this.bufferSize;
        if (n > this.currentLimit) {
            this.bufferSizeAfterLimit = n - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
            return;
        }
        this.bufferSizeAfterLimit = 0;
    }

    public final void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    public final int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - n;
    }

    public final boolean isAtEnd() {
        return this.bufferPos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    private void ensureAvailable(int n) {
        if (this.bufferSize - this.bufferPos < n) {
            this.refillBuffer(n);
        }
    }

    private void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }

    private boolean tryRefillBuffer(int n) {
        while (true) {
            if (this.bufferPos + n <= this.bufferSize) {
                throw new IllegalStateException(new StringBuilder(77).append("refillBuffer() called when ").append(n).append(" bytes were already available in buffer").toString());
            }
            if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
                return false;
            }
            if (this.refillCallback != null) {
                this.refillCallback.onRefill();
            }
            if (this.input == null) break;
            int n2 = this.bufferPos;
            if (n2 > 0) {
                if (this.bufferSize > n2) {
                    System.arraycopy(this.buffer, n2, this.buffer, 0, this.bufferSize - n2);
                }
                this.totalBytesRetired += n2;
                this.bufferSize -= n2;
                this.bufferPos = 0;
            }
            if ((n2 = this.input.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize)) == 0 || n2 < -1 || n2 > this.buffer.length) {
                throw new IllegalStateException(new StringBuilder(102).append("InputStream#read(byte[]) returned invalid result: ").append(n2).append("\nThe InputStream implementation is buggy.").toString());
            }
            if (n2 <= 0) break;
            this.bufferSize += n2;
            if (this.totalBytesRetired + n - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            this.recomputeBufferSizeAfterLimit();
            if (this.bufferSize < n) continue;
            return true;
        }
        return false;
    }

    public final byte readRawByte() {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(1);
        }
        return this.buffer[this.bufferPos++];
    }

    private byte[] readRawBytesSlowPath(int n) {
        int n2;
        byte[] byArray;
        if (n <= 0) {
            if (n == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
            CodedInputStream codedInputStream = this;
            codedInputStream.skipRawBytes(codedInputStream.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n < 4096) {
            byte[] byArray2 = new byte[n];
            int n3 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, byArray2, 0, n3);
            this.bufferPos = this.bufferSize;
            this.ensureAvailable(n - n3);
            System.arraycopy(this.buffer, 0, byArray2, n3, n - n3);
            this.bufferPos = n - n3;
            return byArray2;
        }
        int n4 = this.bufferPos;
        int n5 = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = n - (n5 - n4); i > 0; i -= byArray.length) {
            int n6;
            byArray = new byte[Math.min(i, 4096)];
            for (n2 = 0; n2 < byArray.length; n2 += n6) {
                n6 = this.input == null ? -1 : this.input.read(byArray, n2, byArray.length - n2);
                if (n6 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n6;
            }
            arrayList.add(byArray);
        }
        byArray = new byte[n];
        n2 = n5 - n4;
        System.arraycopy(this.buffer, n4, byArray, 0, n2);
        for (byte[] byArray3 : arrayList) {
            System.arraycopy(byArray3, 0, byArray, n2, byArray3.length);
            n2 += byArray3.length;
        }
        return byArray;
    }

    public final void skipRawBytes(int n) {
        if (n <= this.bufferSize - this.bufferPos && n >= 0) {
            this.bufferPos += n;
            return;
        }
        this.skipRawBytesSlowPath(n);
    }

    private void skipRawBytesSlowPath(int n) {
        if (n < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
            CodedInputStream codedInputStream = this;
            codedInputStream.skipRawBytes(codedInputStream.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int n2 = this.bufferSize - this.bufferPos;
        this.bufferPos = this.bufferSize;
        this.refillBuffer(1);
        while (n - n2 > this.bufferSize) {
            n2 += this.bufferSize;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(1);
        }
        this.bufferPos = n - n2;
    }

    private static interface RefillCallback {
        public void onRefill();
    }
}

