/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AbstractAnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class AnnotationAndConstantLoaderImpl
extends AbstractAnnotationLoader<AnnotationDescriptor>
implements AnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    private final AnnotationDeserializer deserializer;

    public AnnotationAndConstantLoaderImpl(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses, SerializerExtensionProtocol serializerExtensionProtocol) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"");
        Intrinsics.checkNotNullParameter((Object)serializerExtensionProtocol, (String)"");
        super(serializerExtensionProtocol);
        this.deserializer = new AnnotationDeserializer(moduleDescriptor, notFoundClasses);
    }

    @Override
    public final AnnotationDescriptor loadAnnotation(ProtoBuf.Annotation annotation, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        return this.deserializer.deserializeAnnotation(annotation, nameResolver);
    }

    @Override
    public final ConstantValue<?> loadPropertyConstant(ProtoContainer protoContainer, ProtoBuf.Property generatedMessageLite, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)generatedMessageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ProtoBuf.Annotation.Argument.Value value = ProtoBufUtilKt.getExtensionOrNull(generatedMessageLite, this.getProtocol().getCompileTimeValue());
        if (value == null) {
            return null;
        }
        generatedMessageLite = value;
        return this.deserializer.resolveValue(kotlinType, (ProtoBuf.Annotation.Argument.Value)generatedMessageLite, protoContainer.getNameResolver());
    }

    @Override
    public final ConstantValue<?> loadAnnotationDefaultValue(ProtoContainer protoContainer, ProtoBuf.Property property, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return null;
    }
}

