/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class ErrorUtils {
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    private static final ErrorClassDescriptor errorClass;
    private static final KotlinType errorTypeForLoopInSupertypes;
    private static final KotlinType errorPropertyType;
    private static final PropertyDescriptor errorProperty;
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorScopeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return ErrorUtils.createErrorScope(errorScopeKind, false, Arrays.copyOf(stringArray, stringArray.length));
    }

    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind errorScopeKind, boolean bl, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorScopeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        if (bl) {
            return new ThrowingScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length));
        }
        return new ErrorScope(errorScopeKind, Arrays.copyOf(stringArray, stringArray.length));
    }

    @JvmStatic
    public static final ErrorType createErrorType(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return INSTANCE.createErrorTypeWithArguments(errorTypeKind, (List<? extends TypeProjection>)CollectionsKt.emptyList(), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorType(ErrorTypeKind errorTypeKind, TypeConstructor typeConstructor2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.createErrorTypeWithArguments(errorTypeKind, (List<? extends TypeProjection>)CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return this.createErrorTypeWithArguments(errorTypeKind, list, this.createErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length)), Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, TypeConstructor typeConstructor2, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = typeConstructor2.toString();
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray3), errorTypeKind, list, false, Arrays.copyOf(stringArray, stringArray.length));
    }

    public final ErrorTypeConstructor createErrorTypeConstructor(ErrorTypeKind errorTypeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        return new ErrorTypeConstructor(errorTypeKind, Arrays.copyOf(stringArray, stringArray.length));
    }

    @JvmStatic
    public static final boolean isError(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor != null && (INSTANCE.isErrorClass(declarationDescriptor) || INSTANCE.isErrorClass(declarationDescriptor.getContainingDeclaration()) || declarationDescriptor == errorModule);
    }

    private final boolean isErrorClass(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(KotlinType object) {
        if (object == null) {
            return false;
        }
        return (object = ((KotlinType)object).getConstructor()) instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)object).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    public final String unresolvedTypeAsItIs(KotlinType object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl = TypeUtilsKt.isUnresolvedType((KotlinType)object);
        if (_Assertions.ENABLED && !bl) {
            object = "Assertion failed";
            throw new AssertionError(object);
        }
        TypeConstructor typeConstructor2 = ((KotlinType)object).getConstructor();
        Intrinsics.checkNotNull((Object)typeConstructor2);
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "unknown class";
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        Name name = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf((Object)errorProperty);
    }
}

