/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class FlatPropertiesLaf
extends FlatLaf {
    private final String name;
    private final String baseTheme;
    private final boolean dark;
    private final Properties properties;

    public FlatPropertiesLaf(String string, File file) {
        this(string, new FileInputStream(file));
    }

    public FlatPropertiesLaf(String string, InputStream inputStream) {
        this(string, FlatPropertiesLaf.loadProperties(inputStream));
    }

    private static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return properties;
    }

    public FlatPropertiesLaf(String string, Properties properties) {
        this.name = string;
        this.properties = properties;
        this.baseTheme = properties.getProperty("@baseTheme", "light");
        this.dark = "dark".equalsIgnoreCase(this.baseTheme) || "darcula".equalsIgnoreCase(this.baseTheme);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public boolean isDark() {
        return this.dark;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected ArrayList<Class<?>> getLafClassesForDefaultsLoading() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(FlatLaf.class);
        switch (this.baseTheme.toLowerCase(Locale.ENGLISH)) {
            default: {
                arrayList.add(FlatLightLaf.class);
                break;
            }
            case "dark": {
                arrayList.add(FlatDarkLaf.class);
                break;
            }
            case "intellij": {
                arrayList.add(FlatLightLaf.class);
                arrayList.add(FlatIntelliJLaf.class);
                break;
            }
            case "darcula": {
                arrayList.add(FlatDarkLaf.class);
                arrayList.add(FlatDarculaLaf.class);
            }
        }
        return arrayList;
    }

    @Override
    protected Properties getAdditionalDefaults() {
        return this.properties;
    }
}

