/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class FlatPopupMenuUI
extends BasicPopupMenuUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Color scrollArrowColor;
    @FlatStylingSupport.Styleable
    protected Color hoverScrollArrowBackground;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatPopupMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.arrowType = UIManager.getString("Component.arrowType");
        this.scrollArrowColor = UIManager.getColor("PopupMenu.scrollArrowColor");
        this.hoverScrollArrowBackground = UIManager.getColor("PopupMenu.hoverScrollArrowBackground");
        LayoutManager layoutManager = this.popupMenu.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.popupMenu.setLayout(new FlatPopupMenuLayout(this.popupMenu, 1));
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.scrollArrowColor = null;
        this.hoverScrollArrowBackground = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.popupMenu, this::installStyle, null);
        this.popupMenu.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            FlatPopupMenuUI flatPopupMenuUI = this;
            flatPopupMenuUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatPopupMenuUI.popupMenu, "PopupMenu"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.popupMenu, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatPopupMenuUI flatPopupMenuUI = this;
        return FlatStylingSupport.getAnnotatedStyleableInfos(flatPopupMenuUI, flatPopupMenuUI.popupMenu.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        FlatPopupMenuUI flatPopupMenuUI = this;
        return FlatStylingSupport.getAnnotatedStyleableValue(flatPopupMenuUI, flatPopupMenuUI.popupMenu.getBorder(), string);
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        Object object = jPopupMenu.getPreferredSize();
        Rectangle rectangle = this.getScreenBoundsAt(n, n2);
        if (n + ((Dimension)object).width > rectangle.x + rectangle.width) {
            n = rectangle.x + rectangle.width - ((Dimension)object).width;
        }
        if (n2 + ((Dimension)object).height > rectangle.y + rectangle.height) {
            n2 = rectangle.y + rectangle.height - ((Dimension)object).height;
        }
        if (n < rectangle.x) {
            n = rectangle.x;
        }
        if (n2 < rectangle.y) {
            n2 = rectangle.y;
        }
        if (jPopupMenu instanceof BasicComboPopup || jPopupMenu.getComponentCount() > 0 && jPopupMenu.getComponent(0) instanceof JScrollPane) {
            return super.getPopup(jPopupMenu, n, n2);
        }
        if (((Dimension)object).height <= rectangle.height) {
            return super.getPopup(jPopupMenu, n, n2);
        }
        FlatPopupScroller flatPopupScroller = new FlatPopupScroller(jPopupMenu);
        flatPopupScroller.setPreferredSize(new Dimension(((Dimension)object).width, rectangle.height));
        object = PopupFactory.getSharedInstance();
        return ((PopupFactory)object).getPopup(jPopupMenu.getInvoker(), flatPopupScroller, n, n2);
    }

    private Rectangle getScreenBoundsAt(int n, int n2) {
        GraphicsConfiguration object = null;
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration;
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration = graphicsDevice.getDefaultConfiguration()).getBounds().contains(n, n2)) continue;
            object = graphicsConfiguration;
            break;
        }
        if (object == null && this.popupMenu.getInvoker() != null) {
            object = this.popupMenu.getInvoker().getGraphicsConfiguration();
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = object != null ? object.getBounds() : new Rectangle(toolkit.getScreenSize());
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(object);
        return FlatUIUtils.subtractInsets(rectangle, insets);
    }

    private class FlatPopupScroller
    extends JPanel
    implements MouseWheelListener,
    MenuKeyListener,
    PopupMenuListener {
        private final JPopupMenu popup;
        private final JScrollPane scrollPane;
        private final JButton scrollUpButton;
        private final JButton scrollDownButton;
        private int unitIncrement;

        FlatPopupScroller(JPopupMenu jPopupMenu) {
            super(new BorderLayout());
            this.popup = jPopupMenu;
            FlatPopupMenuUI.this = new JPanel(new BorderLayout());
            ((Container)FlatPopupMenuUI.this).add((Component)jPopupMenu, "Center");
            this.scrollPane = new JScrollPane((Component)FlatPopupMenuUI.this, 21, 31);
            this.scrollPane.setBorder(null);
            this.scrollUpButton = new ArrowButton(1);
            this.scrollDownButton = new ArrowButton(5);
            FlatPopupScroller flatPopupScroller = this;
            flatPopupScroller.add((Component)flatPopupScroller.scrollPane, "Center");
            FlatPopupScroller flatPopupScroller2 = this;
            flatPopupScroller2.add((Component)flatPopupScroller2.scrollUpButton, "North");
            FlatPopupScroller flatPopupScroller3 = this;
            flatPopupScroller3.add((Component)flatPopupScroller3.scrollDownButton, "South");
            this.setBackground(jPopupMenu.getBackground());
            this.setBorder(jPopupMenu.getBorder());
            jPopupMenu.setBorder(null);
            jPopupMenu.addPopupMenuListener(this);
            jPopupMenu.addMouseWheelListener(this);
            jPopupMenu.addMenuKeyListener(this);
            this.updateArrowButtons();
            this.putClientProperty("Popup.borderCornerRadius", UIManager.getInt("PopupMenu.borderCornerRadius"));
        }

        void scroll(int n) {
            if (this.unitIncrement == 0) {
                this.unitIncrement = new JMenuItem((String)"X").getPreferredSize().height;
            }
            JViewport jViewport = this.scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            n = (n = point.y + this.unitIncrement * n) < 0 ? 0 : Math.min(n, jViewport.getViewSize().height - jViewport.getExtentSize().height);
            jViewport.setViewPosition(new Point(point.x, n));
            this.updateArrowButtons();
        }

        void updateArrowButtons() {
            JViewport jViewport = this.scrollPane.getViewport();
            Point point = jViewport.getViewPosition();
            this.scrollUpButton.setVisible(point.y > 0);
            this.scrollDownButton.setVisible(point.y < jViewport.getViewSize().height - jViewport.getExtentSize().height);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.popup.setBorder(this.getBorder());
            this.popup.removePopupMenuListener(this);
            this.popup.removeMouseWheelListener(this);
            this.popup.removeMenuKeyListener(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Object object = SwingUtilities.convertPoint((Component)mouseWheelEvent.getSource(), mouseWheelEvent.getPoint(), this);
            this.scroll(mouseWheelEvent.getUnitsToScroll());
            object = SwingUtilities.getDeepestComponentAt(this, ((Point)object).x, ((Point)object).y);
            if (object instanceof JMenuItem && (object = ((JMenuItem)object).getUI()) instanceof BasicMenuItemUI) {
                MenuSelectionManager.defaultManager().setSelectedPath(((BasicMenuItemUI)object).getPath());
            }
            mouseWheelEvent.consume();
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            EventQueue.invokeLater(() -> {
                if (!this.isDisplayable()) {
                    return;
                }
                Object object = MenuSelectionManager.defaultManager().getSelectedPath();
                if (((MenuElement[])object).length == 0) {
                    return;
                }
                object = object[((MenuElement[])object).length - 1].getComponent();
                JViewport jViewport = this.scrollPane.getViewport();
                Point point = SwingUtilities.convertPoint((Component)object, 0, 0, jViewport);
                jViewport.scrollRectToVisible(new Rectangle(point, ((Component)object).getSize()));
                boolean bl = this.scrollUpButton.isVisible();
                this.updateArrowButtons();
                if (!bl && this.scrollUpButton.isVisible()) {
                    Point point2 = jViewport.getViewPosition();
                    int n = point2.y + this.scrollUpButton.getPreferredSize().height;
                    jViewport.setViewPosition(new Point(point2.x, n));
                }
            });
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private class ArrowButton
        extends FlatArrowButton
        implements ActionListener,
        MouseListener {
            private Timer timer;

            ArrowButton(int n) {
                super(n, FlatPopupMenuUI.this.arrowType, FlatPopupMenuUI.this.scrollArrowColor, null, null, FlatPopupMenuUI.this.hoverScrollArrowBackground, null, null);
                ArrowButton arrowButton = this;
                arrowButton.addMouseListener(arrowButton);
            }

            @Override
            public void paint(Graphics graphics) {
                graphics.setColor(FlatPopupScroller.this.popup.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paint(graphics);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (this.timer == null) {
                    this.timer = new Timer(50, this);
                }
                this.timer.start();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (this.timer != null) {
                    this.timer.stop();
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.timer != null && !this.isDisplayable()) {
                    this.timer.stop();
                    return;
                }
                FlatPopupScroller.this.scroll(this.direction == 1 ? -1 : 1);
            }
        }
    }

    protected static class FlatPopupMenuLayout
    extends DefaultMenuLayout {
        public FlatPopupMenuLayout(Container container, int n) {
            super(container, n);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            FlatMenuItemRenderer.clearClientProperties(container);
            return super.preferredLayoutSize(container);
        }
    }
}

