/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class FlatScrollPaneBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("ScrollPane.arc");
    private boolean isArcStyled;
    private final int listArc = FlatUIUtils.getUIInt("ScrollPane.List.arc", -1);
    private final int tableArc = FlatUIUtils.getUIInt("ScrollPane.Table.arc", -1);
    private final int textComponentArc = FlatUIUtils.getUIInt("ScrollPane.TextComponent.arc", -1);
    private final int treeArc = FlatUIUtils.getUIInt("ScrollPane.Tree.arc", -1);

    @Override
    public Object applyStyleProperty(String string, Object object) {
        object = super.applyStyleProperty(string, object);
        if ("arc".equals(string)) {
            this.isArcStyled = true;
        }
        return object;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets = super.getBorderInsets(component, insets);
        int n = this.getLeftRightPadding(component);
        if (n > 0) {
            insets.left += n;
            insets.right += n;
        }
        return insets;
    }

    @Override
    protected int getArc(Component component) {
        if (this.isCellEditor(component)) {
            return 0;
        }
        if (this.isArcStyled) {
            return this.arc;
        }
        if (component instanceof JScrollPane) {
            component = FlatScrollPaneUI.getView((JScrollPane)component);
            if (this.listArc >= 0 && component instanceof JList) {
                return this.listArc;
            }
            if (this.tableArc >= 0 && component instanceof JTable) {
                return this.tableArc;
            }
            if (this.textComponentArc >= 0 && component instanceof JTextComponent) {
                return this.textComponentArc;
            }
            if (this.treeArc >= 0 && component instanceof JTree) {
                return this.treeArc;
            }
        }
        return this.arc;
    }

    public int getLeftRightPadding(Component component) {
        int n = this.getArc(component);
        if (n > 0) {
            return Math.max(Math.round(UIScale.scale(((float)n / 2.0f - (float)this.getLineWidth(component)) * 0.9f)), 0);
        }
        return 0;
    }
}

