/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.ArrayList;
import java.util.List;
import org.e.a.b.d;
import org.e.a.e;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;

public class Bookmarks
implements PrivateData {
    public static final String NAMESPACE = "storage:bookmarks";
    public static final String ELEMENT = "storage";
    private final List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private final List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement(ELEMENT).xmlnsAttribute(NAMESPACE).rightAngleBracket();
        for (BookmarkedURL sharedBookmark : this.getBookmarkedURLS()) {
            if (sharedBookmark.isShared()) continue;
            xmlStringBuilder.halfOpenElement("url").attribute("name", sharedBookmark.getName()).attribute("url", sharedBookmark.getURL());
            xmlStringBuilder.condAttribute(sharedBookmark.isRss(), "rss", "true");
            xmlStringBuilder.closeEmptyElement();
        }
        for (BookmarkedConference bookmarkedConference : this.getBookmarkedConferences()) {
            if (bookmarkedConference.isShared()) continue;
            xmlStringBuilder.halfOpenElement("conference");
            xmlStringBuilder.attribute("name", bookmarkedConference.getName());
            xmlStringBuilder.attribute("autojoin", Boolean.toString(bookmarkedConference.isAutoJoin()));
            xmlStringBuilder.attribute("jid", (CharSequence)bookmarkedConference.getJid());
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.optElement("nick", (CharSequence)bookmarkedConference.getNickname());
            xmlStringBuilder.optElement("password", bookmarkedConference.getPassword());
            xmlStringBuilder.closeElement("conference");
        }
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    private static BookmarkedURL getURLStorage(XmlPullParser xmlPullParser) {
        Object object = xmlPullParser.getAttributeValue("", "name");
        String string = xmlPullParser.getAttributeValue("", "url");
        String string2 = xmlPullParser.getAttributeValue("", "rss");
        boolean bl = string2 != null && "true".equals(string2);
        object = new BookmarkedURL(string, (String)object, bl);
        boolean bl2 = false;
        while (!bl2) {
            XmlPullParser.Event event = xmlPullParser.next();
            if (event == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(xmlPullParser.getName())) {
                ((BookmarkedURL)object).setShared(true);
                continue;
            }
            if (event != XmlPullParser.Event.END_ELEMENT || !"url".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return object;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser xmlPullParser) {
        String string = xmlPullParser.getAttributeValue("", "name");
        boolean bl = ParserUtils.getBooleanAttribute((XmlPullParser)xmlPullParser, (String)"autojoin", (boolean)false);
        Object object = ParserUtils.getBareJidAttribute((XmlPullParser)xmlPullParser);
        object = new BookmarkedConference((e)object);
        ((BookmarkedConference)object).setName(string);
        ((BookmarkedConference)object).setAutoJoin(bl);
        boolean bl2 = false;
        while (!bl2) {
            Object object2 = xmlPullParser.next();
            if (object2 == XmlPullParser.Event.START_ELEMENT && "nick".equals(xmlPullParser.getName())) {
                object2 = xmlPullParser.nextText();
                ((BookmarkedConference)object).setNickname(d.b((String)object2));
                continue;
            }
            if (object2 == XmlPullParser.Event.START_ELEMENT && "password".equals(xmlPullParser.getName())) {
                ((BookmarkedConference)object).setPassword(xmlPullParser.nextText());
                continue;
            }
            if (object2 == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(xmlPullParser.getName())) {
                ((BookmarkedConference)object).setShared(true);
                continue;
            }
            if (object2 != XmlPullParser.Event.END_ELEMENT || !"conference".equals(xmlPullParser.getName())) continue;
            bl2 = true;
        }
        return object;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser xmlPullParser) {
            Bookmarks bookmarks = new Bookmarks();
            boolean bl = false;
            while (!bl) {
                Object object = xmlPullParser.next();
                if (object == XmlPullParser.Event.START_ELEMENT && "url".equals(xmlPullParser.getName())) {
                    object = Bookmarks.getURLStorage(xmlPullParser);
                    if (object == null) continue;
                    bookmarks.addBookmarkedURL((BookmarkedURL)object);
                    continue;
                }
                if (object == XmlPullParser.Event.START_ELEMENT && "conference".equals(xmlPullParser.getName())) {
                    object = Bookmarks.getConferenceStorage(xmlPullParser);
                    bookmarks.addBookmarkedConference((BookmarkedConference)object);
                    continue;
                }
                if (object != XmlPullParser.Event.END_ELEMENT || !Bookmarks.ELEMENT.equals(xmlPullParser.getName())) continue;
                bl = true;
            }
            return bookmarks;
        }
    }
}

