/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;

public class Open
extends IQ {
    public static final String ELEMENT = "open";
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    private final String sessionID;
    private final int blockSize;
    private final InBandBytestreamManager.StanzaType stanza;

    public Open(String string, int n, InBandBytestreamManager.StanzaType stanzaType) {
        super(ELEMENT, NAMESPACE);
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("Session ID must not be null or empty");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Block size must be greater than zero");
        }
        this.sessionID = string;
        this.blockSize = n;
        this.stanza = stanzaType;
        this.setType(IQ.Type.set);
    }

    public Open(String string, int n) {
        this(string, n, InBandBytestreamManager.StanzaType.IQ);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public InBandBytestreamManager.StanzaType getStanza() {
        return this.stanza;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder) {
        iQChildElementXmlStringBuilder.attribute("block-size", Integer.toString(this.blockSize));
        iQChildElementXmlStringBuilder.attribute("sid", this.sessionID);
        iQChildElementXmlStringBuilder.attribute("stanza", this.stanza.toString().toLowerCase(Locale.US));
        iQChildElementXmlStringBuilder.setEmptyElement();
        return iQChildElementXmlStringBuilder;
    }
}

