/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.bookmarkautojoin;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.b.d;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bookmarks.BookmarkManager;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;

public final class MucBookmarkAutojoinManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(MucBookmarkAutojoinManager.class.getName());
    private static final Map<XMPPConnection, MucBookmarkAutojoinManager> INSTANCES = new WeakHashMap<XMPPConnection, MucBookmarkAutojoinManager>();
    private static boolean autojoinEnabledDefault = false;
    private final MultiUserChatManager multiUserChatManager;
    private final BookmarkManager bookmarkManager;
    private boolean autojoinEnabled = autojoinEnabledDefault;

    public static void setAutojoinPerDefault(boolean bl) {
        autojoinEnabledDefault = bl;
    }

    public static synchronized MucBookmarkAutojoinManager getInstanceFor(XMPPConnection xMPPConnection) {
        MucBookmarkAutojoinManager mucBookmarkAutojoinManager = INSTANCES.get(xMPPConnection);
        if (mucBookmarkAutojoinManager == null) {
            mucBookmarkAutojoinManager = new MucBookmarkAutojoinManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, mucBookmarkAutojoinManager);
        }
        return mucBookmarkAutojoinManager;
    }

    private MucBookmarkAutojoinManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.multiUserChatManager = MultiUserChatManager.getInstanceFor(xMPPConnection);
        this.bookmarkManager = BookmarkManager.getBookmarkManager(xMPPConnection);
        xMPPConnection.addConnectionListener(new ConnectionListener(){

            public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
                if (!MucBookmarkAutojoinManager.this.autojoinEnabled) {
                    return;
                }
                MucBookmarkAutojoinManager.this.autojoinBookmarkedConferences();
            }
        });
    }

    public final void setAutojoinEnabled(boolean bl) {
        this.autojoinEnabled = bl;
    }

    public final void autojoinBookmarkedConferences() {
        Object object;
        try {
            object = this.bookmarkManager.getBookmarkedConferences();
        }
        catch (InterruptedException | SmackException.NotConnectedException throwable) {
            LOGGER.log(Level.FINER, "Could not get MUC bookmarks", throwable);
            return;
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException throwable) {
            LOGGER.log(Level.WARNING, "Could not get MUC bookmarks", throwable);
            return;
        }
        XMPPConnection xMPPConnection = this.connection();
        xMPPConnection = xMPPConnection.getUser().d();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (BookmarkedConference)object.next();
            if (!((BookmarkedConference)object2).isAutoJoin()) continue;
            d d2 = ((BookmarkedConference)object2).getNickname();
            if (d2 == null) {
                d2 = xMPPConnection;
            }
            String string = ((BookmarkedConference)object2).getPassword();
            object2 = this.multiUserChatManager.getMultiUserChat(((BookmarkedConference)object2).getJid());
            try {
                if ((object2 = ((MultiUserChat)object2).createOrJoinIfNecessary(d2, string)) == null) continue;
                ((MultiUserChat.MucCreateConfigFormHandle)object2).makeInstant();
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                LOGGER.log(Level.FINER, "Could not autojoin bookmarked MUC", throwable);
                return;
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | MultiUserChatException.NotAMucServiceException object3) {
                LOGGER.log(Level.WARNING, "Could not autojoin bookmarked MUC", (Throwable)object3);
            }
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection xMPPConnection) {
                MucBookmarkAutojoinManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

