/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;

public class MUCUser
implements ExtensionElement {
    public static final String ELEMENT = "x";
    public static final String NAMESPACE = "http://jabber.org/protocol/muc#user";
    public static final QName QNAME = new QName("http://jabber.org/protocol/muc#user", "x");
    private final Set<Status> statusCodes = new HashSet<Status>(4);
    private Invite invite;
    private Decline decline;
    private MUCItem item;
    private String password;
    private Destroy destroy;

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((ExtensionElement)this);
        xmlEnvironment.rightAngleBracket();
        xmlEnvironment.optElement((Element)this.getInvite());
        xmlEnvironment.optElement((Element)this.getDecline());
        xmlEnvironment.optElement((Element)this.getItem());
        xmlEnvironment.optElement("password", this.getPassword());
        xmlEnvironment.append(this.statusCodes);
        xmlEnvironment.optElement((Element)this.getDestroy());
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public MUCItem getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Status> getStatus() {
        return this.statusCodes;
    }

    public boolean hasStatus() {
        return !this.statusCodes.isEmpty();
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(MUCItem mUCItem) {
        this.item = mUCItem;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void addStatusCodes(Set<Status> set) {
        this.statusCodes.addAll(set);
    }

    public void addStatusCode(Status status) {
        this.statusCodes.add(status);
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    @Deprecated
    public static MUCUser getFrom(Stanza stanza) {
        return MUCUser.from(stanza);
    }

    public static MUCUser from(Stanza stanza) {
        return (MUCUser)stanza.getExtension(MUCUser.class);
    }

    public static final class Status
    implements NamedElement {
        public static final String ELEMENT = "status";
        private static final Map<Integer, Status> statusMap = new HashMap<Integer, Status>(8);
        public static final Status PRESENCE_TO_SELF_110 = Status.create(110);
        public static final Status ROOM_CREATED_201 = Status.create(201);
        public static final Status BANNED_301 = Status.create(301);
        public static final Status NEW_NICKNAME_303 = Status.create(303);
        public static final Status KICKED_307 = Status.create(307);
        public static final Status REMOVED_AFFIL_CHANGE_321 = Status.create(321);
        public static final Status REMOVED_FOR_TECHNICAL_REASONS_333 = Status.create(333);
        private final Integer code;

        public static Status create(String object) {
            object = Integer.valueOf((String)object);
            return Status.create((Integer)object);
        }

        public static Status create(Integer n) {
            Status status;
            Map<Integer, Status> map = statusMap;
            synchronized (map) {
                status = statusMap.get(n);
                if (status == null) {
                    status = new Status(n);
                    statusMap.put(n, status);
                }
            }
            return status;
        }

        private Status(int n) {
            this.code = n;
        }

        public final int getCode() {
            return this.code;
        }

        public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((NamedElement)this);
            xmlEnvironment.attribute("code", this.getCode());
            xmlEnvironment.closeEmptyElement();
            return xmlEnvironment;
        }

        public final String toString() {
            return this.code.toString();
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Status) {
                object = (Status)object;
                return this.code.equals(((Status)object).getCode());
            }
            return false;
        }

        public final int hashCode() {
            return this.code;
        }

        public final String getElementName() {
            return ELEMENT;
        }
    }

    public static class Decline
    implements ExtensionElement {
        public static final String ELEMENT = "decline";
        public static final QName QNAME = new QName("http://jabber.org/protocol/muc#user", "decline");
        private final String reason;
        private final e from;
        private final e to;

        public Decline(String string, e e2) {
            this(string, null, e2);
        }

        public Decline(String string, e e2, e e3) {
            this.reason = string;
            this.from = e2;
            this.to = e3;
        }

        public e getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public e getTo() {
            return this.to;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.optAttribute("to", (CharSequence)this.getTo());
            xmlEnvironment.optAttribute("from", (CharSequence)this.getFrom());
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.optElement("reason", this.getReason());
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public String getElementName() {
            return QNAME.getLocalPart();
        }

        public String getNamespace() {
            return QNAME.getNamespaceURI();
        }
    }

    public static class Invite
    implements NamedElement {
        public static final String ELEMENT = "invite";
        private final String reason;
        private final g from;
        private final e to;

        public Invite(String string, f f2) {
            this(string, (g)f2, null);
        }

        public Invite(String string, e e2) {
            this(string, null, e2);
        }

        public Invite(String string, g g2, e e2) {
            this.reason = string;
            this.from = g2;
            this.to = e2;
        }

        public g getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public e getTo() {
            return this.to;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((NamedElement)this);
            xmlEnvironment.optAttribute("to", (CharSequence)this.getTo());
            xmlEnvironment.optAttribute("from", (CharSequence)this.getFrom());
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.optElement("reason", this.getReason());
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }
}

