/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;

public class SubscriptionsExtension
extends NodeExtension {
    protected List<Subscription> items = Collections.emptyList();

    public SubscriptionsExtension(List<Subscription> list) {
        this(SubscriptionsNamespace.basic, null, list);
    }

    public SubscriptionsExtension(String string, List<Subscription> list) {
        this(SubscriptionsNamespace.basic, string, list);
    }

    public SubscriptionsExtension(SubscriptionsNamespace subscriptionsNamespace, String string, List<Subscription> list) {
        super(subscriptionsNamespace.type, string);
        if (list != null) {
            this.items = list;
        }
    }

    public List<Subscription> getSubscriptions() {
        return this.items;
    }

    @Override
    protected void addXml(XmlStringBuilder xmlStringBuilder) {
        if (this.items == null || this.items.size() == 0) {
            xmlStringBuilder.closeEmptyElement();
            return;
        }
        xmlStringBuilder.rightAngleBracket();
        xmlStringBuilder.append(this.items);
        xmlStringBuilder.closeElement((NamedElement)this);
    }

    public static enum SubscriptionsNamespace {
        basic(PubSubElementType.SUBSCRIPTIONS),
        owner(PubSubElementType.SUBSCRIPTIONS_OWNER);

        public final PubSubElementType type;

        private SubscriptionsNamespace(PubSubElementType pubSubElementType) {
            this.type = pubSubElementType;
        }

        public static SubscriptionsNamespace fromXmlns(String string) {
            for (SubscriptionsNamespace subscriptionsNamespace : SubscriptionsNamespace.values()) {
                if (!subscriptionsNamespace.type.getNamespace().getXmlns().equals(string)) continue;
                return subscriptionsNamespace;
            }
            throw new IllegalArgumentException("Invalid Subscription namespace: " + string);
        }
    }
}

