/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.e.c.b;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;

public abstract class FormField
implements FullyQualifiedElement {
    public static final String ELEMENT = "field";
    public static final String NAMESPACE = "jabber:x:data";
    public static final QName QNAME = new QName("jabber:x:data", "field");
    public static final String FORM_TYPE = "FORM_TYPE";
    private final String fieldName;
    private final String label;
    private final Type type;
    private final List<FormFieldChildElement> formFieldChildElements;
    private final MultiMap<QName, FormFieldChildElement> formFieldChildElementsMap;
    private final String description;
    private final boolean required;
    private transient List<CharSequence> rawValueCharSequences;
    protected transient List<FullyQualifiedElement> extraXmlChildElements;

    private MultiMap<QName, FormFieldChildElement> createChildElementsMap() {
        MultiMap multiMap = new MultiMap(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            multiMap.put((Object)formFieldChildElement.getQName(), (Object)formFieldChildElement);
        }
        return multiMap.asUnmodifiableMultiMap();
    }

    protected FormField(Builder<?, ?> object) {
        this.fieldName = ((Builder)object).fieldName;
        this.label = ((Builder)object).label;
        this.type = ((Builder)object).type;
        this.formFieldChildElements = ((Builder)object).formFieldChildElements != null ? Collections.unmodifiableList(((Builder)object).formFieldChildElements) : Collections.emptyList();
        if (this.fieldName == null && this.type != Type.fixed) {
            throw new IllegalArgumentException("The variable can only be null if the form is of type fixed");
        }
        object = null;
        boolean bl = false;
        ArrayList arrayList = new ArrayList(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            if (formFieldChildElement instanceof Description) {
                object = ((Description)formFieldChildElement).getDescription();
                continue;
            }
            if (!(formFieldChildElement instanceof Required)) continue;
            bl = true;
        }
        arrayList.trimToSize();
        this.description = object;
        this.required = bl;
        this.formFieldChildElementsMap = this.createChildElementsMap();
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        if (this.type == null) {
            return Type.text_single;
        }
        return this.type;
    }

    public List<? extends CharSequence> getValues() {
        return this.getRawValueCharSequences();
    }

    public abstract List<Value> getRawValues();

    public final List<CharSequence> getRawValueCharSequences() {
        if (this.rawValueCharSequences == null) {
            Object object = this.getRawValues();
            this.rawValueCharSequences = new ArrayList<CharSequence>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                Value value = (Value)object.next();
                this.rawValueCharSequences.add(value.value);
            }
        }
        return this.rawValueCharSequences;
    }

    public boolean hasValueSet() {
        List<? extends CharSequence> list = this.getValues();
        return !list.isEmpty();
    }

    public List<String> getValuesAsString() {
        Object object = this.getValues();
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            CharSequence charSequence = (CharSequence)object.next();
            arrayList.add(charSequence.toString());
        }
        return arrayList;
    }

    public String getFirstValue() {
        List<? extends CharSequence> list = this.getValues();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0).toString();
    }

    public Date getFirstValueAsDate() {
        String string = this.getFirstValue();
        if (string == null) {
            return null;
        }
        return b.a((String)string);
    }

    @Deprecated
    public String getVariable() {
        return this.getFieldName();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FormFieldChildElement getFormFieldChildElement(QName qName) {
        return (FormFieldChildElement)this.formFieldChildElementsMap.getFirst((Object)qName);
    }

    public List<FormFieldChildElement> getFormFieldChildElements(QName qName) {
        return this.formFieldChildElementsMap.getAll((Object)qName);
    }

    public List<FormFieldChildElement> getFormFieldChildElements() {
        return this.formFieldChildElements;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QName getQName() {
        return QNAME;
    }

    protected void populateExtraXmlChildElements() {
        List<Value> list = this.getRawValues();
        this.extraXmlChildElements = new ArrayList<FullyQualifiedElement>(list.size());
        this.extraXmlChildElements.addAll(list);
    }

    public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        return this.toXML(xmlEnvironment, true);
    }

    public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment, boolean bl) {
        xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlEnvironment.optAttribute("label", this.getLabel());
        xmlEnvironment.optAttribute("var", this.getFieldName());
        if (bl) {
            xmlEnvironment.attribute("type", (Enum)this.getType(), (Enum)Type.text_single);
        }
        if (this.extraXmlChildElements == null) {
            this.populateExtraXmlChildElements();
        }
        if (this.formFieldChildElements.isEmpty() && (this.extraXmlChildElements == null || this.extraXmlChildElements.isEmpty())) {
            xmlEnvironment.closeEmptyElement();
        } else {
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.optAppend(this.extraXmlChildElements);
            xmlEnvironment.append(this.formFieldChildElements);
            xmlEnvironment.closeElement((NamedElement)this);
        }
        return xmlEnvironment;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormField)) {
            return false;
        }
        object = (FormField)object;
        return this.toXML().toString().equals(object.toXML().toString());
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }

    public static BooleanFormField.Builder booleanBuilder(String string) {
        return new BooleanFormField.Builder(string);
    }

    public static TextSingleFormField.Builder fixedBuilder() {
        return FormField.fixedBuilder(null);
    }

    public static TextSingleFormField.Builder fixedBuilder(String string) {
        return new TextSingleFormField.Builder(string, Type.fixed);
    }

    public static TextSingleFormField.Builder hiddenBuilder(String string) {
        return new TextSingleFormField.Builder(string, Type.hidden);
    }

    public static JidMultiFormField.Builder jidMultiBuilder(String string) {
        return new JidMultiFormField.Builder(string);
    }

    public static JidSingleFormField.Builder jidSingleBuilder(String string) {
        return new JidSingleFormField.Builder(string);
    }

    public static ListMultiFormField.Builder listMultiBuilder(String string) {
        return new ListMultiFormField.Builder(string);
    }

    public static ListSingleFormField.Builder listSingleBuilder(String string) {
        return new ListSingleFormField.Builder(string);
    }

    public static TextMultiFormField.Builder textMultiBuilder(String string) {
        return new TextMultiFormField.Builder(string);
    }

    public static TextSingleFormField.Builder textPrivateBuilder(String string) {
        return new TextSingleFormField.Builder(string, Type.text_private);
    }

    public static TextSingleFormField.Builder textSingleBuilder(String string) {
        return new TextSingleFormField.Builder(string, Type.text_single);
    }

    public static TextSingleFormField.Builder builder(String string) {
        return FormField.textSingleBuilder(string);
    }

    public static TextSingleFormField buildHiddenFormType(String string) {
        return ((TextSingleFormField.Builder)FormField.hiddenBuilder(FORM_TYPE).setValue(string)).build();
    }

    public <F extends FormField> F ifPossibleAs(Class<F> clazz) {
        if (clazz.isInstance(this)) {
            return (F)((FormField)clazz.cast(this));
        }
        return null;
    }

    public <F extends FormField> F ifPossibleAsOrThrow(Class<F> clazz) {
        if ((clazz = this.ifPossibleAs(clazz)) == null) {
            throw new IllegalArgumentException();
        }
        return (F)clazz;
    }

    public TextSingleFormField asHiddenFormTypeFieldIfPossible() {
        TextSingleFormField textSingleFormField = this.ifPossibleAs(TextSingleFormField.class);
        if (textSingleFormField == null) {
            return null;
        }
        if (this.getType() != Type.hidden) {
            return null;
        }
        if (!this.getFieldName().equals(FORM_TYPE)) {
            return null;
        }
        return textSingleFormField;
    }

    public static class Value
    implements FullyQualifiedElement {
        public static final String ELEMENT = "value";
        public static final QName QNAME = new QName("jabber:x:data", "value");
        private final CharSequence value;

        public Value(CharSequence charSequence) {
            this.value = charSequence;
        }

        public CharSequence getValue() {
            return this.value;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.escape(this.value);
            return xmlEnvironment.closeElement((NamedElement)this);
        }

        public boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, value) -> builder.append((Object)this.value, (Object)value.value));
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Required
    extends StandardFormFieldChildElement {
        public static final Required INSTANCE = new Required();
        public static final String ELEMENT = "required";
        public static final QName QNAME = new QName("jabber:x:data", "required");

        private Required() {
        }

        public final String getElementName() {
            return ELEMENT;
        }

        public final String getNamespace() {
            return FormField.NAMESPACE;
        }

        public final QName getQName() {
            return QNAME;
        }

        @Override
        public final boolean mustBeOnlyOfHisKind() {
            return true;
        }

        public final String toXML(XmlEnvironment xmlEnvironment) {
            return "<required/>";
        }
    }

    public static class Description
    extends StandardFormFieldChildElement {
        public static final String ELEMENT = "desc";
        public static final QName QNAME = new QName("jabber:x:data", "desc");
        private final String description;

        public Description(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.escape(this.description);
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }
    }

    public static final class Option
    implements FullyQualifiedElement {
        public static final String ELEMENT = "option";
        public static final QName QNAME = new QName("jabber:x:data", "option");
        private final String label;
        private final Value value;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Option(String string) {
            this(null, string);
        }

        public Option(String string, String string2) {
            this.label = string;
            this.value = new Value(string2);
        }

        public Option(String string, Value value) {
            this.label = string;
            this.value = value;
        }

        public final String getLabel() {
            return this.label;
        }

        public final Value getValue() {
            return this.value;
        }

        public final String getValueString() {
            return this.value.value.toString();
        }

        public final String toString() {
            return this.getLabel();
        }

        public final String getElementName() {
            return ELEMENT;
        }

        public final String getNamespace() {
            return FormField.NAMESPACE;
        }

        public final QName getQName() {
            return QNAME;
        }

        public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((NamedElement)this);
            xmlEnvironment.optAttribute("label", this.getLabel());
            xmlEnvironment.rightAngleBracket();
            xmlEnvironment.element("value", this.getValueString());
            xmlEnvironment.closeElement((NamedElement)this);
            return xmlEnvironment;
        }

        public final boolean equals(Object object) {
            return EqualsUtil.equals((Object)this, (Object)object, (builder, option) -> builder.append((Object)this.value, (Object)option.value).append((Object)this.label, (Object)option.label));
        }

        public final int hashCode() {
            return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.value).append((Object)this.label));
        }
    }

    private static abstract class StandardFormFieldChildElement
    implements FormFieldChildElement {
        private StandardFormFieldChildElement() {
        }
    }

    public static abstract class Builder<F extends FormField, B extends Builder<?, ?>> {
        private final String fieldName;
        private final Type type;
        private String label;
        private List<FormFieldChildElement> formFieldChildElements;
        private boolean disallowType;
        private boolean disallowFurtherFormFieldChildElements;

        protected Builder(String string, Type type) {
            if (StringUtils.isNullOrEmpty((CharSequence)string) && type != Type.fixed) {
                throw new IllegalArgumentException("Fields of type " + (Object)((Object)type) + " must have a field name set");
            }
            this.fieldName = string;
            this.type = type;
        }

        protected Builder(FormField formField) {
            this.fieldName = formField.fieldName;
            this.label = formField.label;
            this.type = formField.type;
            this.formFieldChildElements = CollectionUtil.newListWith((Collection)formField.formFieldChildElements);
        }

        public B setDescription(String object) {
            object = new Description((String)object);
            this.setOnlyElement(object);
            return this.getThis();
        }

        public B setLabel(String string) {
            this.label = (String)Objects.requireNonNull((Object)string, (String)"label must not be null");
            return this.getThis();
        }

        public B setRequired() {
            return this.setRequired(true);
        }

        public B setRequired(boolean bl) {
            if (bl) {
                this.setOnlyElement(Required.INSTANCE);
            }
            return this.getThis();
        }

        public B addFormFieldChildElements(Collection<? extends FormFieldChildElement> object) {
            object = object.iterator();
            while (object.hasNext()) {
                FormFieldChildElement formFieldChildElement = (FormFieldChildElement)object.next();
                this.addFormFieldChildElement(formFieldChildElement);
            }
            return this.getThis();
        }

        public B addFormFieldChildElement(FormFieldChildElement formFieldChildElement) {
            if (this.disallowFurtherFormFieldChildElements) {
                throw new IllegalArgumentException();
            }
            if (formFieldChildElement.requiresNoTypeSet() && this.type != null) {
                throw new IllegalArgumentException("Elements of type " + formFieldChildElement.getClass() + " can only be added to form fields where no type is set");
            }
            this.ensureThatFormFieldChildElementsIsSet();
            if (!this.formFieldChildElements.isEmpty() && formFieldChildElement.isExclusiveElement()) {
                throw new IllegalArgumentException("Elements of type " + formFieldChildElement.getClass() + " must be the only child elements of a form field.");
            }
            this.disallowType = this.disallowType || formFieldChildElement.requiresNoTypeSet();
            this.disallowFurtherFormFieldChildElements = formFieldChildElement.isExclusiveElement();
            this.formFieldChildElements.add(formFieldChildElement);
            for (FormFieldChildElement formFieldChildElement2 : this.formFieldChildElements) {
                try {
                    formFieldChildElement2.checkConsistency(this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.formFieldChildElements.remove(formFieldChildElement);
                    throw illegalArgumentException;
                }
            }
            return this.getThis();
        }

        protected abstract void resetInternal();

        public B reset() {
            this.resetInternal();
            if (this.formFieldChildElements == null) {
                return this.getThis();
            }
            Iterator<FormFieldChildElement> iterator = this.formFieldChildElements.iterator();
            while (iterator.hasNext()) {
                FormFieldChildElement formFieldChildElement = iterator.next();
                if (!(formFieldChildElement instanceof Value)) continue;
                iterator.remove();
            }
            Builder builder = this;
            builder.disallowFurtherFormFieldChildElements = false;
            builder.disallowType = false;
            return this.getThis();
        }

        public abstract F build();

        public Type getType() {
            return this.type;
        }

        private void ensureThatFormFieldChildElementsIsSet() {
            if (this.formFieldChildElements == null) {
                this.formFieldChildElements = new ArrayList<FormFieldChildElement>(4);
            }
        }

        private <E extends FormFieldChildElement> void setOnlyElement(E e2) {
            Class<?> clazz = e2.getClass();
            this.ensureThatFormFieldChildElementsIsSet();
            for (int j = 0; j < this.formFieldChildElements.size(); ++j) {
                if (!this.formFieldChildElements.get(j).getClass().equals(clazz)) continue;
                this.formFieldChildElements.set(j, e2);
                return;
            }
            this.addFormFieldChildElement(e2);
        }

        public abstract B getThis();
    }

    public static enum Type {
        bool,
        fixed,
        hidden,
        jid_multi,
        jid_single,
        list_multi,
        list_single,
        text_multi,
        text_private,
        text_single;


        public final String toString() {
            switch (this) {
                case bool: {
                    return "boolean";
                }
            }
            return this.name().replace('_', '-');
        }

        public static Type fromString(String string) {
            if (string == null) {
                return null;
            }
            switch (string) {
                case "boolean": {
                    return bool;
                }
            }
            string = string.replace('-', '_');
            return Type.valueOf(string);
        }
    }
}

