/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReadOnlyIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Closeable,
Iterable<Map.Entry<K, P>> {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    @Override
    public final P get(K object) {
        ChannelPool channelPool = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(object, (String)"key"));
        if (channelPool == null && (object = this.map.putIfAbsent(object, channelPool = this.newPool(object))) != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool);
            channelPool = object;
        }
        return (P)channelPool;
    }

    public final boolean remove(K object) {
        if ((object = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(object, (String)"key"))) != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(object);
            return true;
        }
        return false;
    }

    private Future<Boolean> removeAsyncIfSupported(K object) {
        if ((object = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(object, (String)"key"))) != null) {
            final Promise promise = GlobalEventExecutor.INSTANCE.newPromise();
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(object).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) {
                    if (future.isSuccess()) {
                        promise.setSuccess((Object)Boolean.TRUE);
                        return;
                    }
                    promise.setFailure(future.cause());
                }
            });
            return promise;
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture((Object)Boolean.FALSE);
    }

    private static Future<Void> poolCloseAsyncIfSupported(ChannelPool channelPool) {
        if (channelPool instanceof SimpleChannelPool) {
            return ((SimpleChannelPool)channelPool).closeAsync();
        }
        try {
            channelPool.close();
            return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        catch (Exception exception) {
            return GlobalEventExecutor.INSTANCE.newFailedFuture((Throwable)exception);
        }
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean contains(K k) {
        return this.map.containsKey(ObjectUtil.checkNotNull(k, (String)"key"));
    }

    protected abstract P newPool(K var1);

    @Override
    public final void close() {
        for (Object k : this.map.keySet()) {
            this.removeAsyncIfSupported(k).syncUninterruptibly();
        }
    }
}

