/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.file.Path;

final class NioDomainSocketUtil {
    private static final Method OF_METHOD;
    private static final Method GET_PATH_METHOD;

    static SocketAddress newUnixDomainSocketAddress(String string) {
        if (OF_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            return (SocketAddress)OF_METHOD.invoke(null, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
    }

    static void deleteSocketFile(SocketAddress object) {
        if (GET_PATH_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            object = (Path)GET_PATH_METHOD.invoke(object, new Object[0]);
            if (object != null) {
                object.toFile().delete();
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
    }

    private NioDomainSocketUtil() {
    }

    static {
        Method method;
        GenericDeclaration genericDeclaration;
        try {
            genericDeclaration = Class.forName("java.net.UnixDomainSocketAddress");
            method = genericDeclaration.getMethod("of", String.class);
            genericDeclaration = genericDeclaration.getMethod("getPath", new Class[0]);
        }
        catch (Throwable throwable) {
            method = null;
            genericDeclaration = null;
        }
        OF_METHOD = method;
        GET_PATH_METHOD = genericDeclaration;
    }
}

