/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0011\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\fH\u0082 J)\u0010$\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\t\u0010&\u001a\u00020\fH\u0082 J(\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\fH\u0014J\u0019\u0010)\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010*\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "bytesToDraw", "", "offScreenBufferPtr", "", "offScreenContextPtr", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "storage", "Lorg/jetbrains/skia/Bitmap;", "createAndBindTexture", "width", "", "height", "dispose", "", "disposeOffScreenBuffer", "bufferPtr", "disposeOffScreenContext", "contextPtr", "finishRendering", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getFboId", "texturePtr", "makeOffScreenBuffer", "oldBufferPtr", "makeOffScreenContext", "onRender", "nanoTime", "startRendering", "unbindAndDisposeTexture", "skiko"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingPainter painter;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;

    public LinuxOpenGLSwingRedrawer(SwingLayerProperties object, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super((SwingLayerProperties)object, skiaLayerAnalytics, GraphicsApi.OPENGL);
        this.renderDelegate = skikoRenderDelegate;
        this.onDeviceChosen("OpenGL OffScreen");
        this.painter = new SoftwareSwingPainter((SwingLayerProperties)object);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        long l = linuxOpenGLSwingRedrawer.makeOffScreenContext();
        object = linuxOpenGLSwingRedrawer;
        if (l == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        ((LinuxOpenGLSwingRedrawer)object).offScreenContextPtr = l;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.disposeOffScreenBuffer(linuxOpenGLSwingRedrawer.offScreenBufferPtr);
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
        linuxOpenGLSwingRedrawer2.disposeOffScreenContext(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
        this.painter.dispose();
        super.dispose();
    }

    @Override
    protected final void onRender(Graphics2D graphics2D, int n, int n2, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, n, n2);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        linuxOpenGLSwingRedrawer.startRendering(linuxOpenGLSwingRedrawer.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, n, n2, l, graphics2D){
                final /* synthetic */ LinuxOpenGLSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    this.this$0 = linuxOpenGLSwingRedrawer;
                    this.$width = n;
                    this.$height = n2;
                    this.$nanoTime = l;
                    this.$g = graphics2D;
                    super(1);
                }

                public final void invoke(CloseScope object) {
                    Intrinsics.checkNotNullParameter((Object)object, (String)"");
                    long l = LinuxOpenGLSwingRedrawer.access$createAndBindTexture(this.this$0, this.$width, this.$height);
                    if (l == 0L) {
                        throw new RenderException("Cannot create offScreen OpenGL texture", null, 2, null);
                    }
                    int n = LinuxOpenGLSwingRedrawer.access$getFboId(this.this$0, l);
                    Managed managed = (BackendRenderTarget)object.autoClose((AutoCloseable)RenderTargetsKt.makeGLRenderTarget(this.$width, this.$height, 0, 8, n, 32856));
                    DirectContext directContext = (DirectContext)object.autoClose((AutoCloseable)RenderTargetsKt.makeGLContext());
                    managed = Surface.Companion.makeFromBackendRenderTarget(directContext, (BackendRenderTarget)managed, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (managed == null || (object = (Surface)object.autoClose((AutoCloseable)managed)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    managed = ((Surface)object).getCanvas();
                    ((Canvas)managed).clear(0);
                    LinuxOpenGLSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender((Canvas)managed, this.$width, this.$height, this.$nanoTime);
                    LinuxOpenGLSwingRedrawer.access$flush(this.this$0, (Surface)object, this.$g);
                    LinuxOpenGLSwingRedrawer.access$unbindAndDisposeTexture(this.this$0, l);
                }
            }));
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer2 = this;
            linuxOpenGLSwingRedrawer2.finishRendering(linuxOpenGLSwingRedrawer2.offScreenContextPtr);
            return;
        }
        catch (Throwable throwable) {
            LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer3 = this;
            linuxOpenGLSwingRedrawer3.finishRendering(linuxOpenGLSwingRedrawer3.offScreenContextPtr);
            throw throwable;
        }
    }

    private final void flush(Surface surface, Graphics2D graphics2D) {
        surface.flushAndSubmit(true);
        this.painter.paint(graphics2D, surface, 0L);
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    public static final /* synthetic */ long access$createAndBindTexture(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, int n, int n2) {
        return linuxOpenGLSwingRedrawer.createAndBindTexture(n, n2);
    }

    public static final /* synthetic */ int access$getFboId(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, long l) {
        return linuxOpenGLSwingRedrawer.getFboId(l);
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer) {
        return linuxOpenGLSwingRedrawer.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, Surface surface, Graphics2D graphics2D) {
        linuxOpenGLSwingRedrawer.flush(surface, graphics2D);
    }

    public static final /* synthetic */ void access$unbindAndDisposeTexture(LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer, long l) {
        linuxOpenGLSwingRedrawer.unbindAndDisposeTexture(l);
    }
}

