/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.engine.ClassLoaderDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljava/lang/ClassLoader;", "", "Ljava/net/URL;", "allURLs", "(Ljava/lang/ClassLoader;)Ljava/util/Set;", "", "urlClassPath", "(Ljava/lang/ClassLoader;)Ljava/util/List;", "urlClassPathByPackagesList", "Ljava/lang/Class;", "Ljava/lang/reflect/Field;", "findURLClassPathField", "(Ljava/lang/Class;)Ljava/lang/reflect/Field;", "ktor-server-core"})
public final class ClassLoadersKt {
    public static final Set<URL> allURLs(ClassLoader object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Object object3 = ((ClassLoader)object).getParent();
        if (object3 == null || (object3 = ClassLoadersKt.allURLs((ClassLoader)object3)) == null) {
            object3 = object2 = SetsKt.emptySet();
        }
        if (object instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)object).getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"");
            object = CollectionsKt.toSet((Iterable)ArraysKt.filterNotNull((Object[])uRLArray));
            return SetsKt.plus((Set)object, (Iterable)((Iterable)object2));
        }
        List<URL> list = ClassLoadersKt.urlClassPath((ClassLoader)object);
        if (list == null) {
            return object2;
        }
        object = list;
        return SetsKt.plus((Set)object2, (Iterable)((Iterable)object));
    }

    private static final List<URL> urlClassPath(ClassLoader classLoader) {
        try {
            Field field = ClassLoadersKt.findURLClassPathField(classLoader.getClass());
            if (field == null) {
                return null;
            }
            Object[] objectArray = field;
            field.setAccessible(true);
            Object object = objectArray.get(classLoader);
            if (object == null) {
                return null;
            }
            objectArray = object;
            Method method = object.getClass().getMethod("getURLs", new Class[0]);
            if (method == null) {
                return null;
            }
            Method method2 = method;
            method.setAccessible(true);
            objectArray = (URL[])method2.invoke((Object)objectArray, new Object[0]);
            if (objectArray != null) {
                return ArraysKt.toList((Object[])objectArray);
            }
            return null;
        }
        catch (Throwable throwable) {
            List<URL> list;
            try {
                list = ClassLoadersKt.urlClassPathByPackagesList(classLoader);
            }
            catch (Throwable throwable2) {
                list = null;
            }
            return list;
        }
    }

    private static final List<URL> urlClassPathByPackagesList(ClassLoader classLoader) {
        Object object;
        Object object3 = (HashSet<String>)((Object)new ClassLoaderDelegate(classLoader).packagesList());
        HashSet<String> hashSet = object3;
        ArrayList<Object> arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        for (Object object22 : hashSet) {
            object3 = (String)object22;
            hashSet = arrayList;
            hashSet.add(StringsKt.replace$default((String)object3, (char)'.', (char)'/', (boolean)false, (int)4, null));
        }
        object3 = arrayList;
        hashSet = new HashSet();
        arrayList = object3.iterator();
        while (arrayList.hasNext()) {
            object3 = arrayList.next();
            object = (String)object3;
            char[] cArray = new char[1];
            object3 = cArray;
            cArray[0] = 47;
            List list = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])object3, (boolean)false, (int)0, (int)6, null);
            object3 = (Iterable)new IntRange(1, list.size());
            Object object2 = object3;
            object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                int n2 = ((IntIterator)object2).nextInt();
                Iterator iterator = object3;
                iterator.add((String)CollectionsKt.joinToString$default((Iterable)list.subList(0, n2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            }
            object = CollectionsKt.plus((Collection)((List)object3), object);
            CollectionsKt.addAll(hashSet, (Iterable)object);
        }
        object3 = hashSet;
        object3 = CollectionsKt.plus((Collection)CollectionsKt.sortedWith((Iterable)object3, (Comparator)new Comparator(){

            public final int compare(T object, T object2) {
                char c2;
                int n2;
                object = (String)object;
                object = (CharSequence)object;
                int n3 = 0;
                for (n2 = 0; n2 < object.length(); ++n2) {
                    char c3;
                    c2 = object.charAt(n2);
                    c2 = c2;
                    if (!(c3 == '/')) continue;
                    ++n3;
                }
                object = (String)object2;
                object2 = n3;
                object = (CharSequence)object;
                n3 = 0;
                for (n2 = 0; n2 < object.length(); ++n2) {
                    char c4;
                    c2 = object.charAt(n2);
                    c2 = c2;
                    if (!(c4 == '/')) continue;
                    ++n3;
                }
                return ComparisonsKt.compareValues(object2, (Comparable)Integer.valueOf(n3));
            }
        }), (Object)"");
        object3 = (Iterable)object3;
        hashSet = object3;
        arrayList = new ArrayList();
        for (Object t : hashSet) {
            Object object4;
            block8: {
                block7: {
                    object3 = (String)t;
                    object4 = classLoader.getResources((String)object3);
                    if (object4 == null) break block7;
                    ArrayList<URL> arrayList2 = Collections.list(object4);
                    Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"");
                    object4 = arrayList2;
                    if (object4 != null) break block8;
                }
                object4 = CollectionsKt.emptyList();
            }
            object3 = (Iterable)object4;
            CollectionsKt.addAll(arrayList, object3);
        }
        object3 = arrayList;
        hashSet = new HashSet<String>();
        arrayList = new ArrayList<Object>();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object = object3.next();
            URL uRL = (URL)object;
            String string = uRL.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            String string2 = StringsKt.substringBefore$default((String)string, (char)'!', null, (int)2, null);
            if (!hashSet.add(string2)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    private static final Field findURLClassPathField(Class<?> object) {
        Object object2;
        block3: {
            Field[] fieldArray = ((Class)object).getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
            for (Object object3 : (Object[])fieldArray) {
                Field field = (Field)object3;
                if (!(Intrinsics.areEqual((Object)field.getName(), (Object)"ucp") && Intrinsics.areEqual((Object)field.getType().getSimpleName(), (Object)"URLClassPath"))) continue;
                object2 = object3;
                break block3;
            }
            object2 = null;
        }
        Field field = (Field)object2;
        if (field != null) {
            object = field;
            return object;
        }
        AnnotatedElement annotatedElement = ((Class)object).getSuperclass();
        if (annotatedElement == null || (annotatedElement = ClassLoadersKt.findURLClassPathField(annotatedElement)) == null) {
            return null;
        }
        return annotatedElement;
    }
}

