/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0096@\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lio/ktor/server/routing/ContentTypeHeaderRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "Lio/ktor/http/ContentType;", "contentType", "<init>", "(Lio/ktor/http/ContentType;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "component1", "()Lio/ktor/http/ContentType;", "copy", "(Lio/ktor/http/ContentType;)Lio/ktor/server/routing/ContentTypeHeaderRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Lio/ktor/http/ContentType;", "getContentType", "Lio/ktor/server/routing/RouteSelectorEvaluation$Failure;", "failedEvaluation", "Lio/ktor/server/routing/RouteSelectorEvaluation$Failure;", "ktor-server-core"})
public final class ContentTypeHeaderRouteSelector
extends RouteSelector {
    private final ContentType contentType;
    private final RouteSelectorEvaluation.Failure failedEvaluation;

    public ContentTypeHeaderRouteSelector(ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        this.contentType = contentType;
        this.failedEvaluation = new RouteSelectorEvaluation.Failure(0.01, HttpStatusCode.Companion.getUnsupportedMediaType());
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public final Object evaluate(RoutingResolveContext headerValue, int n2, Continuation<? super RouteSelectorEvaluation> headerValue2) {
        Object v0;
        block2: {
            headerValue = ApplicationRequestPropertiesKt.header(headerValue.getCall().getRequest(), HttpHeaders.INSTANCE.getContentType());
            headerValue = HttpHeaderValueParserKt.parseAndSortContentTypeHeader((String)headerValue);
            headerValue = (Iterable)headerValue;
            for (Object t2 : headerValue) {
                headerValue2 = (HeaderValue)t2;
                if (!ContentType.Companion.parse(headerValue2.getValue()).match(this.contentType)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        HeaderValue headerValue3 = v0;
        if (headerValue3 == null) {
            return this.failedEvaluation;
        }
        headerValue = headerValue3;
        return new RouteSelectorEvaluation.Success(headerValue.getQuality(), null, 0, 6, null);
    }

    public final String toString() {
        return "(contentType = " + this.contentType + ')';
    }

    public final ContentType component1() {
        return this.contentType;
    }

    public final ContentTypeHeaderRouteSelector copy(ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        return new ContentTypeHeaderRouteSelector(contentType);
    }

    public static /* synthetic */ ContentTypeHeaderRouteSelector copy$default(ContentTypeHeaderRouteSelector contentTypeHeaderRouteSelector, ContentType contentType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            contentType = contentTypeHeaderRouteSelector.contentType;
        }
        return contentTypeHeaderRouteSelector.copy(contentType);
    }

    public final int hashCode() {
        return this.contentType.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentTypeHeaderRouteSelector)) {
            return false;
        }
        object = (ContentTypeHeaderRouteSelector)object;
        return Intrinsics.areEqual((Object)this.contentType, (Object)((ContentTypeHeaderRouteSelector)object).contentType);
    }
}

