/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.application.PipelineCall;
import io.ktor.server.routing.RoutingNode;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTraceEntry;
import io.ktor.server.routing.Stack;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u001b\u0010 \u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0004\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0018\u0010+\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020\u00148\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b-\u0010.R \u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00040/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010%\u00a8\u00061"}, d2={"Lio/ktor/server/routing/RoutingResolveTrace;", "", "Lio/ktor/server/application/PipelineCall;", "call", "", "", "segments", "<init>", "(Lio/ktor/server/application/PipelineCall;Ljava/util/List;)V", "Lio/ktor/server/routing/RoutingResolveTraceEntry;", "entry", "", "register", "(Lio/ktor/server/routing/RoutingResolveTraceEntry;)V", "Lio/ktor/server/routing/RoutingNode;", "route", "", "segmentIndex", "begin", "(Lio/ktor/server/routing/RoutingNode;I)V", "Lio/ktor/server/routing/RoutingResolveResult;", "result", "finish", "(Lio/ktor/server/routing/RoutingNode;ILio/ktor/server/routing/RoutingResolveResult;)V", "skip", "registerFinalResult", "(Lio/ktor/server/routing/RoutingResolveResult;)V", "toString", "()Ljava/lang/String;", "buildText", "Lio/ktor/server/routing/RoutingResolveResult$Success;", "trait", "addCandidate", "(Ljava/util/List;)V", "Lio/ktor/server/application/PipelineCall;", "getCall", "()Lio/ktor/server/application/PipelineCall;", "Ljava/util/List;", "getSegments", "()Ljava/util/List;", "Lio/ktor/server/routing/Stack;", "stack", "Lio/ktor/server/routing/Stack;", "routing", "Lio/ktor/server/routing/RoutingResolveTraceEntry;", "finalResult", "Lio/ktor/server/routing/RoutingResolveResult;", "", "resolveCandidates", "ktor-server-core"})
public final class RoutingResolveTrace {
    private final PipelineCall call;
    private final List<String> segments;
    private final Stack<RoutingResolveTraceEntry> stack;
    private RoutingResolveTraceEntry routing;
    private RoutingResolveResult finalResult;
    private final List<List<RoutingResolveResult.Success>> resolveCandidates;

    public RoutingResolveTrace(PipelineCall pipelineCall, List<String> list) {
        Intrinsics.checkNotNullParameter((Object)pipelineCall, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.call = pipelineCall;
        this.segments = list;
        this.stack = new Stack();
        this.resolveCandidates = new ArrayList();
    }

    public final PipelineCall getCall() {
        return this.call;
    }

    public final List<String> getSegments() {
        return this.segments;
    }

    private final void register(RoutingResolveTraceEntry routingResolveTraceEntry) {
        if (this.stack.empty()) {
            this.routing = routingResolveTraceEntry;
            return;
        }
        this.stack.peek().append(routingResolveTraceEntry);
    }

    public final void begin(RoutingNode routingNode, int n2) {
        Intrinsics.checkNotNullParameter((Object)routingNode, (String)"");
        this.stack.push(new RoutingResolveTraceEntry(routingNode, n2, null, 4, null));
    }

    public final void finish(RoutingNode object, int n2, RoutingResolveResult routingResolveResult) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)routingResolveResult, (String)"");
        RoutingResolveTraceEntry routingResolveTraceEntry = this.stack.pop();
        if (!Intrinsics.areEqual((Object)routingResolveTraceEntry.getRoute(), (Object)object)) {
            object = "end should be called for the same route as begin";
            throw new IllegalArgumentException(object.toString());
        }
        if (!(routingResolveTraceEntry.getSegmentIndex() == n2)) {
            object = "end should be called for the same segmentIndex as begin";
            throw new IllegalArgumentException(object.toString());
        }
        routingResolveTraceEntry.setResult(routingResolveResult);
        this.register(routingResolveTraceEntry);
    }

    public final void skip(RoutingNode routingNode, int n2, RoutingResolveResult routingResolveResult) {
        Intrinsics.checkNotNullParameter((Object)routingNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)routingResolveResult, (String)"");
        this.register(new RoutingResolveTraceEntry(routingNode, n2, routingResolveResult));
    }

    public final void registerFinalResult(RoutingResolveResult routingResolveResult) {
        Intrinsics.checkNotNullParameter((Object)routingResolveResult, (String)"");
        this.finalResult = routingResolveResult;
    }

    public final String toString() {
        return "Trace for " + this.segments;
    }

    public final String buildText() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        stringBuilder.append(this.toString()).append('\n');
        RoutingResolveTraceEntry routingResolveTraceEntry = this.routing;
        if (routingResolveTraceEntry != null) {
            routingResolveTraceEntry.buildText(stringBuilder2, 0);
        }
        if (this.finalResult != null) {
            stringBuilder2.append("Matched routes:\n");
            if (this.resolveCandidates.isEmpty()) {
                stringBuilder2.append("  No results\n");
            } else {
                stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)this.resolveCandidates, (CharSequence)"\n", null, null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3, (int)30, null)).append('\n');
            }
            stringBuilder2.append("Routing resolve result:\n");
            StringBuilder stringBuilder3 = new StringBuilder("  ");
            RoutingResolveResult routingResolveResult = this.finalResult;
            if (routingResolveResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                routingResolveResult = null;
            }
            stringBuilder2.append(stringBuilder3.append(routingResolveResult).toString());
        }
        return stringBuilder.toString();
    }

    public final void addCandidate(List<RoutingResolveResult.Success> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        int n2 = list.size();
        ArrayList<RoutingResolveResult.Success> arrayList = new ArrayList<RoutingResolveResult.Success>(n2);
        for (int j = 0; j < n2; ++j) {
            int n3 = j;
            ArrayList<RoutingResolveResult.Success> arrayList2 = arrayList;
            arrayList2.add((RoutingResolveResult.Success)list.get(n3));
        }
        list = arrayList;
        this.resolveCandidates.add(list);
    }

    private static final CharSequence buildText$lambda$4$lambda$3$lambda$2(RoutingResolveResult.Success success) {
        Intrinsics.checkNotNullParameter((Object)success, (String)"");
        return "\"" + success.getRoute().getSelector() + '\"';
    }

    private static final CharSequence buildText$lambda$4$lambda$3(List list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" -> ", (CharSequence)"  ", null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3$lambda$2, (int)28, null);
    }
}

