/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.util.internal.ObjectUtil;

public final class HttpDecoderConfig
implements Cloneable {
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean allowPartialChunks = true;
    private HttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory();
    private HttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory();
    private boolean allowDuplicateContentLengths = false;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int initialBufferSize = 128;

    public final int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public final HttpDecoderConfig setInitialBufferSize(int n) {
        ObjectUtil.checkPositive((int)n, (String)"initialBufferSize");
        this.initialBufferSize = n;
        return this;
    }

    public final int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public final HttpDecoderConfig setMaxInitialLineLength(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxInitialLineLength");
        this.maxInitialLineLength = n;
        return this;
    }

    public final int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public final HttpDecoderConfig setMaxHeaderSize(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxHeaderSize");
        this.maxHeaderSize = n;
        return this;
    }

    public final int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public final HttpDecoderConfig setMaxChunkSize(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxChunkSize");
        this.maxChunkSize = n;
        return this;
    }

    public final boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    public final HttpDecoderConfig setChunkedSupported(boolean bl) {
        this.chunkedSupported = bl;
        return this;
    }

    public final boolean isAllowPartialChunks() {
        return this.allowPartialChunks;
    }

    public final HttpDecoderConfig setAllowPartialChunks(boolean bl) {
        this.allowPartialChunks = bl;
        return this;
    }

    public final HttpHeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    public final HttpDecoderConfig setHeadersFactory(HttpHeadersFactory httpHeadersFactory) {
        ObjectUtil.checkNotNull((Object)httpHeadersFactory, (String)"headersFactory");
        this.headersFactory = httpHeadersFactory;
        return this;
    }

    public final boolean isAllowDuplicateContentLengths() {
        return this.allowDuplicateContentLengths;
    }

    public final HttpDecoderConfig setAllowDuplicateContentLengths(boolean bl) {
        this.allowDuplicateContentLengths = bl;
        return this;
    }

    public final HttpDecoderConfig setValidateHeaders(boolean bl) {
        DefaultHttpHeadersFactory defaultHttpHeadersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        this.headersFactory = bl ? DefaultHttpHeadersFactory.headersFactory() : defaultHttpHeadersFactory;
        this.trailersFactory = bl ? DefaultHttpHeadersFactory.trailersFactory() : defaultHttpHeadersFactory;
        return this;
    }

    public final HttpHeadersFactory getTrailersFactory() {
        return this.trailersFactory;
    }

    public final HttpDecoderConfig setTrailersFactory(HttpHeadersFactory httpHeadersFactory) {
        ObjectUtil.checkNotNull((Object)httpHeadersFactory, (String)"trailersFactory");
        this.trailersFactory = httpHeadersFactory;
        return this;
    }

    public final HttpDecoderConfig clone() {
        try {
            return (HttpDecoderConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

