/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebSocketExtensionUtil {
    private static final String EXTENSION_SEPARATOR = ",";
    private static final String PARAMETER_SEPARATOR = ";";
    private static final char PARAMETER_EQUAL = '=';
    private static final Pattern PARAMETER = Pattern.compile("^([^=]+)(=[\\\"]?([^\\\"]+)[\\\"]?)?$");

    static boolean isWebsocketUpgrade(HttpHeaders httpHeaders) {
        return httpHeaders.contains((CharSequence)HttpHeaderNames.UPGRADE) && httpHeaders.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && httpHeaders.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    public static List<WebSocketExtensionData> extractExtensions(String stringArray) {
        if ((stringArray = stringArray.split(EXTENSION_SEPARATOR)).length > 0) {
            ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(stringArray.length);
            for (String string : stringArray) {
                Map<String, String> map;
                String[] stringArray2 = string.split(PARAMETER_SEPARATOR);
                String string2 = stringArray2[0].trim();
                if (stringArray2.length > 1) {
                    map = new HashMap(stringArray2.length - 1);
                    for (int i = 1; i < stringArray2.length; ++i) {
                        Object object = stringArray2[i].trim();
                        if (!((Matcher)(object = PARAMETER.matcher((CharSequence)object))).matches() || ((Matcher)object).group(1) == null) continue;
                        map.put(((Matcher)object).group(1), ((Matcher)object).group(3));
                    }
                } else {
                    map = Collections.emptyMap();
                }
                arrayList.add(new WebSocketExtensionData(string2, map));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    static String computeMergeExtensionsHeaderValue(String object, List<WebSocketExtensionData> list) {
        object = object != null ? WebSocketExtensionUtil.extractExtensions((String)object) : Collections.emptyList();
        object = object.iterator();
        while (object.hasNext()) {
            void object3;
            int n;
            WebSocketExtensionData webSocketExtensionData = (WebSocketExtensionData)object.next();
            Object var3_4 = null;
            for (n = 0; n < list.size(); ++n) {
                WebSocketExtensionData webSocketExtensionData2 = list.get(n);
                if (!webSocketExtensionData2.name().equals(webSocketExtensionData.name())) continue;
                WebSocketExtensionData webSocketExtensionData3 = webSocketExtensionData2;
                break;
            }
            if (object3 == null) {
                list.add(webSocketExtensionData);
                continue;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(object3.parameters());
            hashMap.putAll(webSocketExtensionData.parameters());
            list.set(n, new WebSocketExtensionData(object3.name(), hashMap));
        }
        object = new StringBuilder(150);
        for (WebSocketExtensionData webSocketExtensionData : list) {
            ((StringBuilder)object).append(webSocketExtensionData.name());
            for (Map.Entry<String, String> entry : webSocketExtensionData.parameters().entrySet()) {
                ((StringBuilder)object).append(PARAMETER_SEPARATOR);
                ((StringBuilder)object).append(entry.getKey());
                if (entry.getValue() == null) continue;
                ((StringBuilder)object).append('=');
                ((StringBuilder)object).append(entry.getValue());
            }
            ((StringBuilder)object).append(EXTENSION_SEPARATOR);
        }
        if (!list.isEmpty()) {
            Object object2 = object;
            ((StringBuilder)object2).setLength(((StringBuilder)object2).length() - 1);
        }
        return ((StringBuilder)object).toString();
    }

    private WebSocketExtensionUtil() {
    }
}

