/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.BaseContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.FlagEnum;
import kotlin.text.MatchResult;
import kotlin.text.MatcherMatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexKt;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00060\u0001j\u0002`\u0002:\u000245B\u0011\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0004J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0007J\u0016\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\"\u0010$\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180'J\u0016\u0010(\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\bJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dJ \u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\u001dH\u0007J\b\u0010-\u001a\u00020\bH\u0016J\u0006\u0010.\u001a\u00020\u0004J\b\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u0017\u001a\u000203H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00066"}, d2={"Lkotlin/text/Regex;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "nativePattern", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/util/regex/Pattern;)V", "pattern", "", "(Ljava/lang/String;)V", "option", "Lkotlin/text/RegexOption;", "(Ljava/lang/String;Lkotlin/text/RegexOption;)V", "options", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getPattern", "()Ljava/lang/String;", "_options", "getOptions", "()Ljava/util/Set;", "matches", "", "input", "", "containsMatchIn", "find", "Lkotlin/text/MatchResult;", "startIndex", "", "findAll", "Lkotlin/sequences/Sequence;", "matchEntire", "matchAt", "index", "matchesAt", "replace", "replacement", "transform", "Lkotlin/Function1;", "replaceFirst", "split", "", "limit", "splitToSequence", "toString", "toPattern", "writeReplace", "", "readObject", "", "Ljava/io/ObjectInputStream;", "Serialized", "Companion", "kotlin-stdlib"})
public final class Regex
implements Serializable {
    public static final Companion Companion = new Companion(null);
    private final Pattern nativePattern;
    private Set<? extends RegexOption> _options;

    public Regex(Pattern pattern) {
        Intrinsics.checkNotNullParameter(pattern, "");
        this.nativePattern = pattern;
    }

    public Regex(String string) {
        Intrinsics.checkNotNullParameter(string, "");
        Pattern pattern = Pattern.compile(string);
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(String string, RegexOption regexOption) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(regexOption, "");
        Pattern pattern = Pattern.compile(string, Regex.Companion.ensureUnicodeCase(regexOption.getValue()));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public Regex(String string, Set<? extends RegexOption> set) {
        Intrinsics.checkNotNullParameter(string, "");
        Intrinsics.checkNotNullParameter(set, "");
        Pattern pattern = Pattern.compile(string, Regex.Companion.ensureUnicodeCase(RegexKt.access$toInt(set)));
        Intrinsics.checkNotNullExpressionValue(pattern, "");
        this(pattern);
    }

    public final String getPattern() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final Set<RegexOption> getOptions() {
        Set<RegexOption> set = this._options;
        if (set == null) {
            Set<RegexOption> set2;
            int n = this.nativePattern.flags();
            EnumSet<RegexOption> enumSet = set2 = EnumSet.allOf(RegexOption.class);
            Intrinsics.checkNotNull(set2);
            CollectionsKt.retainAll((Iterable)enumSet, (Function1)new Function1<RegexOption, Boolean>(n){
                final /* synthetic */ int $value;
                {
                    this.$value = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Enum enum_) {
                    return (this.$value & ((FlagEnum)((Object)enum_)).getMask()) == ((FlagEnum)((Object)enum_)).getValue();
                }
            });
            Set set3 = Collections.unmodifiableSet((Set)set2);
            Intrinsics.checkNotNullExpressionValue(set3, "");
            Set set4 = set3;
            set2 = set3;
            this._options = set2;
            set = set4;
        }
        return set;
    }

    public final boolean matches(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).matches();
    }

    public final boolean containsMatchIn(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).find();
    }

    public final MatchResult find(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$findNext(matcher, n, charSequence);
    }

    public static /* synthetic */ MatchResult find$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.find(charSequence, n);
    }

    public final Sequence<MatchResult> findAll(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        if (n < 0 || n > charSequence.length()) {
            throw new IndexOutOfBoundsException("Start index out of bounds: " + n + ", input length: " + charSequence.length());
        }
        return SequencesKt.generateSequence(() -> Regex.findAll$lambda$1(this, charSequence, n), (Function1)findAll.2.INSTANCE);
    }

    public static /* synthetic */ Sequence findAll$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.findAll(charSequence, n);
    }

    public final MatchResult matchEntire(CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence);
        Intrinsics.checkNotNullExpressionValue(matcher, "");
        return RegexKt.access$matchEntire(matcher, charSequence);
    }

    public final MatchResult matchAt(CharSequence charSequence, int n) {
        MatcherMatchResult matcherMatchResult;
        Intrinsics.checkNotNullParameter(charSequence, "");
        Matcher matcher = this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length());
        if (matcher.lookingAt()) {
            Intrinsics.checkNotNull(matcher);
            matcherMatchResult = new MatcherMatchResult(matcher, charSequence);
        } else {
            matcherMatchResult = null;
        }
        return matcherMatchResult;
    }

    public final boolean matchesAt(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        return this.nativePattern.matcher(charSequence).useAnchoringBounds(false).useTransparentBounds(true).region(n, charSequence.length()).lookingAt();
    }

    public final String replace(CharSequence charSequence, String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceAll(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public final String replace(CharSequence charSequence, Function1<? super MatchResult, ? extends CharSequence> function1) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(function1, "");
        MatchResult matchResult = Regex.find$default(this, charSequence, 0, 2, null);
        if (matchResult == null) {
            return ((Object)charSequence).toString();
        }
        MatchResult matchResult2 = matchResult;
        int n = 0;
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        do {
            stringBuilder.append(charSequence, n, (int)matchResult2.getRange().getStart());
            stringBuilder.append(function1.invoke(matchResult2));
            n = matchResult2.getRange().getEndInclusive() + 1;
            matchResult2 = matchResult2.next();
        } while (n < n2 && matchResult2 != null);
        if (n < n2) {
            stringBuilder.append(charSequence, n, n2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final String replaceFirst(CharSequence charSequence, String string) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        Intrinsics.checkNotNullParameter(string, "");
        String string2 = this.nativePattern.matcher(charSequence).replaceFirst(string);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public final List<String> split(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n);
        Matcher matcher = this.nativePattern.matcher(charSequence);
        if (n == 1 || !matcher.find()) {
            return CollectionsKt.listOf(((Object)charSequence).toString());
        }
        ArrayList<String> arrayList = new ArrayList<String>(n > 0 ? RangesKt.coerceAtMost(n, 10) : 10);
        int n2 = 0;
        --n;
        do {
            arrayList.add(((Object)charSequence.subSequence(n2, matcher.start())).toString());
            n2 = matcher.end();
        } while ((n < 0 || arrayList.size() != n) && matcher.find());
        arrayList.add(((Object)charSequence.subSequence(n2, charSequence.length())).toString());
        return arrayList;
    }

    public static /* synthetic */ List split$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.split(charSequence, n);
    }

    public final Sequence<String> splitToSequence(CharSequence charSequence, int n) {
        Intrinsics.checkNotNullParameter(charSequence, "");
        StringsKt.requireNonNegativeLimit(n);
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, charSequence, n, null){
            Object L$1;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Regex this$0;
            final /* synthetic */ CharSequence $input;
            final /* synthetic */ int $limit;
            {
                this.this$0 = regex;
                this.$input = charSequence;
                this.$limit = n;
                super(2, continuation);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_3 = (SequenceScope)this.L$0;
                var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        var3_5 = Regex.access$getNativePattern$p(this.this$0).matcher(this.$input);
                        if (this.$limit != 1 && var3_5.find()) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable(var2_3);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(var3_5);
                        this.label = 1;
                        if (var2_3.yield(this.$input.toString(), this) == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        (Matcher)this.L$1;
                        ResultKt.throwOnFailure(var1_1);
lbl18:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                var1_2 = 0;
                var4_6 = 0;
                while (true) {
                    this.L$0 = var2_3;
                    this.L$1 = var3_5;
                    this.I$0 = var1_2;
                    this.I$1 = var4_6;
                    this.label = 2;
                    if (var2_3.yield(this.$input.subSequence(var1_2, var3_5.start()).toString(), this) == var5_4) {
                        return var5_4;
                    }
                    ** GOTO lbl35
                    break;
                }
                {
                    case 2: {
                        var4_6 = this.I$1;
                        var3_5 = (Matcher)this.L$1;
                        ResultKt.throwOnFailure(var1_1);
lbl35:
                        // 2 sources

                        var1_2 = var3_5.end();
                        if (++var4_6 != this.$limit - 1 && var3_5.find()) ** continue;
                        v0 = this.$input;
                        this.L$0 = SpillingKt.nullOutSpilledVariable(var2_3);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(var3_5);
                        this.I$0 = var1_2;
                        this.I$1 = var4_6;
                        this.label = 3;
                        if (var2_3.yield(v0.subSequence(var1_2, v0.length()).toString(), this) == var5_4) {
                            return var5_4;
                        }
                        ** GOTO lbl52
                    }
                    case 3: {
                        (Matcher)this.L$1;
                        ResultKt.throwOnFailure(var1_1);
lbl52:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> function2) {
                function2 = new /* invalid duplicate definition of identical inner class */;
                v0.L$0 = object;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> sequenceScope, Continuation<? super Unit> continuation) {
                return (((BaseContinuationImpl)this).create(sequenceScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static /* synthetic */ Sequence splitToSequence$default(Regex regex, CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return regex.splitToSequence(charSequence, n);
    }

    public final String toString() {
        String string = this.nativePattern.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public final Pattern toPattern() {
        return this.nativePattern;
    }

    private final Object writeReplace() {
        String string = this.nativePattern.pattern();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return new Serialized(string, this.nativePattern.flags());
    }

    private final void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Deserialization is supported via proxy only");
    }

    private static final MatchResult findAll$lambda$1(Regex regex, CharSequence charSequence, int n) {
        return regex.find(charSequence, n);
    }

    public static final /* synthetic */ Pattern access$getNativePattern$p(Regex regex) {
        return regex.nativePattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lkotlin/text/Regex$Companion;", "", "<init>", "()V", "fromLiteral", "Lkotlin/text/Regex;", "literal", "", "escape", "escapeReplacement", "ensureUnicodeCase", "", "flags", "kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        public final Regex fromLiteral(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            return new Regex(string, RegexOption.LITERAL);
        }

        public final String escape(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            String string2 = Pattern.quote(string);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return string2;
        }

        public final String escapeReplacement(String string) {
            Intrinsics.checkNotNullParameter(string, "");
            String string2 = Matcher.quoteReplacement(string);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return string2;
        }

        private final int ensureUnicodeCase(int n) {
            if ((n & 2) != 0) {
                return n | 0x40;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00060\u0001j\u0002`\u0002:\u0001\u000fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lkotlin/text/Regex$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "pattern", "", "flags", "", "<init>", "(Ljava/lang/String;I)V", "getPattern", "()Ljava/lang/String;", "getFlags", "()I", "readResolve", "", "Companion", "kotlin-stdlib"})
    private static final class Serialized
    implements Serializable {
        public static final Companion Companion = new Companion(null);
        private final String pattern;
        private final int flags;
        private static final long serialVersionUID = 0L;

        public Serialized(String string, int n) {
            Intrinsics.checkNotNullParameter(string, "");
            this.pattern = string;
            this.flags = n;
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final int getFlags() {
            return this.flags;
        }

        private final Object readResolve() {
            Pattern pattern = Pattern.compile(this.pattern, this.flags);
            Intrinsics.checkNotNullExpressionValue(pattern, "");
            return new Regex(pattern);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lkotlin/text/Regex$Serialized$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kotlin-stdlib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }
        }
    }
}

