/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J[\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\"\u001a\u00020#J\u0013\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010&\u001a\u00020#J\t\u0010'\u001a\u00020(H\u00d6\u0001J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u0006+"}, d2={"Lorg/jetbrains/exposed/sql/Schema;", "", "name", "", "authorization", "password", "defaultTablespace", "temporaryTablespace", "quota", "on", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAuthorization", "()Ljava/lang/String;", "ddl", "", "getDdl", "()Ljava/util/List;", "getDefaultTablespace", "identifier", "getIdentifier", "getOn", "getPassword", "getQuota", "getTemporaryTablespace", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createStatement", "dropStatement", "cascade", "", "equals", "other", "exists", "hashCode", "", "setSchemaStatement", "toString", "exposed-core"})
public final class Schema {
    private final String name;
    private final String authorization;
    private final String password;
    private final String defaultTablespace;
    private final String temporaryTablespace;
    private final String quota;
    private final String on;

    public Schema(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.name = string;
        this.authorization = string2;
        this.password = string3;
        this.defaultTablespace = string4;
        this.temporaryTablespace = string5;
        this.quota = string6;
        this.on = string7;
    }

    public /* synthetic */ Schema(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        if ((n & 0x40) != 0) {
            string7 = null;
        }
        this(string, string2, string3, string4, string5, string6, string7);
    }

    public final String getAuthorization() {
        return this.authorization;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getDefaultTablespace() {
        return this.defaultTablespace;
    }

    public final String getTemporaryTablespace() {
        return this.temporaryTablespace;
    }

    public final String getQuota() {
        return this.quota;
    }

    public final String getOn() {
        return this.on;
    }

    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    public final List<String> getDdl() {
        return this.createStatement();
    }

    public final boolean exists() {
        return DatabaseDialectKt.getCurrentDialect().schemaExists(this);
    }

    public final List<String> createStatement() {
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create schema statement", DatabaseDialectKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DatabaseDialectKt.getCurrentDialect().createSchema(this));
    }

    public final List<String> dropStatement(boolean bl) {
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop schema statement", DatabaseDialectKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DatabaseDialectKt.getCurrentDialect().dropSchema(this, bl));
    }

    public final List<String> setSchemaStatement() {
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSchema()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support schemas", DatabaseDialectKt.getCurrentDialect());
        }
        return CollectionsKt.listOf((Object)DatabaseDialectKt.getCurrentDialect().setSchema(this));
    }

    private final String component1() {
        return this.name;
    }

    public final String component2() {
        return this.authorization;
    }

    public final String component3() {
        return this.password;
    }

    public final String component4() {
        return this.defaultTablespace;
    }

    public final String component5() {
        return this.temporaryTablespace;
    }

    public final String component6() {
        return this.quota;
    }

    public final String component7() {
        return this.on;
    }

    public final Schema copy(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return new Schema(string, string2, string3, string4, string5, string6, string7);
    }

    public static /* synthetic */ Schema copy$default(Schema schema, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, Object object) {
        if ((n & 1) != 0) {
            string = schema.name;
        }
        if ((n & 2) != 0) {
            string2 = schema.authorization;
        }
        if ((n & 4) != 0) {
            string3 = schema.password;
        }
        if ((n & 8) != 0) {
            string4 = schema.defaultTablespace;
        }
        if ((n & 0x10) != 0) {
            string5 = schema.temporaryTablespace;
        }
        if ((n & 0x20) != 0) {
            string6 = schema.quota;
        }
        if ((n & 0x40) != 0) {
            string7 = schema.on;
        }
        return schema.copy(string, string2, string3, string4, string5, string6, string7);
    }

    public final String toString() {
        return "Schema(name=" + this.name + ", authorization=" + this.authorization + ", password=" + this.password + ", defaultTablespace=" + this.defaultTablespace + ", temporaryTablespace=" + this.temporaryTablespace + ", quota=" + this.quota + ", on=" + this.on + ')';
    }

    public final int hashCode() {
        int n = this.name.hashCode();
        n = n * 31 + (this.authorization == null ? 0 : this.authorization.hashCode());
        n = n * 31 + (this.password == null ? 0 : this.password.hashCode());
        n = n * 31 + (this.defaultTablespace == null ? 0 : this.defaultTablespace.hashCode());
        n = n * 31 + (this.temporaryTablespace == null ? 0 : this.temporaryTablespace.hashCode());
        n = n * 31 + (this.quota == null ? 0 : this.quota.hashCode());
        n = n * 31 + (this.on == null ? 0 : this.on.hashCode());
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Schema)) {
            return false;
        }
        object = (Schema)object;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Schema)object).name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authorization, (Object)((Schema)object).authorization)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)((Schema)object).password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultTablespace, (Object)((Schema)object).defaultTablespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.temporaryTablespace, (Object)((Schema)object).temporaryTablespace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.quota, (Object)((Schema)object).quota)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.on, (Object)((Schema)object).on);
    }
}

