/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J:\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010!\u001a\u00020\b\"\n\b\u0000\u0010\t*\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0010H\u0016JW\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u001e\u0010*\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0006\u0012\u0004\u0018\u00010,0+0\u001e2\b\u0010-\u001a\u0004\u0018\u00010\r2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010/2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00100R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u00061"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "isH2Oracle", "", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "(Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;)Z", "arraySlice", "", "T", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "lower", "", "upper", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "(Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "explain", "", "analyze", "options", "internalStatement", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "insert", "ignore", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "expr", "locate", "substring", "nextVal", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "builder", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "Lkotlin/Pair;", "", "limit", "where", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "exposed-core"})
public final class H2FunctionProvider
extends FunctionProvider {
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    private final boolean isH2Oracle(DatabaseDialect databaseDialect) {
        return H2Kt.getH2Mode(databaseDialect) == H2Dialect.H2CompatibilityMode.Oracle;
    }

    @Override
    public final void nextVal(Sequence sequence, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        DatabaseDialect databaseDialect = TransactionManager.Companion.current().getDb().getDialect();
        Intrinsics.checkNotNull((Object)databaseDialect);
        switch (WhenMappings.$EnumSwitchMapping$0[((H2Dialect)databaseDialect).getMajorVersion$exposed_core().ordinal()]) {
            case 1: {
                super.nextVal(sequence, queryBuilder);
                return;
            }
            case 2: {
                queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(sequence){
                    final /* synthetic */ Sequence $seq;
                    {
                        this.$seq = sequence;
                        super(1);
                    }

                    public final void invoke(QueryBuilder queryBuilder) {
                        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                        queryBuilder.append("NEXT VALUE FOR " + this.$seq.getIdentifier());
                    }
                }));
                return;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public final <T> void arraySlice(Expression<T> expression, Integer n, Integer n2, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression, n, n2){
            final /* synthetic */ Expression<T> $expression;
            final /* synthetic */ Integer $lower;
            final /* synthetic */ Integer $upper;
            {
                this.$expression = expression;
                this.$lower = n;
                this.$upper = n2;
                super(1);
            }

            public final void invoke(QueryBuilder objectArray) {
                Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[3];
                objectArray = objectArray3;
                objectArray3[0] = "ARRAY_SLICE(";
                objectArray[1] = this.$expression;
                objectArray[2] = "," + this.$lower + ',' + this.$upper + ')';
                ExpressionKt.append((QueryBuilder)objectArray2, objectArray);
            }
        }));
    }

    @Override
    public final String insert(boolean bl, Table table, List<? extends Column<?>> list, String string, Transaction transaction2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Set set = new LinkedHashSet();
        Object object = table.getIndices();
        Object object2 = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            Index index = (Index)e;
            if (!index.getUnique()) continue;
            object2.add(e);
        }
        object = (List)object2;
        object = object.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            object2 = (Index)object2;
            object2 = ((Index)object2).getColumns();
            CollectionsKt.addAll((Collection)set, object2);
        }
        Object[] objectArray = table.getPrimaryKey();
        if (objectArray != null && (objectArray = objectArray.getColumns()) != null) {
            object2 = objectArray;
            CollectionsKt.addAll((Collection)set, (Object[])object2);
        }
        DatabaseDialect databaseDialect = transaction2.getDb().getDialect();
        Intrinsics.checkNotNull((Object)databaseDialect);
        object = (H2Dialect)databaseDialect;
        object2 = ((H2Dialect)object).getVersion$exposed_core();
        boolean bl3 = bl2 = ((H2Dialect)object).getH2Mode() == H2Dialect.H2CompatibilityMode.MySQL;
        if (bl && !((Collection)set).isEmpty() && bl2 && ((String)object2).compareTo("1.4.197") < 0) {
            object2 = super.insert(false, table, list, string, transaction2);
            return (String)object2 + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = transaction2;
                    super(1);
                }

                public final CharSequence invoke(Column<?> column) {
                    Intrinsics.checkNotNullParameter(column, (String)"");
                    return this.$transaction.identity(column) + "=VALUES(" + this.$transaction.identity(column) + ')';
                }
            }, (int)31, null);
        }
        if (bl && !((Collection)set).isEmpty() && bl2) {
            return StringsKt.replace$default((String)super.insert(false, table, list, string, transaction2), (String)"INSERT", (String)"INSERT IGNORE", (boolean)false, (int)4, null);
        }
        if (bl) {
            ExceptionsKt.throwUnsupportedException(transaction2, "INSERT IGNORE supported only on H2 v1.4.197+ with MODE=MYSQL.");
            throw new KotlinNothingValueException();
        }
        return super.insert(bl, table, list, string, transaction2);
    }

    @Override
    public final String update(Join join, List<? extends Pair<? extends Column<?>, ? extends Object>> list, Integer op, Op<Boolean> op2, Transaction transaction2) {
        QueryBuilder queryBuilder;
        block7: {
            Op<Boolean> op3;
            Object object;
            Intrinsics.checkNotNullParameter((Object)join, (String)"");
            Intrinsics.checkNotNullParameter(list, (String)"");
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
            queryBuilder = new QueryBuilder(true);
            if (op != null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            if (op2 != null && !INSTANCE.isH2Oracle(transaction2.getDb().getDialect())) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support WHERE in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            op = list;
            Object object2 = op;
            op = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)op), (int)10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                object = (Pair)object;
                op3 = op;
                op3.add(((Column)object.getFirst()).getTable());
            }
            Table table = (Table)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)((Object)op))));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            object = table;
            Join.JoinPart joinPart = (Join.JoinPart)CollectionsKt.singleOrNull(join.getJoinParts$exposed_core());
            if (joinPart == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with only one table to join.");
                throw new KotlinNothingValueException();
            }
            op3 = joinPart;
            if (joinPart.getJoinType() != JoinType.INNER) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            queryBuilder.unaryPlus("MERGE INTO ");
            ((ColumnSet)object).describe(transaction2, queryBuilder);
            queryBuilder.unaryPlus(" USING ");
            op = ((Join.JoinPart)((Object)op3)).getJoinPart();
            object2 = op;
            Op<Boolean> op4 = !Intrinsics.areEqual((Object)op, (Object)object) ? op : null;
            if (op4 == null) {
                op4 = join.getTable();
            }
            ((ColumnSet)((Object)op4)).describe(transaction2, queryBuilder);
            queryBuilder.unaryPlus(" ON ");
            ((Join.JoinPart)((Object)op3)).appendConditions(queryBuilder);
            queryBuilder.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
            ExpressionKt.appendTo$default(list, queryBuilder, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = transaction2;
                    super(2);
                }

                public final void invoke(QueryBuilder queryBuilder, Pair<? extends Column<?>, ? extends Object> object) {
                    Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                    Intrinsics.checkNotNullParameter(object, (String)"");
                    Column column = (Column)object.component1();
                    object = object.component2();
                    queryBuilder.append(this.$transaction.fullIdentity(column) + '=');
                    queryBuilder.registerArgument(column, object);
                }
            }, 14, null);
            Op<Boolean> op5 = op2;
            if (op5 == null) break block7;
            op = op5;
            queryBuilder.unaryPlus(" WHERE ");
            queryBuilder.unaryPlus((Expression)op);
        }
        return queryBuilder.toString();
    }

    @Override
    public final <T extends String> void locate(QueryBuilder queryBuilder, Expression<T> expression, String string) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(string, expression){
            final /* synthetic */ String $substring;
            final /* synthetic */ Expression<T> $expr;
            {
                this.$substring = string;
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder objectArray) {
                Intrinsics.checkNotNullParameter((Object)objectArray, (String)"");
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[5];
                objectArray = objectArray3;
                objectArray3[0] = "LOCATE('";
                objectArray[1] = this.$substring;
                objectArray[2] = "',";
                objectArray[3] = this.$expr;
                objectArray[4] = ")";
                ExpressionKt.append((QueryBuilder)objectArray2, objectArray);
            }
        }));
    }

    @Override
    public final String explain(boolean bl, String string, String string2, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        if (string != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "H2 does not support options other than ANALYZE in EXPLAIN queries.");
            throw new KotlinNothingValueException();
        }
        return super.explain(bl, null, string2, transaction2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2MajorVersion.values().length];
            try {
                nArray[H2Dialect.H2MajorVersion.One.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[H2Dialect.H2MajorVersion.Two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

