/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.marshalling.ChannelBufferByteInput;
import io.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.jboss.marshalling.ByteInput;

public class MarshallingDecoder
extends LengthFieldBasedFrameDecoder {
    private final UnmarshallerProvider provider;

    public MarshallingDecoder(UnmarshallerProvider unmarshallerProvider) {
        this(unmarshallerProvider, 0x100000);
    }

    public MarshallingDecoder(UnmarshallerProvider unmarshallerProvider, int n) {
        super(n, 0, 4, 0, 4);
        this.provider = unmarshallerProvider;
    }

    @Override
    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf object) {
        if ((object = (ByteBuf)super.decode(channelHandlerContext, (ByteBuf)object)) == null) {
            return null;
        }
        channelHandlerContext = this.provider.getUnmarshaller(channelHandlerContext);
        object = new ChannelBufferByteInput((ByteBuf)object);
        try {
            channelHandlerContext.start((ByteInput)object);
            object = channelHandlerContext.readObject();
            channelHandlerContext.finish();
            return object;
        }
        finally {
            channelHandlerContext.close();
        }
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n, int n2) {
        return byteBuf.slice(n, n2);
    }
}

